/*
 * Decompiled with CFR 0.152.
 */
package ic2.core.item.armor.electric;

import ic2.core.IC2;
import ic2.core.block.generator.tile.TileEntitySolarPanel;
import ic2.core.item.armor.base.ItemIC2AdvArmorBase;
import ic2.core.item.manager.ElectricItemManager;
import ic2.core.platform.lang.components.base.LocaleComp;
import ic2.core.platform.lang.storage.Ic2InfoLang;
import ic2.core.platform.lang.storage.Ic2ItemLang;
import ic2.core.platform.registry.Ic2Items;
import ic2.core.platform.textures.Ic2Icons;
import ic2.core.util.obj.IBootable;
import ic2.core.util.obj.ToolTipType;
import java.util.Arrays;
import java.util.List;
import java.util.Map;
import net.minecraft.client.renderer.texture.TextureAtlasSprite;
import net.minecraft.creativetab.CreativeTabs;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.inventory.EntityEquipmentSlot;
import net.minecraft.item.EnumRarity;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.util.NonNullList;
import net.minecraft.world.World;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;

public class ItemArmorSolarHelmet
extends ItemIC2AdvArmorBase
implements IBootable {
    public ItemArmorSolarHelmet() {
        super(-1, EntityEquipmentSlot.HEAD);
        this.setUnlocalizedName(Ic2ItemLang.solarHelmetItem);
        this.func_77627_a(true);
        this.func_77656_e(0);
    }

    @Override
    public void onLoad() {
        Ic2Items.solarHelmet = new ItemStack((Item)this, 1, 0);
        Ic2Items.advSolarHelmet = new ItemStack((Item)this, 1, 1);
    }

    @Override
    public String getTexture() {
        return "ic2:textures/models/armor/solar";
    }

    @Override
    public ItemStack getRepairItem() {
        return ItemStack.field_190927_a;
    }

    @Override
    public List<Integer> getValidVariants() {
        return Arrays.asList(0, 1);
    }

    @Override
    @SideOnly(value=Side.CLIENT)
    public TextureAtlasSprite getTexture(int meta) {
        return Ic2Icons.getTextures("i2")[32 + meta];
    }

    @Override
    public void onSortedItemToolTip(ItemStack stack, EntityPlayer player, boolean debugTooltip, List<String> tooltip, Map<ToolTipType, List<String>> sortedTooltip) {
        super.onSortedItemToolTip(stack, player, debugTooltip, tooltip, sortedTooltip);
        sortedTooltip.get((Object)ToolTipType.Shift).add(Ic2InfoLang.solarHelmetProduction.getLocalizedFormatted(this.getProduction(stack)));
    }

    public void onArmorTick(World world, EntityPlayer player, ItemStack itemStack) {
        if (IC2.platform.isRendering()) {
            return;
        }
        if (TileEntitySolarPanel.isSunVisible(world, player.func_180425_c())) {
            ElectricItemManager.chargeArmor(player, this.getProduction(itemStack));
        }
    }

    public EnumRarity func_77613_e(ItemStack stack) {
        if (stack.func_77960_j() == 1) {
            return EnumRarity.UNCOMMON;
        }
        return super.func_77613_e(stack);
    }

    public int getProduction(ItemStack stack) {
        return stack.func_77960_j() == 0 ? 1 : 5;
    }

    @Override
    public LocaleComp getLangComponent(ItemStack stack) {
        switch (stack.func_77960_j()) {
            case 0: {
                return Ic2ItemLang.solarHelmet;
            }
            case 1: {
                return Ic2ItemLang.solarHelmetAdv;
            }
        }
        return super.getLangComponent(stack);
    }

    public void func_150895_a(CreativeTabs tab, NonNullList<ItemStack> subItems) {
        if (!this.func_194125_a(tab)) {
            return;
        }
        subItems.add((Object)new ItemStack((Item)this, 1, 0));
        subItems.add((Object)new ItemStack((Item)this, 1, 1));
    }
}

