/*
 * Decompiled with CFR 0.152.
 */
package ic2.core.block.wiring.tile;

import ic2.api.classic.energy.tile.IEnergyConductorColored;
import ic2.api.classic.energy.tile.IInsulationModifieableConductor;
import ic2.api.classic.network.adv.NetworkField;
import ic2.api.energy.EnergyNet;
import ic2.api.energy.event.EnergyTileLoadEvent;
import ic2.api.energy.event.EnergyTileUnloadEvent;
import ic2.api.energy.tile.IEnergyAcceptor;
import ic2.api.energy.tile.IEnergyEmitter;
import ic2.api.energy.tile.IEnergySink;
import ic2.api.energy.tile.IEnergyTile;
import ic2.api.energy.tile.IMetaDelegate;
import ic2.api.info.ILocatable;
import ic2.api.network.INetworkTileEntityEventListener;
import ic2.core.block.base.tile.TileEntityBlock;
import ic2.core.block.render.model.MultiPartLuminatorModel;
import ic2.core.block.wiring.cables.CableContainer;
import ic2.core.block.wiring.cables.WireRegistry;
import ic2.core.block.wiring.tile.TileEntityCable;
import ic2.core.block.wiring.tile.TileEntityLuminator;
import ic2.core.energy.EnergyNetLocal;
import ic2.core.platform.registry.Ic2Items;
import ic2.core.platform.registry.Ic2States;
import ic2.core.util.misc.StackUtil;
import ic2.core.util.obj.IItemContainer;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.EnumSet;
import java.util.List;
import java.util.Set;
import net.minecraft.block.Block;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.init.Blocks;
import net.minecraft.item.ItemDye;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTBase;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.nbt.NBTTagList;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.EnumActionResult;
import net.minecraft.util.EnumFacing;
import net.minecraft.util.ITickable;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.Vec3d;
import net.minecraft.world.EnumSkyBlock;
import net.minecraft.world.World;
import net.minecraftforge.common.MinecraftForge;
import net.minecraftforge.fml.common.eventhandler.Event;

public class TileEntityMultipartLuminator
extends TileEntityBlock
implements IEnergyConductorColored,
IInsulationModifieableConductor,
IEnergySink,
ITickable,
IItemContainer,
ILocatable {
    @NetworkField(index=3, compression=NetworkField.BitLevel.Bit8)
    public boolean[] lamps = new boolean[6];
    public Set<EnumFacing> iterator = EnumSet.noneOf(EnumFacing.class);
    @NetworkField(index=4, compression=NetworkField.BitLevel.Bit8)
    public byte[] connections = new byte[6];
    public int energy = 0;
    @NetworkField(index=5, compression=NetworkField.BitLevel.Bit8)
    public int[] colors = new int[]{-1, -1, -1, -1, -1, -1};
    @NetworkField(index=6)
    public ItemStack cable = ItemStack.field_190927_a;
    @NetworkField(index=7)
    public IEnergyConductorColored.WireColor cableColor = IEnergyConductorColored.WireColor.Blank;
    public boolean addedToEnergyNet;
    public CableContainer localData;
    public int current = 0;
    public int ticker = 0;
    public static WireRegistry registry = WireRegistry.instance;

    public TileEntityMultipartLuminator() {
        this.addNetworkFields("connections", "lamps", "cable", "cableColor", "colors");
    }

    public CableContainer getData() {
        if (this.localData == null) {
            this.localData = WireRegistry.instance.getContainerFromMeta(this.cable.func_190926_b() ? 0 : this.cable.func_77960_j());
        }
        return this.localData;
    }

    public boolean canBeColored() {
        CableContainer data = this.getData();
        return data.getInfo().canColorWithoutInsulation() ? true : data.getInsulation() > 0;
    }

    public boolean canConnect(int side) {
        return this.connections[side] == 1;
    }

    public boolean hasSide(int side) {
        return this.lamps[side];
    }

    @Override
    public BlockPos getPosition() {
        return this.func_174877_v();
    }

    @Override
    public World getWorldObj() {
        return this.getWorldObj();
    }

    @Override
    public void onNetworkUpdate(String field) {
        super.onNetworkUpdate(field);
        if (field.equals("connections") || field.equals("cable") || field.equals("lamps") || field.equals("colors") || field.equals("cableColor")) {
            this.field_145850_b.func_175704_b(this.func_174877_v(), this.func_174877_v());
        }
        if (field.equals("isActive")) {
            this.field_145850_b.func_175704_b(this.func_174877_v(), this.func_174877_v());
            this.field_145850_b.func_180500_c(EnumSkyBlock.BLOCK, this.func_174877_v());
        }
    }

    @Override
    public void onBlockUpdate(Block block) {
        byte[] array = new byte[6];
        for (EnumFacing dir : EnumFacing.field_82609_l) {
            IEnergyTile tile = EnergyNet.instance.getTile(this.func_145831_w(), this.func_174877_v().func_177972_a(dir));
            if (tile == null) continue;
            array[dir.func_176745_a()] = (byte)(this.canInteractWith(tile, dir) ? 1 : 0);
        }
        if (!Arrays.equals(this.connections, array)) {
            this.connections = array;
            this.getNetwork().updateTileEntityField(this, "connections");
        }
    }

    public boolean canInteractWith(IEnergyTile te, EnumFacing dir) {
        if (this.lamps[dir.func_176745_a()]) {
            return false;
        }
        if (te instanceof TileEntityCable) {
            return this.canInteractWithCable((TileEntityCable)te);
        }
        if (te instanceof TileEntityMultipartLuminator) {
            return !((TileEntityMultipartLuminator)te).hasSide(dir.func_176734_d().func_176745_a()) && this.canInteractWithAPICable((IEnergyConductorColored)te);
        }
        if (te instanceof IEnergyConductorColored) {
            return this.canInteractWithAPICable((IEnergyConductorColored)te);
        }
        if (te instanceof TileEntityLuminator) {
            return ((TileEntityLuminator)te).acceptsEnergyFrom(this, dir.func_176734_d());
        }
        if (te instanceof IEnergyAcceptor && !(te instanceof IEnergyEmitter)) {
            return ((IEnergyAcceptor)te).acceptsEnergyFrom(this, dir.func_176734_d());
        }
        if (te instanceof IEnergyEmitter && !(te instanceof IEnergyAcceptor)) {
            return ((IEnergyEmitter)te).emitsEnergyTo(this, dir.func_176734_d());
        }
        if (te instanceof IEnergyAcceptor && te instanceof IEnergyEmitter) {
            return ((IEnergyEmitter)te).emitsEnergyTo(this, dir.func_176734_d()) || ((IEnergyAcceptor)te).acceptsEnergyFrom(this, dir.func_176734_d());
        }
        return te instanceof IMetaDelegate || te instanceof INetworkTileEntityEventListener;
    }

    public boolean canInteractWithAPICable(IEnergyConductorColored cable) {
        return this.cableColor == IEnergyConductorColored.WireColor.Blank || cable.getConductorColor() == IEnergyConductorColored.WireColor.Blank || this.cableColor == cable.getConductorColor();
    }

    public boolean canInteractWithCable(TileEntityCable cable) {
        return this.cableColor == IEnergyConductorColored.WireColor.Blank || cable.cableColor == IEnergyConductorColored.WireColor.Blank || this.cableColor == cable.cableColor;
    }

    @Override
    public double getConductionLoss() {
        CableContainer data = this.getData();
        return data.getInfo().getConductorLoss(data.getInsulation());
    }

    @Override
    public double getInsulationEnergyAbsorption() {
        CableContainer data = this.getData();
        return data.getInfo().getInsulationEnergyAbsorption(data.getInsulation());
    }

    @Override
    public double getInsulationBreakdownEnergy() {
        CableContainer data = this.getData();
        return data.getInfo().getInsulationBreakdownEnergy(data.getInsulation());
    }

    @Override
    public double getConductorBreakdownEnergy() {
        CableContainer data = this.getData();
        return data.getInfo().getConductorBreakdownEnergy(data.getInsulation());
    }

    @Override
    public void removeInsulation() {
        CableContainer data = this.getData();
        int newInsulation = data.getInfo().removeAllInsulation(data.getInsulation());
        if (newInsulation != data.getInsulation()) {
            this.changeInsulation(newInsulation);
        }
    }

    @Override
    public void removeConductor() {
        boolean burn = EnergyNetLocal.burn && this.field_145850_b.field_73012_v.nextFloat() < EnergyNetLocal.chance;
        this.field_145850_b.func_175698_g(this.func_174877_v());
        if (burn) {
            this.field_145850_b.func_175656_a(this.func_174877_v(), Blocks.field_150480_ab.func_176223_P());
        }
    }

    @Override
    public boolean acceptsEnergyFrom(IEnergyEmitter emitter, EnumFacing side) {
        if (this.hasSide(side.func_176745_a())) {
            return false;
        }
        return this.canConnect(side.func_176745_a());
    }

    @Override
    public boolean emitsEnergyTo(IEnergyAcceptor receiver, EnumFacing side) {
        if (this.hasSide(side.func_176745_a())) {
            return false;
        }
        return this.canConnect(side.func_176745_a());
    }

    @Override
    public boolean tryAddInsulation() {
        CableContainer data = this.getData();
        int newInsulation = data.getInfo().addInsulation(data.getInsulation());
        if (newInsulation != data.getInsulation()) {
            this.changeInsulation(newInsulation);
            return true;
        }
        return false;
    }

    @Override
    public boolean tryRemoveInsulation() {
        CableContainer data = this.getData();
        int newInsulation = data.getInfo().removeInsulation(data.getInsulation());
        if (newInsulation != data.getInsulation()) {
            this.changeInsulation(newInsulation);
            return true;
        }
        return false;
    }

    @Override
    public IEnergyConductorColored.WireColor getConductorColor() {
        return this.cableColor;
    }

    public void changeInsulation(int newLevel) {
        CableContainer data = this.getData();
        if (data.getInsulation() == newLevel) {
            return;
        }
        if (this.addedToEnergyNet) {
            MinecraftForge.EVENT_BUS.post((Event)new EnergyTileUnloadEvent(this));
        }
        this.addedToEnergyNet = false;
        this.cable.func_77964_b(registry.getMetaFromType(data.getType(), newLevel));
        this.localData = null;
        if (!this.canBeColored()) {
            this.cableColor = IEnergyConductorColored.WireColor.Blank;
        }
        MinecraftForge.EVENT_BUS.post((Event)new EnergyTileLoadEvent(this));
        this.addedToEnergyNet = true;
        this.getNetwork().updateTileEntityField(this, "cable");
    }

    @Override
    public double getDemandedEnergy() {
        return 50 - this.energy;
    }

    @Override
    public int getSinkTier() {
        return 4;
    }

    @Override
    public double injectEnergy(EnumFacing directionFrom, double amount, double voltage) {
        if (amount > 2048.0) {
            return 0.0;
        }
        if (amount <= 0.0) {
            return 0.0;
        }
        int oldEnergy = this.energy;
        oldEnergy = (int)((double)oldEnergy + amount);
        int re = 0;
        if (oldEnergy > 50) {
            re = oldEnergy - 50;
            oldEnergy = 50;
        }
        this.energy = oldEnergy;
        return re;
    }

    @Override
    public void onLoaded() {
        super.onLoaded();
        if (!this.addedToEnergyNet && this.isSimulating()) {
            MinecraftForge.EVENT_BUS.post((Event)new EnergyTileLoadEvent(this));
            this.addedToEnergyNet = true;
        }
    }

    @Override
    public void onUnloaded() {
        if (this.addedToEnergyNet && this.isSimulating()) {
            MinecraftForge.EVENT_BUS.post((Event)new EnergyTileUnloadEvent(this));
            this.addedToEnergyNet = false;
        }
        super.onUnloaded();
    }

    @Override
    public boolean canUpdate() {
        return this.isSimulating();
    }

    public void func_73660_a() {
        if (this.ticker++ % 20 == 0) {
            boolean newActive = false;
            if (this.energy > 0) {
                this.energy -= this.iterator.size();
                if (this.energy < 0) {
                    this.energy = 0;
                }
                newActive = true;
            }
            this.setActive(newActive);
        }
    }

    @Override
    public List<ItemStack> getDrops() {
        ArrayList<ItemStack> items = new ArrayList<ItemStack>();
        if (this.cable != null) {
            items.add(this.cable.func_77946_l());
        } else {
            items.add(Ic2Items.copperCable.func_77946_l());
        }
        return items;
    }

    @Override
    public boolean canRemoveBlock(EntityPlayer player) {
        return false;
    }

    @Override
    public boolean canSetFacing(EntityPlayer player, EnumFacing facing) {
        return false;
    }

    @Override
    public boolean hasSpecialAction(EntityPlayer player, EnumFacing facing, Vec3d hit) {
        return this.hasSide(facing.func_176745_a());
    }

    @Override
    public EnumActionResult doSpecialAction(EntityPlayer player, EnumFacing facing, Vec3d hit) {
        if (this.isRendering()) {
            return EnumActionResult.PASS;
        }
        if (this.hasSide(facing.func_176745_a())) {
            this.lamps[facing.func_176745_a()] = false;
            this.colors[facing.func_176745_a()] = -1;
            if (!player.field_71075_bZ.field_75098_d) {
                StackUtil.dropAsEntity(this.func_145831_w(), this.func_174877_v(), Ic2Items.luminatorMultipart.func_77946_l());
            }
        }
        boolean found = false;
        for (int i = 0; i < 6; ++i) {
            if (!this.lamps[i]) continue;
            found = true;
            break;
        }
        if (!found) {
            TileEntity tile;
            CableContainer container = this.getData();
            Block block = Ic2States.copperCable.func_177230_c();
            if (this.field_145850_b.func_180501_a(this.field_174879_c, block.func_176203_a(container.getType()), 3) && (tile = this.field_145850_b.func_175625_s(this.field_174879_c)) instanceof TileEntityCable) {
                TileEntityCable cable = (TileEntityCable)tile;
                cable.insulation = container.getInsulation();
                cable.changeColor(this.cableColor, null);
            }
        } else {
            this.getNetwork().updateTileEntityField(this, "lamps");
            this.getNetwork().updateTileEntityField(this, "colors");
        }
        return EnumActionResult.SUCCESS;
    }

    public void setWireColor(IEnergyConductorColored.WireColor fromColor) {
        if (this.addedToEnergyNet) {
            MinecraftForge.EVENT_BUS.post((Event)new EnergyTileUnloadEvent(this));
        }
        this.addedToEnergyNet = false;
        this.cableColor = fromColor;
        MinecraftForge.EVENT_BUS.post((Event)new EnergyTileLoadEvent(this));
        this.addedToEnergyNet = true;
        this.getNetwork().updateTileEntityField(this, "cableColor");
    }

    public void setSideColor(EnumFacing side, IEnergyConductorColored.WireColor fromColor) {
        this.colors[side.func_176745_a()] = fromColor == IEnergyConductorColored.WireColor.Blank ? -1 : ItemDye.field_150922_c[fromColor.toColor().func_176767_b()];
        this.getNetwork().updateTileEntityField(this, "colors");
    }

    public void addLamp(int index) {
        if (this.addedToEnergyNet) {
            MinecraftForge.EVENT_BUS.post((Event)new EnergyTileUnloadEvent(this));
        }
        this.addedToEnergyNet = false;
        this.lamps[index] = true;
        this.iterator.add(EnumFacing.func_82600_a((int)index));
        this.getNetwork().updateTileEntityField(this, "lamps");
        MinecraftForge.EVENT_BUS.post((Event)new EnergyTileLoadEvent(this));
        this.addedToEnergyNet = true;
    }

    public void setCable(ItemStack item, IEnergyConductorColored.WireColor color, int side) {
        this.cable = item;
        this.lamps[side] = true;
        this.iterator.add(EnumFacing.func_82600_a((int)side));
        this.cableColor = color;
        this.getNetwork().updateTileEntityField(this, "lamps");
        this.getNetwork().updateTileEntityField(this, "cable");
        this.getNetwork().updateTileEntityField(this, "cableColor");
    }

    public MultiPartLuminatorModel.MultiLuminatorEntry getEntry() {
        EnumSet<EnumFacing> lamps = EnumSet.noneOf(EnumFacing.class);
        EnumSet<EnumFacing> connect = EnumSet.noneOf(EnumFacing.class);
        for (EnumFacing face : EnumFacing.field_82609_l) {
            int index = face.func_176745_a();
            if (this.hasSide(index)) {
                lamps.add(face);
                continue;
            }
            if (!this.canConnect(index)) continue;
            connect.add(face);
        }
        return new MultiPartLuminatorModel.MultiLuminatorEntry(lamps, connect, this.cable.func_190926_b() ? 0 : this.cable.func_77960_j(), this.cableColor, this.getActive());
    }

    @Override
    public void func_145839_a(NBTTagCompound nbt) {
        super.func_145839_a(nbt);
        this.iterator.clear();
        this.cable = new ItemStack(nbt.func_74775_l("Cable"));
        this.cableColor = IEnergyConductorColored.WireColor.values()[nbt.func_74762_e("CableColor")];
        this.current = nbt.func_74762_e("Current");
        this.connections = nbt.func_74770_j("Connect");
        this.energy = nbt.func_74762_e("Energy");
        NBTTagList list = nbt.func_150295_c("Data", 10);
        this.colors = new int[6];
        this.lamps = new boolean[6];
        for (int i = 0; i < list.func_74745_c(); ++i) {
            NBTTagCompound data = list.func_150305_b(i);
            byte slot = data.func_74771_c("Slot");
            this.lamps[slot] = true;
            this.iterator.add(EnumFacing.func_82600_a((int)slot));
            this.colors[slot] = data.func_74762_e("Color");
        }
    }

    @Override
    public NBTTagCompound func_189515_b(NBTTagCompound nbt) {
        super.func_189515_b(nbt);
        NBTTagCompound itemTag = new NBTTagCompound();
        this.cable.func_77955_b(itemTag);
        nbt.func_74782_a("Cable", (NBTBase)itemTag);
        nbt.func_74768_a("CableColor", this.cableColor.ordinal());
        nbt.func_74768_a("Current", this.current);
        nbt.func_74768_a("Energy", this.energy);
        nbt.func_74773_a("Connect", this.connections);
        NBTTagList list = new NBTTagList();
        for (byte i = 0; i < 6; i = (byte)((byte)(i + 1))) {
            if (!this.lamps[i]) continue;
            NBTTagCompound data = new NBTTagCompound();
            data.func_74774_a("Slot", i);
            data.func_74768_a("Color", this.colors[i]);
            list.func_74742_a((NBTBase)data);
        }
        nbt.func_74782_a("Data", (NBTBase)list);
        return nbt;
    }
}

