/*
 * Decompiled with CFR 0.152.
 */
package ic2.core.block.personal;

import ic2.core.IC2;
import ic2.core.block.base.BlockMultiID;
import ic2.core.block.base.tile.TileEntityBlock;
import ic2.core.block.personal.base.misc.IOwnerBlock;
import ic2.core.block.personal.tile.TileEntityEnergyOMat;
import ic2.core.block.personal.tile.TileEntityFluidOMat;
import ic2.core.block.personal.tile.TileEntityIridiumStone;
import ic2.core.block.personal.tile.TileEntityPersonalChest;
import ic2.core.block.personal.tile.TileEntityPersonalEnergyStorage;
import ic2.core.block.personal.tile.TileEntityPersonalTank;
import ic2.core.block.personal.tile.TileEntityTradeOMat;
import ic2.core.item.block.ItemBlockPersonal;
import ic2.core.platform.lang.storage.Ic2BlockLang;
import ic2.core.platform.registry.Ic2Items;
import ic2.core.platform.registry.Ic2People;
import ic2.core.platform.registry.Ic2States;
import ic2.core.platform.textures.Ic2Icons;
import ic2.core.platform.textures.obj.ITileEntityModeledBlock;
import ic2.core.util.helpers.BlockStateContainerIC2;
import ic2.core.util.misc.StackUtil;
import ic2.core.util.obj.IBootable;
import ic2.core.util.obj.IItemContainer;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.List;
import java.util.UUID;
import net.minecraft.block.Block;
import net.minecraft.block.SoundType;
import net.minecraft.block.material.Material;
import net.minecraft.block.properties.IProperty;
import net.minecraft.block.properties.PropertyInteger;
import net.minecraft.block.state.BlockStateContainer;
import net.minecraft.block.state.IBlockState;
import net.minecraft.client.renderer.texture.TextureAtlasSprite;
import net.minecraft.creativetab.CreativeTabs;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.EnumFacing;
import net.minecraft.util.NonNullList;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.RayTraceResult;
import net.minecraft.world.Explosion;
import net.minecraft.world.IBlockAccess;
import net.minecraft.world.World;
import net.minecraftforge.fluids.FluidStack;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;

public class BlockPersonal
extends BlockMultiID
implements ITileEntityModeledBlock,
IBootable {
    public static PropertyInteger subMeta = PropertyInteger.func_177719_a((String)"submeta", (int)0, (int)2);

    public BlockPersonal() {
        super(Material.field_151573_f);
        this.func_149722_s();
        this.func_149752_b(6000000.0f);
        this.func_149672_a(SoundType.field_185852_e);
        this.setUnlocalizedName(Ic2BlockLang.personalBlock);
        this.setHarvestLevel("pickaxe", 3, this.func_176203_a(8));
    }

    @Override
    public void onLoad() {
        Ic2States.tradeOMat = this.func_176203_a(0);
        Ic2States.fluidOMat = this.func_176203_a(1);
        Ic2States.energyOMat = this.func_176203_a(2);
        Ic2States.personalSafe = this.func_176203_a(3);
        Ic2States.personalTank = this.func_176203_a(4);
        Ic2States.personalEnergyStorage = this.func_176203_a(5);
        Ic2States.localMarket = this.func_176203_a(6);
        Ic2States.globalMarket = this.func_176203_a(7);
        Ic2States.iridiumStone = this.func_176203_a(8);
        Ic2Items.tradeOMat = new ItemStack((Block)this, 1, 0);
        Ic2Items.fluidOMat = new ItemStack((Block)this, 1, 1);
        Ic2Items.energyOMat = new ItemStack((Block)this, 1, 2);
        Ic2Items.personalSafe = new ItemStack((Block)this, 1, 3);
        Ic2Items.personalTank = new ItemStack((Block)this, 1, 4);
        Ic2Items.personalEnergyStorage = new ItemStack((Block)this, 1, 5);
        Ic2Items.personalEnergyStorageBatBox = ItemBlockPersonal.setMaxEnergy(Ic2Items.personalEnergyStorage.func_77946_l(), 30000, 1);
        Ic2Items.personalEnergyStorageMFE = ItemBlockPersonal.setMaxEnergy(Ic2Items.personalEnergyStorage.func_77946_l(), 600000, 2);
        Ic2Items.personalEnergyStorageMFSU = ItemBlockPersonal.setMaxEnergy(Ic2Items.personalEnergyStorage.func_77946_l(), 10000000, 3);
        Ic2Items.iridiumStone = new ItemStack((Block)this, 1, 8);
    }

    @Override
    protected BlockStateContainer func_180661_e() {
        return new BlockStateContainerIC2((Block)this, new IProperty[]{this.getMetadataProperty(), allFacings, active, subMeta});
    }

    @Override
    public List<IBlockState> getValidStates() {
        ArrayList<IBlockState> states = new ArrayList<IBlockState>((Collection<IBlockState>)this.func_176194_O().func_177619_a());
        for (int i = 0; i < states.size(); ++i) {
            if (this.func_176201_c((IBlockState)states.get(i)) != 3) continue;
            states.remove(i--);
        }
        return states;
    }

    @Override
    public IBlockState getDefaultBlockState() {
        return super.getDefaultBlockState().func_177226_a((IProperty)subMeta, (Comparable)Integer.valueOf(0));
    }

    @Override
    public IBlockState getStateFromStack(ItemStack stack) {
        IBlockState state = super.getStateFromStack(stack);
        if (this.func_176201_c(state) == 5) {
            return state.func_177226_a((IProperty)subMeta, (Comparable)Integer.valueOf(ItemBlockPersonal.getType(stack)));
        }
        return state;
    }

    @Override
    public List<IBlockState> getValidStateList() {
        IBlockState def = this.func_176223_P();
        ArrayList<IBlockState> states = new ArrayList<IBlockState>();
        for (int i : Arrays.asList(0, 1, 2, 3, 4, 8)) {
            EnumFacing[] enumFacingArray = EnumFacing.field_82609_l;
            int n = enumFacingArray.length;
            for (int j = 0; j < n; ++j) {
                EnumFacing side = enumFacingArray[j];
                states.add(def.func_177226_a((IProperty)this.getMetadataProperty(), (Comparable)Integer.valueOf(i)).func_177226_a((IProperty)allFacings, (Comparable)side));
            }
        }
        for (int i = 0; i < 3; ++i) {
            for (EnumFacing side : EnumFacing.field_82609_l) {
                states.add(def.func_177226_a((IProperty)this.getMetadataProperty(), (Comparable)Integer.valueOf(5)).func_177226_a((IProperty)allFacings, (Comparable)side).func_177226_a((IProperty)subMeta, (Comparable)Integer.valueOf(i)));
            }
        }
        return states;
    }

    @Override
    public TileEntityBlock createNewTileEntity(World worldIn, int meta) {
        switch (meta) {
            case 0: {
                return new TileEntityTradeOMat();
            }
            case 1: {
                return new TileEntityFluidOMat();
            }
            case 2: {
                return new TileEntityEnergyOMat();
            }
            case 3: {
                return new TileEntityPersonalChest();
            }
            case 4: {
                return new TileEntityPersonalTank();
            }
            case 5: {
                return new TileEntityPersonalEnergyStorage();
            }
            case 8: {
                return new TileEntityIridiumStone();
            }
        }
        return null;
    }

    @Deprecated
    public float func_180647_a(IBlockState state, EntityPlayer player, World worldIn, BlockPos pos) {
        TileEntity tile;
        if (this.func_176201_c(state) == 8 && (tile = worldIn.func_175625_s(pos)) instanceof IOwnerBlock && ((IOwnerBlock)tile).canAccess(player.func_110124_au())) {
            return player.getDigSpeed(state, pos) / 80.0f / 30.0f;
        }
        return super.func_180647_a(state, player, worldIn, pos);
    }

    public float getExplosionResistance(World world, BlockPos pos, Entity exploder, Explosion explosion) {
        int meta = this.func_176201_c(world.func_180495_p(pos));
        if (meta == 8) {
            return 150.0f;
        }
        return super.getExplosionResistance(world, pos, exploder, explosion);
    }

    @Override
    public List<Integer> getValidMetas() {
        return Arrays.asList(0, 1, 2, 3, 4, 5, 8);
    }

    @Deprecated
    public int func_149717_k(IBlockState state) {
        int meta = this.func_176201_c(state);
        if (meta == 3) {
            return 0;
        }
        return super.func_149717_k(state);
    }

    @Deprecated
    public boolean func_149662_c(IBlockState state) {
        int meta = this.func_176201_c(state);
        if (meta == 3) {
            return false;
        }
        return super.func_149662_c(state);
    }

    @Deprecated
    public boolean func_149730_j(IBlockState state) {
        int meta = this.func_176201_c(state);
        return super.func_149730_j(state);
    }

    @Override
    @SideOnly(value=Side.CLIENT)
    public TextureAtlasSprite[] getIconSheet(int meta) {
        if (meta == 5) {
            return Ic2Icons.getTextures("bpersonalE");
        }
        return Ic2Icons.getTextures("bpersonal");
    }

    @Override
    public int getMaxSheetSize(int meta) {
        if (meta == 5) {
            return 3;
        }
        return super.getMaxSheetSize(meta);
    }

    @Override
    public int getIconMeta(IBlockState state) {
        if (this.func_176201_c(state) == 5) {
            return (Integer)state.func_177229_b((IProperty)subMeta);
        }
        return super.getIconMeta(state);
    }

    public int func_180651_a(IBlockState state) {
        return this.func_176201_c(state);
    }

    @Override
    public void func_180633_a(World worldIn, BlockPos pos, IBlockState state, EntityLivingBase placer, ItemStack stack) {
        int value;
        NBTTagCompound nbt;
        super.func_180633_a(worldIn, pos, state, placer, stack);
        TileEntity tile = worldIn.func_175625_s(pos);
        if (tile instanceof IOwnerBlock) {
            UUID owner = Ic2People.speigerOffline;
            if (placer instanceof EntityPlayer) {
                EntityPlayer player = (EntityPlayer)placer;
                owner = player.func_110124_au();
                IC2.achievements.issueStat(player, "playersDisliked");
            }
            ((IOwnerBlock)tile).setOwner(owner);
        }
        if (tile instanceof TileEntityPersonalEnergyStorage) {
            int maxTier = ItemBlockPersonal.getTier(stack);
            int maxEnergy = ItemBlockPersonal.getMaxEnergy(stack);
            ((TileEntityPersonalEnergyStorage)tile).setType(maxTier, maxEnergy);
        }
        if (tile instanceof TileEntityPersonalTank) {
            TileEntityPersonalTank tank = (TileEntityPersonalTank)tile;
            if (stack.func_77942_o()) {
                nbt = StackUtil.getNbtData(stack);
                if (nbt.func_74764_b("Fluid")) {
                    tank.tank.setFluid(FluidStack.loadFluidStackFromNBT((NBTTagCompound)nbt.func_74775_l("Fluid")));
                }
                if (nbt.func_74764_b("Allow")) {
                    tank.allowView = true;
                }
                if (nbt.func_74764_b("Value")) {
                    value = nbt.func_74762_e("Value");
                    tank.loadFromState(value);
                }
            }
        }
        if (tile instanceof TileEntityPersonalChest) {
            TileEntityPersonalChest chest = (TileEntityPersonalChest)tile;
            if (stack.func_77942_o()) {
                nbt = StackUtil.getNbtData(stack);
                if (nbt.func_74764_b("ItemsStored")) {
                    chest.inv.readFromNBT(nbt.func_74775_l("ItemsStored"));
                }
                if (nbt.func_74764_b("Allow")) {
                    chest.allowView = true;
                }
                if (nbt.func_74764_b("Value")) {
                    value = nbt.func_74762_e("Value");
                    chest.loadFromState(value);
                }
            }
        }
    }

    @Override
    public List<IBlockState> getTileStates() {
        ArrayList<IBlockState> states = new ArrayList<IBlockState>();
        for (EnumFacing side : EnumFacing.field_82609_l) {
            states.add(this.func_176223_P().func_177226_a((IProperty)allFacings, (Comparable)side).func_177226_a((IProperty)this.getMetadataProperty(), (Comparable)Integer.valueOf(3)));
        }
        return states;
    }

    @Override
    public Class<? extends TileEntity> getClassFromState(IBlockState state) {
        int meta = this.func_176201_c(state);
        if (meta == 3) {
            return TileEntityPersonalChest.class;
        }
        return null;
    }

    @Override
    @SideOnly(value=Side.CLIENT)
    public TextureAtlasSprite getParticalTexture(IBlockState state) {
        int meta = this.func_176201_c(state);
        if (meta == 3) {
            return Ic2Icons.getTextures("bpersonal")[3];
        }
        return null;
    }

    @Override
    public IBlockState func_176221_a(IBlockState state, IBlockAccess worldIn, BlockPos pos) {
        TileEntity tile;
        if (this.func_176201_c(state = super.func_176221_a(state, worldIn, pos)) == 5 && (tile = worldIn.func_175625_s(pos)) instanceof TileEntityPersonalEnergyStorage) {
            state = state.func_177226_a((IProperty)subMeta, (Comparable)Integer.valueOf(((TileEntityPersonalEnergyStorage)tile).storage.getType()));
        }
        return state;
    }

    @Override
    public List<ItemStack> getWrenchDrops(World world, BlockPos pos, IBlockState state, TileEntity te, EntityPlayer player, int fortune) {
        ArrayList<ItemStack> items = new ArrayList<ItemStack>();
        int meta = this.func_176201_c(state);
        if (meta < 3 || meta > 5) {
            items.add(new ItemStack((Block)this, 1, meta));
        }
        if (te instanceof IItemContainer) {
            items.addAll(((IItemContainer)te).getDrops());
        }
        return items;
    }

    @Override
    public void func_149666_a(CreativeTabs itemIn, NonNullList<ItemStack> items) {
        for (Integer meta : this.getValidMetas()) {
            if (meta == 5) {
                items.add((Object)Ic2Items.personalEnergyStorageBatBox.func_77946_l());
                items.add((Object)Ic2Items.personalEnergyStorageMFE.func_77946_l());
                items.add((Object)Ic2Items.personalEnergyStorageMFSU.func_77946_l());
                continue;
            }
            items.add((Object)new ItemStack((Block)this, 1, meta.intValue()));
        }
    }

    @Override
    public ItemStack getPickBlock(IBlockState state, RayTraceResult target, World world, BlockPos pos, EntityPlayer player) {
        ItemStack result = super.getPickBlock(state, target, world, pos, player);
        TileEntity tile = world.func_175625_s(pos);
        if (tile instanceof TileEntityPersonalEnergyStorage) {
            return ((TileEntityPersonalEnergyStorage)tile).storage.getDrop();
        }
        return result;
    }

    @Override
    public boolean needsRedstoneUpdates(int meta) {
        return false;
    }

    public boolean canEntityDestroy(IBlockState state, IBlockAccess world, BlockPos pos, Entity entity) {
        return false;
    }
}

