/*
 * Decompiled with CFR 0.152.
 */
package mcjty.lib.network;

import io.netty.buffer.ByteBuf;
import java.util.function.Supplier;
import mcjty.lib.debugtools.DumpBlockNBT;
import mcjty.lib.network.NetworkTools;
import mcjty.lib.thirteen.Context;
import mcjty.lib.varia.Logging;
import net.minecraft.entity.player.EntityPlayerMP;
import net.minecraft.server.MinecraftServer;
import net.minecraft.server.management.UserListOps;
import net.minecraft.server.management.UserListOpsEntry;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.World;
import net.minecraft.world.WorldServer;
import net.minecraftforge.common.DimensionManager;
import net.minecraftforge.fml.common.network.simpleimpl.IMessage;
import org.apache.logging.log4j.Level;

public class PacketDumpBlockInfo
implements IMessage {
    private int dimid;
    private BlockPos pos;
    private boolean verbose;

    public void fromBytes(ByteBuf buf) {
        this.dimid = buf.readInt();
        this.pos = NetworkTools.readPos(buf);
        this.verbose = buf.readBoolean();
    }

    public void toBytes(ByteBuf buf) {
        buf.writeInt(this.dimid);
        NetworkTools.writePos(buf, this.pos);
        buf.writeBoolean(this.verbose);
    }

    public PacketDumpBlockInfo() {
    }

    public PacketDumpBlockInfo(ByteBuf buf) {
        this.fromBytes(buf);
    }

    public PacketDumpBlockInfo(World world, BlockPos pos, boolean verbose) {
        this.dimid = world.field_73011_w.getDimension();
        this.pos = pos;
        this.verbose = verbose;
    }

    public void handle(Supplier<Context> supplier) {
        Context ctx = supplier.get();
        ctx.enqueueWork(() -> {
            int perm;
            EntityPlayerMP player = ctx.getSender();
            MinecraftServer server = player.func_130014_f_().func_73046_m();
            UserListOps oppedPlayers = server.func_184103_al().func_152603_m();
            UserListOpsEntry entry = (UserListOpsEntry)oppedPlayers.func_152683_b((Object)player.func_146103_bH());
            int n = perm = entry == null ? server.func_110455_j() : entry.func_152644_a();
            if (perm >= 1) {
                WorldServer world = DimensionManager.getWorld((int)this.dimid);
                String output = DumpBlockNBT.dumpBlockNBT((World)world, this.pos, this.verbose);
                Logging.getLogger().log(Level.INFO, "### Server side ###");
                Logging.getLogger().log(Level.INFO, output);
            }
        });
        ctx.setPacketHandled(true);
    }
}

