/*
 * Decompiled with CFR 0.152.
 */
package nihiltres.engineersdoors.common.block.properties;

import net.minecraft.block.Block;
import net.minecraft.block.SoundType;
import net.minecraft.block.material.Material;
import net.minecraft.init.Items;
import net.minecraft.item.Item;
import net.minecraft.item.ItemBlock;
import nihiltres.engineersdoors.common.Properties;

public interface IBlockSetup {
    public static boolean hasDefaultSupport(Object obj, boolean throwException) {
        if (!(obj instanceof Block)) {
            if (throwException) {
                throw new UnsupportedOperationException("IBlockSetup methods do not support non-Block objects by default.");
            }
            return false;
        }
        return true;
    }

    public static boolean hasDefaultSupport(Object obj) {
        return IBlockSetup.hasDefaultSupport(obj, false);
    }

    default public Block setBlockProperties(float hardness, float resistance, String harvestTool, int harvestLevel) {
        IBlockSetup.hasDefaultSupport(this, true);
        ((Block)this).func_149711_c(hardness).func_149752_b(resistance).setHarvestLevel(harvestTool, harvestLevel);
        return (Block)this;
    }

    default public Block setDefaultBlockProperties(Material mat) {
        EnumMaterialDefaults d = EnumMaterialDefaults.fromMaterial(mat);
        return this.setBlockProperties(d.hardness, d.resistance, d.tool, d.level).func_149647_a(Properties.DEFAULT_CREATIVE_TAB);
    }

    default public Block setName(String nameIn) {
        IBlockSetup.hasDefaultSupport(this, true);
        ((Block)((Block)this).setRegistryName(nameIn)).func_149663_c(nameIn);
        return (Block)this;
    }

    default public Block setDefaultBlockProperties(Material mat, String nameIn) {
        this.setDefaultBlockProperties(mat);
        return this.setName(nameIn);
    }

    default public Block setDefaultCreativeTab() {
        IBlockSetup.hasDefaultSupport(this, true);
        ((Block)this).func_149647_a(Properties.DEFAULT_CREATIVE_TAB);
        return (Block)this;
    }

    default public Item getItemBlock() {
        IBlockSetup.hasDefaultSupport(this, true);
        return IBlockSetup.createItemBlock((Block)this);
    }

    public static Item createItemBlock(Block b) {
        String name = b.getRegistryName().func_110623_a();
        return ((Item)new ItemBlock(b).setRegistryName(name)).func_77655_b(name);
    }

    public static Item getItemBlock(Block b) {
        Item item;
        if (b instanceof IBlockSetup) {
            try {
                return ((IBlockSetup)b).getItemBlock();
            }
            catch (UnsupportedOperationException unsupportedOperationException) {
                // empty catch block
            }
        }
        return (item = Item.func_150898_a((Block)b)) != Items.field_190931_a ? item : IBlockSetup.createItemBlock(b);
    }

    public static enum EnumMaterialDefaults {
        GROUND(Material.field_151578_c, SoundType.field_185849_b, 0.6f, 0.1f, "shovel", 0),
        WOOD(Material.field_151575_d, SoundType.field_185848_a, 2.0f, 5.0f, "axe", 0),
        ROCK(Material.field_151576_e, SoundType.field_185851_d, 2.5f, 10.0f, "pickaxe", 1),
        IRON(Material.field_151573_f, SoundType.field_185852_e, 3.0f, 15.0f, "pickaxe", 2),
        UNDEFINED(null, SoundType.field_185851_d, 2.0f, 5.0f, "", 0);

        public final float hardness;
        public final float resistance;
        public final String tool;
        public final int level;
        public final Material material;
        public SoundType soundType;

        private EnumMaterialDefaults(Material materialIn, SoundType soundTypeIn, float hardnessIn, float resistanceIn, String toolIn, int levelIn) {
            this.material = materialIn;
            this.soundType = soundTypeIn;
            this.hardness = hardnessIn;
            this.resistance = resistanceIn;
            this.tool = toolIn;
            this.level = levelIn;
        }

        public static EnumMaterialDefaults fromMaterial(Material mat) {
            for (EnumMaterialDefaults emd : EnumMaterialDefaults.values()) {
                if (mat != emd.material) continue;
                return emd;
            }
            return UNDEFINED;
        }

        public static SoundType getSoundType(Material mat) {
            return EnumMaterialDefaults.fromMaterial((Material)mat).soundType;
        }
    }
}

