/*
 * Decompiled with CFR 0.152.
 */
package pregenerator.impl.processor.generator;

import com.google.gson.JsonArray;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import com.google.gson.JsonParser;
import com.google.gson.internal.Streams;
import com.google.gson.stream.JsonWriter;
import it.unimi.dsi.fastutil.objects.ObjectArrayList;
import java.io.BufferedInputStream;
import java.io.BufferedReader;
import java.io.BufferedWriter;
import java.io.ByteArrayOutputStream;
import java.io.DataOutputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileReader;
import java.io.FileWriter;
import java.io.IOException;
import java.io.OutputStream;
import java.io.RandomAccessFile;
import java.io.Reader;
import java.io.Writer;
import java.net.HttpURLConnection;
import java.net.URL;
import java.nio.file.Files;
import java.util.List;
import java.util.UUID;
import java.util.zip.GZIPOutputStream;
import net.minecraft.command.ICommandSender;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.entity.player.EntityPlayerMP;
import net.minecraft.util.ResourceLocation;
import net.minecraft.world.DimensionType;
import net.minecraft.world.World;
import net.minecraft.world.WorldProvider;
import net.minecraftforge.common.DimensionManager;
import net.minecraftforge.fml.common.FMLCommonHandler;
import net.minecraftforge.fml.common.FMLLog;
import net.minecraftforge.fml.common.Loader;
import net.minecraftforge.fml.common.ModContainer;
import org.apache.commons.lang3.time.DurationFormatUtils;
import oshi.SystemInfo;
import oshi.hardware.Processor;
import pregenerator.ChunkPregenerator;
import pregenerator.ConfigManager;
import pregenerator.impl.storage.GlobalListeners;

public class BenchmarkManager {
    public static final BenchmarkManager INSTANCE = new BenchmarkManager();
    List<BenchmarkResult> results = new ObjectArrayList();
    UUID sessionInstance = UUID.randomUUID();
    UUID starter = null;
    boolean sendNextBenchmark = false;

    public boolean isBenchmarkRunning() {
        return this.starter != null;
    }

    public void interruptBenchmark() {
        this.starter = null;
        this.results.clear();
    }

    public void startBenchmark(UUID starter, boolean sendAnalytics) {
        this.starter = starter;
        this.sendNextBenchmark = sendAnalytics;
    }

    public void addBenchmarkResult(long original, long chunks, long time, boolean small, World type) {
        if (this.starter == null || (double)chunks / (double)original < 0.75) {
            return;
        }
        ResourceLocation location = this.createDimension(type);
        if (location != null) {
            this.results.add(new BenchmarkResult(original, chunks, time, time, small, location));
        }
    }

    public void onBenchmarkFinished() {
        if (this.results.isEmpty() || this.starter == null) {
            this.results.clear();
            this.starter = null;
            return;
        }
        EntityPlayerMP player = FMLCommonHandler.instance().getMinecraftServerInstance().func_184103_al().func_177451_a(this.starter);
        if (player != null && GlobalListeners.INSTANCE.containsListener((ICommandSender)player)) {
            player = null;
        }
        int score = 0;
        long time = 0L;
        long chunks = 0L;
        for (BenchmarkResult result : this.results) {
            score += result.terrainScore();
            time += result.terrainTime;
            chunks += result.chunks;
        }
        this.sendMessage((EntityPlayer)player, "Benchmark Scores");
        this.sendMessage((EntityPlayer)player, "Total Score [Chunks=" + chunks + this.time(", Time=", time) + ", Score=" + score + "]");
        for (BenchmarkResult result : this.results) {
            this.sendMessage((EntityPlayer)player, this.toPascalCase(result.dim.func_110623_a()) + " Score [Chunks=" + result.chunks + this.time(", Time=", result.terrainTime) + ", Score=" + result.terrainScore() + "]");
        }
        this.sendMessage((EntityPlayer)player, "Score Rating: Milliseconds per Chunk. Lower => Better");
        this.saveResults((EntityPlayer)player);
        if (!this.sendNextBenchmark) {
            this.starter = null;
            this.results.clear();
            return;
        }
        try {
            new Thread((Runnable)new AnalyticsTask(this.createData(), false), "Pregen Analytics").start();
        }
        catch (IOException iOException) {
            // empty catch block
        }
        this.starter = null;
        this.results.clear();
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public boolean reportMass() {
        try (BufferedInputStream stream = new BufferedInputStream(new FileInputStream(new File(FMLCommonHandler.instance().getMinecraftServerInstance().func_71238_n(), "config/pregenCache.dat")));){
            int a = stream.available();
            if (a < 100) {
                boolean bl2 = false;
                return bl2;
            }
            byte[] read = new byte[a];
            stream.read(read);
            new Thread((Runnable)new AnalyticsTask(read, true), "Pregen Analytics").start();
            boolean bl = true;
            return bl;
        }
        catch (Exception exception) {
            return false;
        }
    }

    private void saveResults(EntityPlayer player) {
        block48: {
            this.sendMessage(player, "Saving Results for personal Use. Pregen_Benchmarks.json can be found in the ServerFolder");
            File base = FMLCommonHandler.instance().getMinecraftServerInstance().func_71238_n();
            File userBenchmarks = new File(base, "Pregen_Benchmarks.json");
            JsonObject obj = new JsonObject();
            if (userBenchmarks.exists()) {
                try (BufferedReader reader2 = new BufferedReader(new FileReader(userBenchmarks));){
                    obj = new JsonParser().parse((Reader)reader2).getAsJsonObject();
                }
                catch (Exception reader2) {
                    // empty catch block
                }
            }
            JsonArray array = obj.has("results") ? obj.getAsJsonArray("results") : new JsonArray();
            obj.add("results", (JsonElement)array);
            array.add((JsonElement)this.createUserData());
            try (JsonWriter writer2 = new JsonWriter((Writer)new BufferedWriter(new FileWriter(userBenchmarks)));){
                writer2.setIndent(" ");
                Streams.write((JsonElement)obj, (JsonWriter)writer2);
                writer2.flush();
            }
            catch (Exception writer2) {
                // empty catch block
            }
            File cache = new File(base, "config/pregenCache.dat");
            boolean deleteOnCrash = false;
            try (RandomAccessFile file = new RandomAccessFile(cache, "rw");){
                byte[] toAdd = this.createData();
                if (file.length() <= 0L) {
                    file.writeInt(0);
                    file.writeLong(12L);
                    file.seek(0L);
                    deleteOnCrash = true;
                }
                int benchmarks = file.readInt();
                long endBytes = file.readLong();
                file.seek(endBytes);
                file.writeInt(toAdd.length);
                deleteOnCrash = true;
                file.write(toAdd);
                file.seek(0L);
                file.writeInt(benchmarks + 1);
                file.writeLong(endBytes + (long)toAdd.length + 4L);
            }
            catch (Exception e) {
                e.printStackTrace();
                if (!deleteOnCrash) break block48;
                FMLLog.log.warn("Writing to Cache has crashed.");
                try {
                    Files.deleteIfExists(cache.toPath());
                }
                catch (Exception exception) {
                    // empty catch block
                }
            }
        }
    }

    private byte[] createData() throws IOException {
        ByteArrayOutputStream out = new ByteArrayOutputStream();
        DataOutputStream stream = new DataOutputStream(new GZIPOutputStream(out));
        stream.writeInt(0);
        stream.writeInt(1);
        stream.writeInt(31502312);
        stream.writeLong(this.starter.getMostSignificantBits());
        stream.writeLong(this.starter.getLeastSignificantBits());
        stream.writeLong(this.sessionInstance.getMostSignificantBits());
        stream.writeLong(this.sessionInstance.getLeastSignificantBits());
        stream.writeInt(1);
        stream.writeBoolean(false);
        stream.writeInt(ConfigManager.msPerTick);
        stream.writeLong(DimensionManager.getWorld((int)0).func_72905_C());
        stream.writeUTF(System.getProperty("java.version"));
        stream.writeLong(Runtime.getRuntime().maxMemory());
        stream.writeUTF(this.getCPUName());
        stream.writeInt(Runtime.getRuntime().availableProcessors());
        stream.writeUTF("1.12.2");
        int amount = Math.min(this.results.size(), 1024);
        stream.writeShort(amount);
        for (int i = 0; i < amount; ++i) {
            this.results.get(i).write(stream);
        }
        List mods = Loader.instance().getActiveModList();
        amount = Math.min(mods.size(), 2048);
        stream.writeShort(amount);
        for (ModContainer mod : mods) {
            stream.writeUTF((mod.getModId() + ";" + mod.getVersion()).toLowerCase());
        }
        stream.close();
        return out.toByteArray();
    }

    private JsonObject createUserData() {
        JsonObject obj = new JsonObject();
        obj.addProperty("seed", (Number)DimensionManager.getWorld((int)0).func_72905_C());
        obj.addProperty("game_version", "1.12.2");
        obj.addProperty("starter", this.starter.toString());
        obj.addProperty("ms_per_tick", (Number)ConfigManager.msPerTick);
        obj.addProperty("allocated_ram", (Number)Runtime.getRuntime().maxMemory());
        JsonArray data = new JsonArray();
        for (BenchmarkResult result : this.results) {
            data.add((JsonElement)result.save());
        }
        obj.add("results", (JsonElement)data);
        data = new JsonArray();
        for (ModContainer mod : Loader.instance().getActiveModList()) {
            data.add((mod.getModId() + ";" + mod.getVersion()).toLowerCase());
        }
        obj.add("mods", (JsonElement)data);
        return obj;
    }

    private void sendMessage(EntityPlayer player, String message) {
        if (player != null) {
            ChunkPregenerator.pregenBase.sendChatMessage((ICommandSender)player, message);
        }
        GlobalListeners.INSTANCE.sendChatMessage(message);
    }

    private String time(String prefix, long value) {
        return prefix + DurationFormatUtils.formatDuration((long)value, (String)"HH:mm:ss");
    }

    private String toPascalCase(String input) {
        StringBuilder builder = new StringBuilder();
        for (String s : input.replaceAll("_", " ").replaceAll("-", " ").split(" ")) {
            builder.append(this.firstLetterUppercase(s)).append(" ");
        }
        return builder.substring(0, builder.length() - 1);
    }

    private String firstLetterUppercase(String string) {
        if (string == null || string.isEmpty()) {
            return string;
        }
        String first = Character.toString(string.charAt(0));
        return string.replaceFirst(first, first.toUpperCase());
    }

    private String getCPUName() {
        try {
            Processor[] aprocessor = new SystemInfo().getHardware().getProcessors();
            return String.format("%dx %s", aprocessor.length, aprocessor[0]).replaceAll("\\s+", " ").toLowerCase();
        }
        catch (Throwable var3) {
            return "<unknown>";
        }
    }

    private ResourceLocation createDimension(World world) {
        WorldProvider provider = world.field_73011_w;
        DimensionType type = provider.func_186058_p();
        return type.func_186068_a() != provider.getDimension() ? null : new ResourceLocation(type.func_186065_b().toLowerCase());
    }

    public static class BenchmarkResult {
        long originalChunks;
        long chunks;
        long lightTime;
        long terrainTime;
        boolean small;
        ResourceLocation dim;

        public BenchmarkResult(long originalChunks, long chunks, long lightTime, long terrainTime, boolean small, ResourceLocation dim) {
            this.originalChunks = originalChunks;
            this.chunks = chunks;
            this.lightTime = lightTime;
            this.terrainTime = terrainTime;
            this.small = small;
            this.dim = dim;
        }

        public int terrainScore() {
            return (int)(this.terrainTime / this.chunks);
        }

        public void write(DataOutputStream stream) throws IOException {
            stream.writeLong(this.originalChunks);
            stream.writeLong(this.chunks);
            stream.writeLong(this.terrainTime);
            stream.writeLong(this.lightTime);
            stream.writeBoolean(this.small);
            stream.writeUTF(this.dim.toString());
        }

        public JsonObject save() {
            JsonObject obj = new JsonObject();
            obj.addProperty("original_size", (Number)this.originalChunks);
            obj.addProperty("chunks", (Number)this.chunks);
            obj.addProperty("score", (Number)this.terrainScore());
            obj.addProperty("time", (Number)this.terrainTime);
            obj.addProperty("dim", this.dim.toString());
            obj.addProperty("size", (Number)(this.small ? 40000 : 250000));
            return obj;
        }
    }

    private class AnalyticsTask
    implements Runnable {
        byte[] data;
        boolean massReport;

        public AnalyticsTask(byte[] data, boolean massReport) {
            this.data = data;
            this.massReport = massReport;
        }

        @Override
        public void run() {
            try {
                HttpURLConnection connection = (HttpURLConnection)new URL(this.massReport ? "https://pregen.speiger.com/mass" : "https://pregen.speiger.com").openConnection();
                connection.setDoOutput(true);
                connection.setUseCaches(false);
                connection.setRequestMethod("POST");
                connection.addRequestProperty("Content-Type", "binary");
                connection.addRequestProperty("Connection", "close");
                OutputStream out = connection.getOutputStream();
                out.write(this.data);
                out.flush();
                out.close();
                connection.getResponseCode();
                connection.disconnect();
            }
            catch (Exception e) {
                e.printStackTrace();
            }
        }
    }
}

