/*
 * Decompiled with CFR 0.152.
 */
package pregenerator.impl.command.gen;

import java.util.ArrayList;
import java.util.List;
import pregenerator.impl.command.CompleterHelper;
import pregenerator.impl.command.base.BasePregenCommand;
import pregenerator.impl.command.base.CommandContainer;
import pregenerator.impl.retrogen.RetrogenHandler;

public class SelectRetrogenSubCommand
extends BasePregenCommand {
    public SelectRetrogenSubCommand() {
        super(2);
    }

    @Override
    public String getName() {
        return "selectRetrogenerator";
    }

    @Override
    public String getDescription() {
        return "Adds/Removes the Retrogenerators for the RetroPregenerator";
    }

    @Override
    public int getRequiredParameterCount() {
        return 2;
    }

    @Override
    public void execute(CommandContainer container, String[] args) {
        if (container.processorRunning()) {
            container.sendChatMessage("You can not change the Retrogenerator while the Pregenerator is running!");
        } else if (args.length >= 2) {
            boolean add = args[0].equalsIgnoreCase("add");
            boolean remove = args[0].equalsIgnoreCase("remove");
            if (!add && !remove) {
                container.sendChatMessage("Invalid Action. It has to be either Add or remove");
                return;
            }
            RetrogenHandler handler = RetrogenHandler.INSTANCE;
            String generator = args[1];
            if (!handler.isValidGenerator(generator)) {
                container.sendChatMessage("Generator is not Valid!");
                return;
            }
            if (add) {
                if (handler.isGeneratorActive(generator)) {
                    container.sendChatMessage("Generator is already in the Retrogen Handler");
                    return;
                }
                handler.enableGenerator(generator);
                container.sendChatMessage("Added Retrogen Generator [" + generator + "] to the Retrogen Handler");
            } else if (remove) {
                if (!handler.isGeneratorActive(generator)) {
                    container.sendChatMessage("Generator is already not in the Retrogen Handler");
                    return;
                }
                handler.disableGenerator(generator);
                container.sendChatMessage("Removed Retrogen Generator [" + generator + "] from the Retrogen Handler");
            }
        } else {
            this.throwErrors(container, args.length);
        }
    }

    @Override
    public List<String> getAutoCompleteOption(String[] args, int argLayer, int commandIndex) {
        if (commandIndex == 0) {
            return SelectRetrogenSubCommand.getBestMatch(args, "Add", "Remove");
        }
        if (commandIndex == 1) {
            if (args[0].equalsIgnoreCase("Add")) {
                return SelectRetrogenSubCommand.getBestMatch(args, CompleterHelper.RETROGEN_ADD);
            }
            return SelectRetrogenSubCommand.getBestMatch(args, CompleterHelper.RETROGEN_REMOVE);
        }
        return new ArrayList<String>();
    }
}

