/*
 * Decompiled with CFR 0.152.
 */
package icbm.classic.content.explosive.blast;

import icbm.classic.ICBMClassic;
import icbm.classic.api.explosion.IBlast;
import icbm.classic.api.explosion.IMissile;
import icbm.classic.client.models.ModelICBM;
import icbm.classic.config.ConfigDebug;
import icbm.classic.content.entity.EntityExplosion;
import icbm.classic.content.explosive.ExplosiveHandler;
import icbm.classic.content.explosive.thread.ThreadExplosion;
import icbm.classic.lib.transform.vector.Location;
import java.util.List;
import java.util.concurrent.ConcurrentLinkedQueue;
import net.minecraft.entity.Entity;
import net.minecraft.entity.item.EntityItem;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.init.SoundEvents;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.util.DamageSource;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.SoundCategory;
import net.minecraft.util.math.AxisAlignedBB;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.MathHelper;
import net.minecraft.util.math.Vec3d;
import net.minecraft.world.Explosion;
import net.minecraft.world.World;
import net.minecraftforge.event.ForgeEventFactory;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;

public abstract class Blast
extends Explosion
implements IBlast {
    private ThreadExplosion thread;
    private ConcurrentLinkedQueue<BlockPos> threadResults;
    private boolean threadComplete = false;
    public Location location;
    public EntityExplosion controller = null;
    public boolean isAlive = true;
    protected int callCount = 0;
    private boolean preExplode = false;

    public Blast() {
        super(null, null, 0.0, 0.0, 0.0, 0.0f, false, false);
    }

    public Blast(World world, Entity entity, double x, double y, double z, float size) {
        super(world, entity, x, y, z, size, false, true);
        this.location = new Location(world, x, y, z);
    }

    public Blast(Location pos, Entity entity, float size) {
        super(pos.world(), entity, pos.x(), pos.y(), pos.z(), size, false, true);
        this.location = pos;
    }

    public Blast(Entity entity, float size) {
        super(entity.field_70170_p, entity, entity.field_70165_t, entity.field_70163_u, entity.field_70161_v, size, false, true);
        this.location = new Location(entity);
    }

    protected void doPreExplode() {
    }

    public final void preExplode() {
        this.debugEx(String.format("Blast#preExplode() -> Blast: %s, IsAlive: %s, HasBeenCalledBefore: %s", this, this.isAlive, this.preExplode));
        if (this.isAlive && !this.preExplode) {
            this.preExplode = true;
            ExplosiveHandler.add(this);
            this.doPreExplode();
        }
    }

    @Deprecated
    protected void doExplode() {
    }

    protected void doExplode(int callCount) {
        this.doExplode();
    }

    public final void onExplode() {
        if (!this.preExplode) {
            this.debugEx(String.format("Blast#onExplode() -> preExplode() was never called, Blast: %s, IsAlive: %s, CallCount: %s", this, this.isAlive, this.callCount));
            this.preExplode();
        }
        this.debugEx(String.format("Blast#onExplode() -> Blast: %s, IsAlive: %s, CallCount: %s", this, this.isAlive, this.callCount));
        if (this.isAlive) {
            this.doExplode(this.callCount++);
        }
    }

    protected void doPostExplode() {
    }

    public final void postExplode() {
        this.debugEx(String.format("Blast#postExplode() -> Blast: %s, IsAlive: %s", this, this.isAlive));
        if (this.isAlive) {
            this.isAlive = false;
            ExplosiveHandler.remove(this);
            this.doPostExplode();
        }
    }

    public void onPositionUpdate(double posX, double posY, double posZ) {
        this.setPosition(posX, posY, posZ);
        this.debugEx(String.format("Blast#onPositionUpdate(%s, %s, %s) -> position has been updated, Blast: %s", this, posX, posY, posZ));
    }

    public Blast setPosition(double posX, double posY, double posZ) {
        this.field_77284_b = posX;
        this.field_77285_c = posY;
        this.field_77282_d = posZ;
        this.location = new Location(this.field_77287_j, posX, posY, posZ);
        return this;
    }

    public Vec3d getPosition() {
        return this.location.toVec3d();
    }

    public void func_77278_a() {
        ICBMClassic.logger().error("Blast#doExplosionA() -> Something called the vanilla explosion method. This is not a supported behavior for ICBM explosions. Blast: " + this, (Throwable)new RuntimeException());
    }

    public void func_77279_a(boolean par1) {
        ICBMClassic.logger().error("Blast#doExplosionB(" + par1 + ") -> Something called the vanilla explosion method. This is not a supported behavior for ICBM explosions. Blast: " + this, (Throwable)new RuntimeException());
    }

    public void runBlast() {
        if (ForgeEventFactory.onExplosionStart((World)this.field_77287_j, (Explosion)this)) {
            return;
        }
        this.playExplodeSound();
        if (this.proceduralInterval() > 0) {
            this.debugEx("Blast#explode() -> Triggering interval based explosion, Blast: " + this);
            if (!this.world().field_72995_K && !this.world().func_72838_d((Entity)new EntityExplosion(this))) {
                ICBMClassic.logger().error("Blast#explode() -> Failed to spawn explosion entity to control blast, Blast: " + this);
                this.isAlive = false;
            }
        } else {
            this.debugEx("Blast#explode() -> Triggering full explosion, Blast: " + this);
            this.doRunBlast();
        }
    }

    protected void doRunBlast() {
        this.preExplode();
        this.doExplode();
        this.postExplode();
    }

    protected void playExplodeSound() {
        this.field_77287_j.func_184148_a((EntityPlayer)null, this.field_77284_b, this.field_77285_c, this.field_77282_d, SoundEvents.field_187539_bB, SoundCategory.BLOCKS, 4.0f, (1.0f + (this.field_77287_j.field_73012_v.nextFloat() - this.field_77287_j.field_73012_v.nextFloat()) * 0.2f) * 0.7f);
    }

    @Override
    public float getBlastRadius() {
        return Math.max(3.0f, this.field_77280_f);
    }

    public int proceduralInterval() {
        return -1;
    }

    protected void doDamageEntities(float radius, float power) {
        this.doDamageEntities(radius, power, true);
    }

    protected void doDamageEntities(float radius, float power, boolean destroyItem) {
        Location minCoord = (Location)this.location.add(-(radius *= 2.0f) - 1.0f);
        Location maxCoord = (Location)this.location.add(radius + 1.0f);
        List allEntities = this.world().func_72872_a(Entity.class, new AxisAlignedBB((double)minCoord.xi(), (double)minCoord.yi(), (double)minCoord.zi(), (double)maxCoord.xi(), (double)maxCoord.yi(), (double)maxCoord.zi()));
        Vec3d var31 = new Vec3d(this.location.x(), this.location.y(), this.location.z());
        for (int i = 0; i < allEntities.size(); ++i) {
            double distance;
            Entity entity = (Entity)allEntities.get(i);
            if (this.onDamageEntity(entity)) continue;
            if (entity instanceof IMissile) {
                ((IMissile)entity).destroyMissile(true);
                continue;
            }
            if (entity instanceof EntityItem && !destroyItem || !((distance = entity.func_70011_f(this.location.x(), this.location.y(), this.location.z()) / (double)radius) <= 1.0)) continue;
            double xDifference = entity.field_70165_t - this.location.x();
            double yDifference = entity.field_70163_u - this.location.y();
            double zDifference = entity.field_70161_v - this.location.z();
            double var35 = MathHelper.func_76133_a((double)(xDifference * xDifference + yDifference * yDifference + zDifference * zDifference));
            xDifference /= var35;
            yDifference /= var35;
            zDifference /= var35;
            double var34 = this.world().func_72842_a(var31, entity.func_174813_aQ());
            double var36 = (1.0 - distance) * var34;
            int damage = 0;
            damage = (int)((var36 * var36 + var36) / 2.0 * 8.0 * (double)power + 1.0);
            entity.func_70097_a(DamageSource.func_94539_a((Explosion)this), (float)damage);
            entity.field_70159_w += xDifference * var36;
            entity.field_70181_x += yDifference * var36;
            entity.field_70179_y += zDifference * var36;
        }
    }

    protected boolean onDamageEntity(Entity entity) {
        return false;
    }

    public void readFromNBT(NBTTagCompound nbt) {
        this.callCount = nbt.func_74762_e("callCount");
        this.field_77280_f = nbt.func_74760_g("explosionSize");
    }

    public void writeToNBT(NBTTagCompound nbt) {
        nbt.func_74768_a("callCount", this.callCount);
        nbt.func_74776_a("explosionSize", this.field_77280_f);
    }

    public boolean isMovable() {
        return false;
    }

    @SideOnly(value=Side.CLIENT)
    public ModelICBM getRenderModel() {
        return null;
    }

    @SideOnly(value=Side.CLIENT)
    public ResourceLocation getRenderResource() {
        return null;
    }

    @Override
    public World world() {
        return this.location.world();
    }

    @Override
    public double x() {
        return this.location.x();
    }

    @Override
    public double y() {
        return this.location.y();
    }

    @Override
    public double z() {
        return this.location.z();
    }

    @Override
    public Entity getBlastSource() {
        return this.getBlastSource();
    }

    protected void createAndStartThread(ThreadExplosion thread) {
        if (ConfigDebug.DEBUG_THREADS) {
            ICBMClassic.logger().info("Blast#createAndStartThread(" + thread + ") -> Thread set");
        }
        if (this.thread != null && !this.thread.isComplete) {
            ICBMClassic.logger().info("Blast#createAndStartThread(" + thread + ") -> Error new thread was set before last finished\nLast: " + thread);
        }
        this.thread = thread;
        this.threadComplete = false;
        this.thread.start();
        if (ConfigDebug.DEBUG_THREADS) {
            ICBMClassic.logger().info("Blast#createAndStartThread(" + thread + ") -> Thread started: " + thread.isAlive());
        }
    }

    protected boolean isThreadCompleted() {
        return this.threadComplete || this.thread != null && this.thread.isComplete;
    }

    public synchronized void markThreadCompleted(ThreadExplosion exThread) {
        if (ConfigDebug.DEBUG_THREADS) {
            ICBMClassic.logger().info("Blast#markThreadCompleted(" + exThread + ") -> Thread responded that is has completed, Blast: " + this);
        }
        if (this.thread == null || this.thread == exThread) {
            this.threadComplete = true;
        } else {
            ICBMClassic.logger().info("Blast#markThreadCompleted(" + exThread + ") -> Error thread attempted to mark for complete but did not match current thread \nCurrent: " + this.thread + "\nBlast: " + this);
        }
    }

    public void addThreadResult(BlockPos pos) {
        this.getThreadResults().add(pos);
    }

    protected ConcurrentLinkedQueue getThreadResults() {
        if (this.threadResults == null) {
            this.threadResults = new ConcurrentLinkedQueue();
        }
        return this.threadResults;
    }

    public ThreadExplosion getThread() {
        return this.thread;
    }

    protected final void debugEx(String msg) {
        if (ConfigDebug.DEBUG_EXPLOSIVES) {
            ICBMClassic.logger().info(msg);
        }
    }

    public Blast setPower(float power) {
        this.field_77280_f = power;
        return this;
    }

    public Blast scale(float scale) {
        this.field_77280_f *= scale;
        return this;
    }

    protected Blast setWorld(World world) {
        this.field_77287_j = world;
        return this;
    }
}

