/*
 * Decompiled with CFR 0.152.
 */
package trinsdar.advancedsolars.items;

import ic2.api.item.ElectricItem;
import ic2.core.IC2;
import ic2.core.block.generator.tile.TileEntitySolarPanel;
import ic2.core.inventory.base.IHasInventory;
import ic2.core.item.armor.base.ItemElectricArmorBase;
import ic2.core.platform.textures.Ic2Icons;
import ic2.core.util.obj.IBootable;
import ic2.core.util.obj.ToolTipType;
import ic2.core.util.obj.plugins.IBaublesPlugin;
import java.util.Arrays;
import java.util.List;
import java.util.Map;
import net.minecraft.client.renderer.texture.TextureAtlasSprite;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.inventory.EntityEquipmentSlot;
import net.minecraft.item.ItemStack;
import net.minecraft.util.NonNullList;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.World;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;
import trinsdar.advancedsolars.util.AdvancedSolarLang;

public class ItemArmorAdvancedSolarHelmet
extends ItemElectricArmorBase
implements IBootable {
    private int id;
    private int production;
    private int lowerProduction;
    private int energyPerDamage;
    double damageAbsorpationRatio;
    String texture;

    public void onLoad() {
    }

    public ItemArmorAdvancedSolarHelmet(String name, int id, int pro, int lowPro, int maxCharge, int maxTransfer, int tier, int energyPerDamage, double damageAbsorpationRatio, String texture) {
        super(-1, EntityEquipmentSlot.HEAD, maxCharge, maxTransfer, tier);
        this.id = id;
        this.production = pro;
        this.lowerProduction = lowPro;
        this.energyPerDamage = energyPerDamage;
        this.damageAbsorpationRatio = damageAbsorpationRatio;
        this.texture = texture;
        this.func_77655_b(name + "SolarHelmet");
        this.func_77656_e(0);
    }

    public void onSortedItemToolTip(ItemStack stack, EntityPlayer player, boolean debugTooltip, List<String> tooltip, Map<ToolTipType, List<String>> sortedTooltip) {
        super.onSortedItemToolTip(stack, player, debugTooltip, tooltip, sortedTooltip);
        sortedTooltip.get(ToolTipType.Shift).add(AdvancedSolarLang.helmetProduction.getLocalizedFormatted(new Object[]{this.production}));
        sortedTooltip.get(ToolTipType.Shift).add(AdvancedSolarLang.helmetLowerPorduction.getLocalizedFormatted(new Object[]{this.lowerProduction}));
    }

    public void onArmorTick(World world, EntityPlayer player, ItemStack itemStack) {
        if (!IC2.platform.isRendering() && world.field_73011_w.func_191066_m() && world.func_175710_j(player.func_180425_c())) {
            if (TileEntitySolarPanel.isSunVisible((World)world, (BlockPos)player.func_180425_c())) {
                this.chargeInventory(player, this.production, this.tier, itemStack);
            } else {
                this.chargeInventory(player, this.lowerProduction, this.tier, itemStack);
            }
        }
    }

    public List<Integer> getValidVariants() {
        return Arrays.asList(0);
    }

    public String getTexture() {
        return "advancedsolars" + this.texture;
    }

    public ItemStack getRepairItem() {
        return ItemStack.field_190927_a;
    }

    public double getDamageAbsorptionRatio() {
        return this.damageAbsorpationRatio;
    }

    public int getEnergyPerDamage() {
        return this.energyPerDamage;
    }

    @SideOnly(value=Side.CLIENT)
    public TextureAtlasSprite getTexture(int meta) {
        return Ic2Icons.getTextures((String)"advancedsolars_items")[this.id];
    }

    public int chargeInventory(EntityPlayer player, int provided, int tier, ItemStack helmet) {
        List<NonNullList> invList = Arrays.asList(player.field_71071_by.field_70460_b, player.field_71071_by.field_184439_c, player.field_71071_by.field_70462_a);
        if (ElectricItem.manager.getCharge(helmet) != ElectricItem.manager.getMaxCharge(helmet)) {
            int charged = (int)ElectricItem.manager.charge(helmet, (double)provided, this.tier, false, false);
            provided -= charged;
        } else {
            int i;
            for (NonNullList inventory : invList) {
                int inventorySize = inventory.size();
                for (i = 0; i < inventorySize && provided > 0; ++i) {
                    ItemStack tStack = (ItemStack)inventory.get(i);
                    if (tStack.func_190926_b()) continue;
                    int charged = (int)ElectricItem.manager.charge(tStack, (double)provided, this.tier, false, false);
                    provided -= charged;
                }
            }
            IBaublesPlugin plugin = (IBaublesPlugin)IC2.loader.getPlugin("baubles", IBaublesPlugin.class);
            if (plugin != null) {
                IHasInventory inv = plugin.getBaublesInventory(player);
                for (i = 0; i < inv.getSlotCount() && provided > 0; ++i) {
                    provided = (int)((double)provided - ElectricItem.manager.charge(inv.getStackInSlot(i), (double)provided, tier, false, false));
                }
            }
        }
        return provided;
    }
}

