/*
 * Decompiled with CFR 0.152.
 */
package net.machinemuse.numina.capabilities.inventory;

import java.util.ArrayList;
import java.util.List;
import javax.annotation.Nullable;
import net.machinemuse.numina.capabilities.inventory.IModeChangingItemCapability;
import net.machinemuse.numina.capabilities.inventory.ModularItemWrapper;
import net.machinemuse.numina.module.IRightClickModule;
import net.machinemuse.numina.nbt.MuseNBTUtils;
import net.minecraft.client.Minecraft;
import net.minecraft.client.renderer.texture.TextureAtlasSprite;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.util.NonNullList;

public class ModeChangingItemWrapper
extends ModularItemWrapper
implements IModeChangingItemCapability {
    public static final String TAG_MODE = "mode";
    int activeMode = -1;

    public ModeChangingItemWrapper(ItemStack container, int slotCount, NBTTagCompound nbt) {
        super(container, slotCount, nbt);
    }

    @Override
    public void updateFromNBT() {
        NBTTagCompound nbt = MuseNBTUtils.getMuseItemTag(this.container);
        if (nbt != null && nbt.func_150297_b("modules", 10)) {
            this.deserializeNBT((NBTTagCompound)nbt.func_74781_a("modules"));
            if (this.stacks.size() != this.slotCount) {
                NonNullList oldStacks = this.stacks;
                this.setSize(this.slotCount);
                int count = Math.min(this.slotCount, oldStacks.size());
                for (int slot = 0; slot < count; ++slot) {
                    this.stacks.set(slot, oldStacks.get(slot));
                }
            }
        }
    }

    @Override
    @Nullable
    public TextureAtlasSprite getModeIcon(int modeIndex) {
        if (modeIndex == -1) {
            return null;
        }
        return Minecraft.func_71410_x().func_175599_af().func_175037_a().func_178089_a(this.getStackInSlot(modeIndex)).func_177554_e();
    }

    @Override
    public List<Integer> getValidModes() {
        ArrayList<Integer> moduleIndexes = new ArrayList<Integer>();
        for (int i = 0; i < this.getSlots(); ++i) {
            if (!(this.getStackInSlot(i).func_77973_b() instanceof IRightClickModule)) continue;
            moduleIndexes.add(i);
        }
        return moduleIndexes;
    }

    @Override
    public boolean isValidMode(String mode) {
        for (int i = 0; i < this.getSlots(); ++i) {
            ItemStack module = this.getStackInSlot(i);
            if (module.func_190926_b() || !(module.func_77973_b() instanceof IRightClickModule) || !module.func_77977_a().equals(mode)) continue;
            return true;
        }
        return false;
    }

    @Override
    public ItemStack getActiveModule() {
        int activeModeIndex = this.getActiveMode();
        return activeModeIndex != -1 ? this.getStackInSlot(activeModeIndex) : ItemStack.field_190927_a;
    }

    @Override
    public int getActiveMode() {
        return this.activeMode;
    }

    @Override
    public void setActiveMode(String unLocalizedName) {
        for (int i = 0; i < this.getSlots(); ++i) {
            ItemStack module = this.getStackInSlot(i);
            if (module.func_190926_b() || !module.func_77977_a().equals(unLocalizedName)) continue;
            this.setActiveMode(i);
        }
    }

    @Override
    public void setActiveMode(int newMode) {
        NBTTagCompound nbt = MuseNBTUtils.getMuseItemTag(this.container);
        if (nbt != null && nbt.func_150297_b("modules", 10)) {
            NBTTagCompound moduleNBT = (NBTTagCompound)nbt.func_74781_a("modules");
            moduleNBT.func_74768_a(TAG_MODE, newMode);
            this.deserializeNBT(moduleNBT);
        }
    }

    @Override
    public void cycleMode(EntityPlayer player, int dMode) {
        List<Integer> modes = this.getValidModes();
        if (modes.size() > 0) {
            int newindex = ModeChangingItemWrapper.clampMode(modes.indexOf(this.getActiveMode()) + dMode, modes.size());
            int newmode = modes.get(newindex);
            this.setActiveMode(newmode);
            System.out.println("this is where the packet would normally update");
        }
    }

    @Override
    public int nextMode() {
        List<Integer> modes = this.getValidModes();
        if (modes.size() > 0) {
            int newindex = ModeChangingItemWrapper.clampMode(modes.indexOf(this.getActiveMode()) + 1, modes.size());
            return modes.get(newindex);
        }
        return -1;
    }

    @Override
    public int prevMode() {
        List<Integer> modes = this.getValidModes();
        if (modes.size() > 0) {
            int newindex = ModeChangingItemWrapper.clampMode(modes.indexOf(this.getActiveMode()) - 1, modes.size());
            return modes.get(newindex);
        }
        return -1;
    }

    private static int clampMode(int selection, int modesSize) {
        return selection > 0 ? selection % modesSize : (selection + modesSize * -selection) % modesSize;
    }

    public NBTTagCompound serializeNBT() {
        NBTTagCompound nbt = super.serializeNBT();
        nbt.func_74768_a(TAG_MODE, this.activeMode);
        return nbt;
    }

    public void deserializeNBT(NBTTagCompound nbt) {
        this.activeMode = nbt.func_74764_b(TAG_MODE) ? nbt.func_74762_e(TAG_MODE) : -1;
        super.deserializeNBT(nbt);
    }
}

