/*
 * Decompiled with CFR 0.152.
 */
package mekanism.common.transmitters.grid;

import java.util.Collection;
import java.util.EnumSet;
import java.util.HashSet;
import javax.annotation.Nullable;
import mekanism.api.Coord4D;
import mekanism.api.gas.Gas;
import mekanism.api.gas.GasStack;
import mekanism.api.gas.IGasHandler;
import mekanism.api.transmitters.DynamicNetwork;
import mekanism.api.transmitters.IGridTransmitter;
import mekanism.common.base.target.GasHandlerTarget;
import mekanism.common.capabilities.Capabilities;
import mekanism.common.util.CapabilityUtils;
import mekanism.common.util.EmitUtils;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.EnumFacing;
import net.minecraft.world.IBlockAccess;
import net.minecraftforge.common.MinecraftForge;
import net.minecraftforge.common.capabilities.ICapabilityProvider;
import net.minecraftforge.fml.common.FMLCommonHandler;
import net.minecraftforge.fml.common.eventhandler.Event;

public class GasNetwork
extends DynamicNetwork<IGasHandler, GasNetwork, GasStack> {
    public int transferDelay = 0;
    public boolean didTransfer;
    public boolean prevTransfer;
    public float gasScale;
    public Gas refGas;
    public GasStack buffer;
    public int prevStored;
    public int prevTransferAmount = 0;

    public GasNetwork() {
    }

    public GasNetwork(Collection<GasNetwork> networks) {
        for (GasNetwork net : networks) {
            if (net == null) continue;
            this.adoptTransmittersAndAcceptorsFrom(net);
            net.deregister();
        }
        this.gasScale = this.getScale();
        this.register();
    }

    @Override
    public void adoptTransmittersAndAcceptorsFrom(GasNetwork net) {
        if (FMLCommonHandler.instance().getEffectiveSide().isClient()) {
            if (net.refGas != null && net.gasScale > this.gasScale) {
                this.gasScale = net.gasScale;
                this.refGas = net.refGas;
                this.buffer = net.buffer;
                net.gasScale = 0.0f;
                net.refGas = null;
                net.buffer = null;
            }
        } else if (net.buffer != null) {
            if (this.buffer == null) {
                this.buffer = net.buffer.copy();
            } else if (this.buffer.isGasEqual(net.buffer)) {
                this.buffer.amount += net.buffer.amount;
            } else if (net.buffer.amount > this.buffer.amount) {
                this.buffer = net.buffer.copy();
            }
            net.buffer = null;
        }
        super.adoptTransmittersAndAcceptorsFrom(net);
    }

    @Override
    @Nullable
    public GasStack getBuffer() {
        return this.buffer;
    }

    @Override
    public void absorbBuffer(IGridTransmitter<IGasHandler, GasNetwork, GasStack> transmitter) {
        GasStack gas = transmitter.getBuffer();
        if (gas == null || gas.getGas() == null || gas.amount == 0) {
            return;
        }
        if (this.buffer == null || this.buffer.getGas() == null || this.buffer.amount == 0) {
            this.buffer = gas.copy();
            gas.amount = 0;
            return;
        }
        if (this.buffer.isGasEqual(gas)) {
            this.buffer.amount += gas.amount;
        }
        gas.amount = 0;
    }

    @Override
    public void clampBuffer() {
        if (this.buffer != null && this.buffer.amount > this.getCapacity()) {
            this.buffer.amount = this.capacity;
        }
    }

    public int getGasNeeded() {
        return this.getCapacity() - (this.buffer != null ? this.buffer.amount : 0);
    }

    private int tickEmit(GasStack stack) {
        HashSet<GasHandlerTarget> availableAcceptors = new HashSet<GasHandlerTarget>();
        int totalHandlers = 0;
        Gas type = stack.getGas();
        for (Coord4D coord : this.possibleAcceptors) {
            TileEntity tile;
            EnumSet sides = (EnumSet)this.acceptorDirections.get(coord);
            if (sides == null || sides.isEmpty() || (tile = coord.getTileEntity((IBlockAccess)this.getWorld())) == null) continue;
            GasHandlerTarget target = new GasHandlerTarget(stack);
            for (EnumFacing side : sides) {
                IGasHandler acceptor;
                if (!CapabilityUtils.hasCapability((ICapabilityProvider)tile, Capabilities.GAS_HANDLER_CAPABILITY, side) || (acceptor = CapabilityUtils.getCapability((ICapabilityProvider)tile, Capabilities.GAS_HANDLER_CAPABILITY, side)) == null || !acceptor.canReceiveGas(side, type)) continue;
                target.addHandler(side, acceptor);
            }
            int curHandlers = target.getHandlers().size();
            if (curHandlers <= 0) continue;
            availableAcceptors.add(target);
            totalHandlers += curHandlers;
        }
        return EmitUtils.sendToAcceptors(availableAcceptors, totalHandlers, stack.amount, stack);
    }

    public int emit(GasStack stack, boolean doTransfer) {
        if (this.buffer != null && this.buffer.getGas() != stack.getGas()) {
            return 0;
        }
        int toUse = Math.min(this.getGasNeeded(), stack.amount);
        if (doTransfer) {
            if (this.buffer == null) {
                this.buffer = stack.copy();
                this.buffer.amount = toUse;
            } else {
                this.buffer.amount += toUse;
            }
        }
        return toUse;
    }

    @Override
    public void onUpdate() {
        super.onUpdate();
        if (FMLCommonHandler.instance().getEffectiveSide().isServer()) {
            int stored;
            this.prevTransferAmount = 0;
            if (this.transferDelay == 0) {
                this.didTransfer = false;
            } else {
                --this.transferDelay;
            }
            int n = stored = this.buffer != null ? this.buffer.amount : 0;
            if (stored != this.prevStored) {
                this.needsUpdate = true;
            }
            this.prevStored = stored;
            if (this.didTransfer != this.prevTransfer || this.needsUpdate) {
                MinecraftForge.EVENT_BUS.post((Event)new GasTransferEvent(this, this.buffer, this.didTransfer));
                this.needsUpdate = false;
            }
            this.prevTransfer = this.didTransfer;
            if (this.buffer != null) {
                this.prevTransferAmount = this.tickEmit(this.buffer);
                if (this.prevTransferAmount > 0) {
                    this.didTransfer = true;
                    this.transferDelay = 2;
                }
                this.buffer.amount -= this.prevTransferAmount;
                if (this.buffer.amount <= 0) {
                    this.buffer = null;
                }
            }
        }
    }

    @Override
    public void clientTick() {
        super.clientTick();
        this.gasScale = Math.max(this.gasScale, this.getScale());
        if (this.didTransfer && this.gasScale < 1.0f) {
            this.gasScale = Math.max(this.getScale(), Math.min(1.0f, this.gasScale + 0.02f));
        } else if (!this.didTransfer && this.gasScale > 0.0f) {
            this.gasScale = Math.max(this.getScale(), Math.max(0.0f, this.gasScale - 0.02f));
            if (this.gasScale == 0.0f) {
                this.buffer = null;
            }
        }
    }

    public float getScale() {
        return Math.min(1.0f, this.buffer == null || this.getCapacity() == 0 ? 0.0f : (float)this.buffer.amount / (float)this.getCapacity());
    }

    public String toString() {
        return "[GasNetwork] " + this.transmitters.size() + " transmitters, " + this.possibleAcceptors.size() + " acceptors.";
    }

    @Override
    public String getNeededInfo() {
        return Integer.toString(this.getGasNeeded());
    }

    @Override
    public String getStoredInfo() {
        return this.buffer != null ? this.buffer.getGas().getLocalizedName() + " (" + this.buffer.amount + ")" : "None";
    }

    @Override
    public String getFlowInfo() {
        return this.prevTransferAmount + "/t";
    }

    @Override
    public boolean isCompatibleWith(GasNetwork other) {
        return super.isCompatibleWith(other) && (this.buffer == null || other.buffer == null || this.buffer.isGasEqual(other.buffer));
    }

    @Override
    public boolean compatibleWithBuffer(GasStack buffer) {
        return super.compatibleWithBuffer(buffer) && (this.buffer == null || buffer == null || this.buffer.isGasEqual(buffer));
    }

    public static class GasTransferEvent
    extends Event {
        public final GasNetwork gasNetwork;
        public final GasStack transferType;
        public final boolean didTransfer;

        public GasTransferEvent(GasNetwork network, GasStack type, boolean did) {
            this.gasNetwork = network;
            this.transferType = type;
            this.didTransfer = did;
        }
    }
}

