/*
 * Decompiled with CFR 0.152.
 */
package mekanism.common.recipe.inputs;

import mekanism.api.gas.GasStack;
import mekanism.api.gas.GasTank;
import mekanism.common.recipe.inputs.MachineInput;
import net.minecraft.nbt.NBTTagCompound;

public class ChemicalPairInput
extends MachineInput<ChemicalPairInput> {
    public GasStack leftGas;
    public GasStack rightGas;

    public ChemicalPairInput(GasStack left, GasStack right) {
        this.leftGas = left;
        this.rightGas = right;
    }

    public ChemicalPairInput() {
    }

    @Override
    public void load(NBTTagCompound nbtTags) {
        this.leftGas = GasStack.readFromNBT(nbtTags.func_74775_l("leftInput"));
        this.rightGas = GasStack.readFromNBT(nbtTags.func_74775_l("rightInput"));
    }

    public boolean useGas(GasTank leftTank, GasTank rightTank, boolean deplete, int scale) {
        int leftAmount = this.leftGas.amount * scale;
        int rightAmount = this.rightGas.amount * scale;
        if (leftTank.canDraw(this.leftGas.getGas()) && rightTank.canDraw(this.rightGas.getGas())) {
            if (leftTank.getStored() >= leftAmount && rightTank.getStored() >= rightAmount) {
                leftTank.draw(leftAmount, deplete);
                rightTank.draw(rightAmount, deplete);
                return true;
            }
        } else if (leftTank.canDraw(this.rightGas.getGas()) && rightTank.canDraw(this.leftGas.getGas()) && leftTank.getStored() >= rightAmount && rightTank.getStored() >= leftAmount) {
            leftTank.draw(rightAmount, deplete);
            rightTank.draw(leftAmount, deplete);
            return true;
        }
        return false;
    }

    @Override
    public boolean isValid() {
        return this.leftGas != null && this.rightGas != null;
    }

    public boolean meetsInput(ChemicalPairInput input) {
        return this.meets(input) || this.meets(input.swap());
    }

    public ChemicalPairInput swap() {
        return new ChemicalPairInput(this.rightGas, this.leftGas);
    }

    public void draw(GasTank leftTank, GasTank rightTank) {
        if (this.meets(new ChemicalPairInput(leftTank.getGas(), rightTank.getGas()))) {
            leftTank.draw(this.leftGas.amount, true);
            rightTank.draw(this.rightGas.amount, true);
        } else if (this.meets(new ChemicalPairInput(rightTank.getGas(), leftTank.getGas()))) {
            leftTank.draw(this.rightGas.amount, true);
            rightTank.draw(this.leftGas.amount, true);
        }
    }

    public boolean containsType(GasStack stack) {
        if (stack == null || stack.amount == 0) {
            return false;
        }
        return stack.isGasEqual(this.leftGas) || stack.isGasEqual(this.rightGas);
    }

    private boolean meets(ChemicalPairInput input) {
        if (input == null || !input.isValid()) {
            return false;
        }
        if (input.leftGas.getGas() != this.leftGas.getGas() || input.rightGas.getGas() != this.rightGas.getGas()) {
            return false;
        }
        return input.leftGas.amount >= this.leftGas.amount && input.rightGas.amount >= this.rightGas.amount;
    }

    @Override
    public ChemicalPairInput copy() {
        return new ChemicalPairInput(this.leftGas.copy(), this.rightGas.copy());
    }

    @Override
    public int hashIngredients() {
        return (this.leftGas.hashCode() << 8 | this.rightGas.hashCode()) + (this.rightGas.hashCode() << 8 | this.leftGas.hashCode());
    }

    @Override
    public boolean testEquality(ChemicalPairInput other) {
        if (!this.isValid()) {
            return !other.isValid();
        }
        return other.leftGas.hashCode() == this.leftGas.hashCode() && other.rightGas.hashCode() == this.rightGas.hashCode() || other.leftGas.hashCode() == this.rightGas.hashCode() && other.rightGas.hashCode() == this.leftGas.hashCode();
    }

    @Override
    public boolean isInstance(Object other) {
        return other instanceof ChemicalPairInput;
    }
}

