/*
 * Decompiled with CFR 0.152.
 */
package mekanism.client.sound;

import mekanism.client.ClientTickHandler;
import mekanism.client.sound.PlayerSound;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.util.ResourceLocation;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;

@SideOnly(value=Side.CLIENT)
public class FlamethrowerSound
extends PlayerSound {
    private static ResourceLocation IDLE_SOUND = new ResourceLocation("mekanism", "item.flamethrower.idle");
    private static ResourceLocation ON_SOUND = new ResourceLocation("mekanism", "item.flamethrower.active");
    private static ResourceLocation OFF_SOUND = new ResourceLocation("mekanism", "item.flamethrower.active");
    private boolean inUse;

    public FlamethrowerSound(EntityPlayer player) {
        super(player, IDLE_SOUND);
        this.inUse = ClientTickHandler.isFlamethrowerOn(player);
        this.field_147664_a = this.inUse ? ON_SOUND : OFF_SOUND;
    }

    @Override
    public boolean shouldPlaySound() {
        boolean hasFlamethrower = ClientTickHandler.hasFlamethrower(this.player);
        boolean isFlamethrowerOn = ClientTickHandler.isFlamethrowerOn(this.player);
        if (!hasFlamethrower) {
            return false;
        }
        if (this.inUse != isFlamethrowerOn) {
            this.inUse = isFlamethrowerOn;
            this.field_147664_a = this.inUse ? ON_SOUND : OFF_SOUND;
        }
        return true;
    }
}

