/*
 * Decompiled with CFR 0.152.
 */
package de.ellpeck.actuallyadditions.mod;

import de.ellpeck.actuallyadditions.mod.blocks.InitBlocks;
import de.ellpeck.actuallyadditions.mod.config.values.ConfigBoolValues;
import de.ellpeck.actuallyadditions.mod.crafting.InitCrafting;
import de.ellpeck.actuallyadditions.mod.gen.village.InitVillager;
import de.ellpeck.actuallyadditions.mod.items.InitItems;
import de.ellpeck.actuallyadditions.mod.misc.SoundHandler;
import de.ellpeck.actuallyadditions.mod.ore.InitOreDict;
import java.util.ArrayList;
import java.util.List;
import net.minecraft.block.Block;
import net.minecraft.item.Item;
import net.minecraft.item.crafting.IRecipe;
import net.minecraft.util.SoundEvent;
import net.minecraftforge.event.RegistryEvent;
import net.minecraftforge.fml.common.eventhandler.SubscribeEvent;
import net.minecraftforge.fml.common.registry.VillagerRegistry;
import net.minecraftforge.registries.IForgeRegistryEntry;

public class RegistryHandler {
    public static final List<Block> BLOCKS_TO_REGISTER = new ArrayList<Block>();
    public static final List<Item> ITEMS_TO_REGISTER = new ArrayList<Item>();
    public static final List<SoundEvent> SOUNDS_TO_REGISTER = new ArrayList<SoundEvent>();
    public static final List<IRecipe> RECIPES_TO_REGISTER = new ArrayList<IRecipe>();

    @SubscribeEvent
    public void onBlockRegistry(RegistryEvent.Register<Block> event) {
        InitBlocks.init();
        for (Block block : BLOCKS_TO_REGISTER) {
            event.getRegistry().register((IForgeRegistryEntry)block);
        }
    }

    @SubscribeEvent
    public void onItemRegistry(RegistryEvent.Register<Item> event) {
        InitItems.init();
        for (Item item : ITEMS_TO_REGISTER) {
            event.getRegistry().register((IForgeRegistryEntry)item);
        }
        ITEMS_TO_REGISTER.clear();
        InitOreDict.init();
    }

    @SubscribeEvent
    public void onVillagerRegistry(RegistryEvent.Register<VillagerRegistry.VillagerProfession> event) {
        InitVillager.init();
        if (ConfigBoolValues.JAM_VILLAGER_EXISTS.isEnabled()) {
            event.getRegistry().register((IForgeRegistryEntry)InitVillager.jamProfession);
        }
        if (ConfigBoolValues.ENGINEER_VILLAGER_EXISTS.isEnabled()) {
            event.getRegistry().register((IForgeRegistryEntry)InitVillager.engineerProfession);
        }
    }

    @SubscribeEvent
    public void onCraftingRegistry(RegistryEvent.Register<IRecipe> event) {
        InitCrafting.init();
        for (IRecipe recipe : RECIPES_TO_REGISTER) {
            event.getRegistry().register((IForgeRegistryEntry)recipe);
        }
        RECIPES_TO_REGISTER.clear();
    }

    @SubscribeEvent
    public void onSoundRegistry(RegistryEvent.Register<SoundEvent> event) {
        SoundHandler.init();
        for (SoundEvent sound : SOUNDS_TO_REGISTER) {
            event.getRegistry().register((IForgeRegistryEntry)sound);
        }
        SOUNDS_TO_REGISTER.clear();
    }
}

