/*
 * Decompiled with CFR 0.152.
 */
package net.doubledoordev.itemblacklist.util;

import net.doubledoordev.itemblacklist.Helper;
import net.doubledoordev.itemblacklist.ItemBlacklist;
import net.doubledoordev.itemblacklist.data.GlobalBanList;
import net.minecraft.block.Block;
import net.minecraft.block.state.IBlockState;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.inventory.IInventory;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.util.text.ITextComponent;
import net.minecraft.util.text.TextComponentString;
import net.minecraftforge.common.util.BlockSnapshot;
import net.minecraftforge.event.entity.item.ItemTossEvent;
import net.minecraftforge.event.entity.player.EntityItemPickupEvent;
import net.minecraftforge.event.entity.player.PlayerContainerEvent;
import net.minecraftforge.event.entity.player.PlayerInteractEvent;
import net.minecraftforge.event.world.BlockEvent;
import net.minecraftforge.fml.common.eventhandler.EventPriority;
import net.minecraftforge.fml.common.eventhandler.SubscribeEvent;
import net.minecraftforge.fml.common.gameevent.PlayerEvent;

public class ServerEventHandlers {
    public static final ServerEventHandlers I = new ServerEventHandlers();

    private ServerEventHandlers() {
    }

    @SubscribeEvent(priority=EventPriority.HIGHEST)
    public void multiPlaceEvent(BlockEvent.MultiPlaceEvent event) {
        EntityPlayer player = event.getPlayer();
        ItemStack itemInMainHand = player.func_184614_ca();
        ItemStack itemInOffHand = player.func_184592_cb();
        if (itemInMainHand.func_190926_b() || itemInOffHand.func_190926_b()) {
            return;
        }
        if (!Helper.shouldCare(event.getPlayer())) {
            return;
        }
        if (GlobalBanList.isBanned(player.field_71093_bK, itemInMainHand) || GlobalBanList.isBanned(player.field_71093_bK, itemInOffHand)) {
            player.func_146105_b((ITextComponent)new TextComponentString(ItemBlacklist.message), true);
            if (ItemBlacklist.log) {
                ItemBlacklist.getLogger().info("{} tried to use {} or {} at {} (Place Block. Banned Item in hand)", (Object)player.func_70005_c_(), (Object)itemInMainHand.func_82833_r(), (Object)itemInOffHand.func_82833_r(), (Object)event.getPos());
            }
            if (event.isCancelable()) {
                event.setCanceled(true);
            }
            GlobalBanList.process(player.field_71093_bK, (IInventory)player.field_71071_by);
        } else {
            for (BlockSnapshot blockSnapshot : event.getReplacedBlockSnapshots()) {
                IBlockState blockState = blockSnapshot.getCurrentBlock();
                Block block = blockState.func_177230_c();
                Item item = Item.func_150898_a((Block)block);
                ItemStack stack = new ItemStack(item, 1, block.func_180651_a(blockState));
                if (!GlobalBanList.isBanned(player.field_71093_bK, stack)) continue;
                player.func_146105_b((ITextComponent)new TextComponentString(ItemBlacklist.message), true);
                if (ItemBlacklist.log) {
                    ItemBlacklist.getLogger().info("{} tried to use {} or {} at {} (Place Block. Banned Item placed)", (Object)player.func_70005_c_(), (Object)itemInMainHand.func_82833_r(), (Object)itemInOffHand.func_82833_r(), (Object)event.getPos());
                }
                if (event.isCancelable()) {
                    event.setCanceled(true);
                }
                GlobalBanList.process(player.field_71093_bK, (IInventory)player.field_71071_by);
                break;
            }
        }
    }

    @SubscribeEvent(priority=EventPriority.HIGHEST)
    public void blockPlaceEvent(BlockEvent.PlaceEvent event) {
        EntityPlayer player = event.getPlayer();
        ItemStack itemInMainHand = player.func_184614_ca();
        ItemStack itemInOffHand = player.func_184592_cb();
        if (itemInMainHand.func_190926_b() || itemInOffHand.func_190926_b()) {
            return;
        }
        if (!Helper.shouldCare(player)) {
            return;
        }
        IBlockState blockState = event.getBlockSnapshot().getCurrentBlock();
        Block block = blockState.func_177230_c();
        Item item = Item.func_150898_a((Block)block);
        ItemStack stack = new ItemStack(item, 1, block.func_180651_a(blockState));
        if (GlobalBanList.isBanned(player.field_71093_bK, itemInMainHand) || GlobalBanList.isBanned(player.field_71093_bK, itemInOffHand)) {
            player.func_146105_b((ITextComponent)new TextComponentString(ItemBlacklist.message), true);
            if (ItemBlacklist.log) {
                ItemBlacklist.getLogger().info("{} tried to use {} or {} at {} (Place Block. Banned Item in hand)", (Object)player.func_70005_c_(), (Object)itemInMainHand.func_82833_r(), (Object)itemInOffHand.func_82833_r(), (Object)event.getPos());
            }
            if (event.isCancelable()) {
                event.setCanceled(true);
            }
            GlobalBanList.process(player.field_71093_bK, (IInventory)player.field_71071_by);
        } else if (GlobalBanList.isBanned(player.field_71093_bK, stack)) {
            player.func_146105_b((ITextComponent)new TextComponentString(ItemBlacklist.message), true);
            if (ItemBlacklist.log) {
                ItemBlacklist.getLogger().info("{} tried to use {} or {} at {} (Place Block. Banned Item placed)", (Object)player.func_70005_c_(), (Object)itemInMainHand.func_82833_r(), (Object)itemInOffHand.func_82833_r(), (Object)event.getPos());
            }
            if (event.isCancelable()) {
                event.setCanceled(true);
            }
            GlobalBanList.process(player.field_71093_bK, (IInventory)player.field_71071_by);
        }
    }

    @SubscribeEvent(priority=EventPriority.HIGHEST)
    public void playerInteractEvent(PlayerInteractEvent event) {
        EntityPlayer player = event.getEntityPlayer();
        ItemStack stack = event.getItemStack();
        if (stack.func_190926_b() || !Helper.shouldCare(player)) {
            return;
        }
        if (GlobalBanList.isBanned(player.field_71093_bK, stack)) {
            player.func_146105_b((ITextComponent)new TextComponentString(ItemBlacklist.message), true);
            if (ItemBlacklist.log) {
                ItemBlacklist.getLogger().info("{} tried to use {} at {} ({})", (Object)player.func_70005_c_(), (Object)stack.func_82833_r(), (Object)event.getPos(), (Object)event.getFace());
            }
            if (event.isCancelable()) {
                event.setCanceled(true);
            }
            GlobalBanList.process(player.field_71093_bK, (IInventory)player.field_71071_by);
        }
    }

    @SubscribeEvent(priority=EventPriority.HIGHEST)
    public void changeDimension(PlayerEvent.PlayerChangedDimensionEvent event) {
        if (!Helper.shouldCare(event.player)) {
            return;
        }
        GlobalBanList.process(event.toDim, (IInventory)event.player.field_71071_by);
    }

    @SubscribeEvent(priority=EventPriority.HIGHEST)
    public void itemTossEvent(ItemTossEvent event) {
        EntityPlayer player = event.getPlayer();
        if (!Helper.shouldCare(player)) {
            return;
        }
        event.getEntityItem().func_92058_a(GlobalBanList.process(player.field_71093_bK, event.getEntityItem().func_92059_d()));
    }

    @SubscribeEvent(priority=EventPriority.HIGHEST)
    public void entityItemPickupEvent(EntityItemPickupEvent event) {
        EntityPlayer player = event.getEntityPlayer();
        if (!Helper.shouldCare(player)) {
            return;
        }
        event.getItem().func_92058_a(GlobalBanList.process(player.field_71093_bK, event.getItem().func_92059_d()));
    }

    @SubscribeEvent(priority=EventPriority.HIGHEST)
    public void playerOpenContainerEvent(PlayerContainerEvent.Close event) {
        EntityPlayer player = event.getEntityPlayer();
        if (!Helper.shouldCare(player)) {
            return;
        }
        if (ItemBlacklist.instance.containerban) {
            GlobalBanList.process(player.field_71093_bK, player.field_71070_bA, player);
        }
    }
}

