/*
 * Decompiled with CFR 0.152.
 */
package vswe.superfactory.proxy;

import net.minecraft.block.Block;
import net.minecraft.client.renderer.block.model.ModelBakery;
import net.minecraft.client.renderer.block.model.ModelResourceLocation;
import net.minecraft.item.Item;
import net.minecraft.util.ResourceLocation;
import net.minecraftforge.client.event.ModelRegistryEvent;
import net.minecraftforge.client.model.ICustomModelLoader;
import net.minecraftforge.client.model.ModelLoaderRegistry;
import net.minecraftforge.fml.common.Mod;
import net.minecraftforge.fml.common.eventhandler.SubscribeEvent;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;
import vswe.superfactory.blocks.client.ModelLoader;
import vswe.superfactory.proxy.CommonProxy;
import vswe.superfactory.registry.ModBlocks;
import vswe.superfactory.registry.ModItems;
import vswe.superfactory.settings.Settings;

@Mod.EventBusSubscriber(modid="superfactorymanager", value={Side.CLIENT})
public class ClientProxy
extends CommonProxy {
    private static void addVariantNames(Block block, String ... names) {
        ResourceLocation[] locations = new ResourceLocation[names.length];
        for (int i = 0; i < names.length; ++i) {
            locations[i] = new ResourceLocation(ClientProxy.getResource(names[i]));
        }
        if (block != null) {
            ModelBakery.registerItemVariants((Item)Item.func_150898_a((Block)block), (ResourceLocation[])locations);
        }
    }

    private static void registerBlockModelForVariant(Block base, int meta, String variant) {
        ClientProxy.registerBlockModel(base, meta, ClientProxy.getResource(variant));
    }

    private static void registerBlockModel(Block block) {
        ResourceLocation resourceLocation = (ResourceLocation)Block.field_149771_c.func_177774_c((Object)block);
        ClientProxy.registerBlockModel(block, 0, resourceLocation.toString());
    }

    private static void registerBlockModel(Block block, int meta, String modelName) {
        ClientProxy.registerItemModel(Item.func_150898_a((Block)block), meta, modelName);
    }

    private static void registerItemModel(Item item, int meta, String resourcePath) {
        ModelResourceLocation modelResourceLocation = new ModelResourceLocation(resourcePath, "inventory");
        net.minecraftforge.client.model.ModelLoader.setCustomModelResourceLocation((Item)item, (int)meta, (ModelResourceLocation)modelResourceLocation);
    }

    public static String getResource(String resource) {
        return "superfactorymanager".toLowerCase() + ":" + resource;
    }

    @SideOnly(value=Side.CLIENT)
    @SubscribeEvent
    public static void registerRenderers(ModelRegistryEvent event) {
        ClientProxy.addVariantNames(ModBlocks.CABLE_RELAY, "cable_relay", "cable_relay_advanced");
        ClientProxy.addVariantNames(ModBlocks.CABLE_INTAKE, "cable_valve", "cable_valve_instant");
        ClientProxy.addVariantNames(ModBlocks.CABLE_CLUSTER, "cable_cluster", "cable_cluster_advanced");
        ClientProxy.addVariantNames(ModBlocks.CABLE_CAMOUFLAGE, "cable_camouflage", "cable_camouflage_inside", "cable_camouflage_shape");
        ClientProxy.registerBlockModel(ModBlocks.MANAGER);
        ClientProxy.registerBlockModel(ModBlocks.CABLE);
        ClientProxy.registerBlockModel(ModBlocks.CABLE_OUTPUT);
        ClientProxy.registerBlockModel(ModBlocks.CABLE_INPUT);
        ClientProxy.registerBlockModel(ModBlocks.CABLE_BUD);
        ClientProxy.registerBlockModel(ModBlocks.CABLE_BREAKER);
        ClientProxy.registerBlockModel(ModBlocks.CABLE_SIGN);
        ClientProxy.registerBlockModelForVariant(ModBlocks.CABLE_RELAY, 0, "cable_relay");
        ClientProxy.registerBlockModelForVariant(ModBlocks.CABLE_RELAY, 8, "cable_relay_advanced");
        ClientProxy.registerBlockModelForVariant(ModBlocks.CABLE_INTAKE, 0, "cable_valve");
        ClientProxy.registerBlockModelForVariant(ModBlocks.CABLE_INTAKE, 8, "cable_valve_instant");
        ClientProxy.registerBlockModelForVariant(ModBlocks.CABLE_CLUSTER, 0, "cable_cluster");
        ClientProxy.registerBlockModelForVariant(ModBlocks.CABLE_CLUSTER, 8, "cable_cluster_advanced");
        ClientProxy.registerBlockModelForVariant(ModBlocks.CABLE_CAMOUFLAGE, 0, "cable_camouflage");
        ClientProxy.registerBlockModelForVariant(ModBlocks.CABLE_CAMOUFLAGE, 1, "cable_camouflage_inside");
        ClientProxy.registerBlockModelForVariant(ModBlocks.CABLE_CAMOUFLAGE, 2, "cable_camouflage_shape");
        ClientProxy.registerItemModel(ModItems.DISK, 0, ModItems.DISK.getRegistryName().toString());
    }

    @Override
    public void preInit() {
        Settings.load();
        ModelLoaderRegistry.registerLoader((ICustomModelLoader)new ModelLoader());
    }
}

