/*
 * Decompiled with CFR 0.152.
 */
package net.romvoid95.galactic.core;

import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import net.romvoid95.galactic.core.config.CoreConfig;
import org.apache.commons.lang3.SystemUtils;
import org.apache.commons.lang3.text.WordUtils;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;

public final class GCTLog {
    private static final Logger logger = LogManager.getLogger((String)"GalacticTweaks");

    public static void info(String msg) {
        logger.info(msg);
    }

    public static void info(String msg, Object ... params) {
        logger.info(msg, params);
    }

    public static void warn(String msg) {
        logger.warn(msg);
    }

    public static void warn(String msg, Object ... params) {
        logger.warn(msg, params);
    }

    public static void warn(Throwable t, String msg, Object ... params) {
        logger.warn(msg, params);
    }

    public static void error(String msg, Object ... params) {
        logger.error(msg, params);
    }

    public static void fatal(String msg, Object ... params) {
        logger.fatal(msg, params);
    }

    public static void trace(String msg, Object ... params) {
        logger.trace(msg, params);
    }

    public static void catching(Throwable t) {
        logger.catching(t);
    }

    public static void debug(String msg) {
        if (CoreConfig.enableDebugLog.get()) {
            GCTLog.info("*******************************[GCT DEBUG]**************************************");
            for (String subline : GCTLog.wrapString(msg, 78, false, new ArrayList<String>())) {
                GCTLog.info("* " + subline);
            }
            GCTLog.info("********************************************************************************");
        }
    }

    public static void noticableWarning(boolean trace, List<String> lines) {
        GCTLog.error("********************************************************************************", new Object[0]);
        for (String line : lines) {
            for (String subline : GCTLog.wrapString(line, 78, false, new ArrayList<String>())) {
                GCTLog.error("* " + subline, new Object[0]);
            }
        }
        if (trace) {
            StackTraceElement[] stackTrace = Thread.currentThread().getStackTrace();
            for (int i = 2; i < 8 && i < stackTrace.length; ++i) {
                GCTLog.warn("*  at {}{}", stackTrace[i].toString(), i == 7 ? "..." : "");
            }
        }
        GCTLog.error("********************************************************************************", new Object[0]);
    }

    public static void noticableWarning(boolean trace, String ... lines) {
        GCTLog.error("********************************************************************************", new Object[0]);
        for (String line : lines) {
            for (String subline : GCTLog.wrapString(line, 78, false, new ArrayList<String>())) {
                GCTLog.error("* " + subline, new Object[0]);
            }
        }
        if (trace) {
            StackTraceElement[] stackTrace = Thread.currentThread().getStackTrace();
            for (int i = 2; i < 8 && i < stackTrace.length; ++i) {
                GCTLog.warn("*  at {}{}", stackTrace[i].toString(), i == 7 ? "..." : "");
            }
        }
        GCTLog.error("********************************************************************************", new Object[0]);
    }

    private static List<String> wrapString(String string, int lnLength, boolean wrapLongWords, List<String> list) {
        String[] lines = WordUtils.wrap((String)string, (int)lnLength, null, (boolean)wrapLongWords).split(SystemUtils.LINE_SEPARATOR);
        Collections.addAll(list, lines);
        return list;
    }

    private GCTLog() {
        throw new UnsupportedOperationException("This is a utility class and cannot be instantiated");
    }
}

