/*
 * Decompiled with CFR 0.152.
 */
package net.romvoid95.api.config.values;

import net.romvoid95.api.config.Range;
import net.romvoid95.api.config.def.Category;
import net.romvoid95.api.config.def.Comment;
import net.romvoid95.api.config.def.Key;
import net.romvoid95.api.config.values.OptValue;

public class OptInteger
extends OptValue {
    public int valueInt;
    private Range<Integer> range;
    private boolean hasRange;

    public OptInteger(Key key, Category category, Comment comment, int defaultValue) {
        super(OptValue.Type.INTEGER, key, category, comment);
        this.valueInt = defaultValue;
        this.hasRange = false;
        this.formatDescription(String.valueOf(defaultValue));
    }

    public OptInteger(Key key, Category category, Comment comment, int defaultValue, int minValueInt, int maxValueInt) {
        super(OptValue.Type.INTEGER, key, category, comment);
        this.range = Range.of(minValueInt, maxValueInt);
        this.hasRange = true;
        this.valueInt = defaultValue;
        this.formatDescription(Range.of(minValueInt, maxValueInt).commentAddl(defaultValue));
    }

    public boolean hasRange() {
        return this.hasRange;
    }

    public int min() {
        return this.range.min();
    }

    public int max() {
        return this.range.max();
    }

    public int get() {
        return this.valueInt;
    }

    public void set(int value) {
        this.valueInt = value;
    }
}

