/*
 * Decompiled with CFR 0.152.
 */
package vazkii.botania.common.block.tile;

import java.awt.Color;
import java.util.ArrayList;
import java.util.List;
import javax.annotation.Nonnull;
import net.minecraft.block.Block;
import net.minecraft.block.properties.IProperty;
import net.minecraft.block.state.IBlockState;
import net.minecraft.entity.Entity;
import net.minecraft.entity.item.EntityEnderPearl;
import net.minecraft.entity.item.EntityItem;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.entity.player.EntityPlayerMP;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.network.datasync.DataParameter;
import net.minecraft.network.datasync.DataSerializer;
import net.minecraft.network.datasync.DataSerializers;
import net.minecraft.network.datasync.EntityDataManager;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.DamageSource;
import net.minecraft.util.EnumFacing;
import net.minecraft.util.ITickable;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.math.AxisAlignedBB;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.Vec3i;
import net.minecraft.world.IBlockAccess;
import net.minecraft.world.World;
import vazkii.botania.api.state.BotaniaStateProps;
import vazkii.botania.api.state.enums.LuminizerVariant;
import vazkii.botania.api.wand.IWandBindable;
import vazkii.botania.common.Botania;
import vazkii.botania.common.block.ModBlocks;
import vazkii.botania.common.block.tile.TileAnimatedTorch;
import vazkii.botania.common.block.tile.TileMod;
import vazkii.botania.common.core.handler.ModSounds;
import vazkii.botania.common.core.helper.PlayerHelper;
import vazkii.botania.common.core.helper.Vector3;

public class TileLightRelay
extends TileMod
implements ITickable,
IWandBindable {
    private static final int MAX_DIST = 20;
    private static final String TAG_BIND_X = "bindX";
    private static final String TAG_BIND_Y = "bindY";
    private static final String TAG_BIND_Z = "bindZ";
    private BlockPos bindPos = new BlockPos(0, -1, 0);
    private int ticksElapsed = 0;

    public void mountEntity(Entity e) {
        BlockPos nextDest = this.getNextDestination();
        if (e.func_184218_aH() || this.field_145850_b.field_72995_K || nextDest == null || !this.isValidBinding()) {
            return;
        }
        EntityPlayerMover mover = new EntityPlayerMover(this.field_145850_b, this.field_174879_c, nextDest);
        this.field_145850_b.func_72838_d((Entity)mover);
        e.func_184220_m((Entity)mover);
        if (!(e instanceof EntityItem)) {
            mover.func_184185_a(ModSounds.lightRelay, 0.2f, (float)Math.random() * 0.3f + 0.7f);
        }
        if (e instanceof EntityPlayerMP) {
            PlayerHelper.grantCriterion((EntityPlayerMP)e, new ResourceLocation("botania", "main/luminizer_ride"), "code_triggered");
        }
    }

    public void func_73660_a() {
        block3: {
            block4: {
                ++this.ticksElapsed;
                BlockPos nextDest = this.getNextDestination();
                if (nextDest == null || nextDest.func_177956_o() <= -1 || !this.isValidBinding()) break block3;
                if (!this.field_145850_b.field_72995_K) break block4;
                Vector3 vec = this.getMovementVector();
                if (vec == null) break block3;
                double dist = 0.1;
                int size = (int)(vec.mag() / dist);
                int count = 10;
                int start = this.ticksElapsed % size;
                Vector3 vecMag = vec.normalize().multiply(dist);
                Vector3 vecTip = vecMag.multiply(start).add((double)this.field_174879_c.func_177958_n() + 0.5, (double)this.field_174879_c.func_177956_o() + 0.5, (double)this.field_174879_c.func_177952_p() + 0.5);
                double radPer = 0.19634954084936207;
                float mul = 0.5f;
                float mulPer = 0.4f;
                float maxMul = 2.0f;
                for (int i = start; i < start + count; ++i) {
                    mul = Math.min(maxMul, mul + mulPer);
                    double rad = radPer * ((double)i + (double)this.ticksElapsed * 0.4);
                    Vector3 vecRot = vecMag.crossProduct(Vector3.ONE).multiply(mul).rotate(rad, vecMag).add(vecTip);
                    Botania.proxy.wispFX(vecRot.x, vecRot.y, vecRot.z, 0.4f, 0.4f, 1.0f, 0.1f, (float)(-vecMag.x), (float)(-vecMag.y), (float)(-vecMag.z), 1.0f);
                    vecTip = vecTip.add(vecMag);
                }
                break block3;
            }
            BlockPos endpoint = this.getEndpoint();
            if (endpoint != null) {
                AxisAlignedBB aabb = ModBlocks.lightRelay.func_185496_a(this.field_145850_b.func_180495_p(this.field_174879_c), (IBlockAccess)this.field_145850_b, this.field_174879_c).func_186670_a(this.field_174879_c);
                float range = 0.5f;
                List enderPearls = this.field_145850_b.func_72872_a(EntityEnderPearl.class, aabb.func_186662_g((double)range));
                for (EntityEnderPearl pearl : enderPearls) {
                    pearl.func_70634_a((double)endpoint.func_177958_n() + pearl.field_70165_t - (double)this.field_174879_c.func_177958_n(), (double)endpoint.func_177956_o() + pearl.field_70163_u - (double)this.field_174879_c.func_177956_o(), (double)endpoint.func_177952_p() + pearl.field_70161_v - (double)this.field_174879_c.func_177952_p());
                }
            }
        }
    }

    private boolean isValidBinding() {
        BlockPos nextDest = this.getNextDestination();
        if (nextDest == null) {
            return false;
        }
        Block block = this.field_145850_b.func_180495_p(nextDest).func_177230_c();
        return block == ModBlocks.lightRelay;
    }

    private BlockPos getEndpoint() {
        ArrayList<TileLightRelay> pointsPassed = new ArrayList<TileLightRelay>();
        TileLightRelay relay = this;
        BlockPos lastCoords = null;
        boolean run = true;
        while (run) {
            if (pointsPassed.contains(relay)) {
                return null;
            }
            pointsPassed.add(relay);
            BlockPos coords = relay.getNextDestination();
            if (coords == null) {
                return lastCoords;
            }
            TileEntity tile = this.field_145850_b.func_175625_s(coords);
            if (tile == null || !(tile instanceof TileLightRelay)) {
                return lastCoords;
            }
            relay = (TileLightRelay)tile;
            lastCoords = coords;
        }
        return null;
    }

    public Vector3 getMovementVector() {
        BlockPos dest = this.getNextDestination();
        if (dest == null) {
            return null;
        }
        return new Vector3(dest.func_177958_n() - this.field_174879_c.func_177958_n(), dest.func_177956_o() - this.field_174879_c.func_177956_o(), dest.func_177952_p() - this.field_174879_c.func_177952_p());
    }

    @Override
    public BlockPos getBinding() {
        return this.bindPos;
    }

    public BlockPos getNextDestination() {
        IBlockState state = this.field_145850_b.func_180495_p(this.field_174879_c);
        if (state.func_177229_b(BotaniaStateProps.LUMINIZER_VARIANT) == LuminizerVariant.TOGGLE && ((Boolean)state.func_177229_b((IProperty)BotaniaStateProps.POWERED)).booleanValue()) {
            return null;
        }
        if (state.func_177229_b(BotaniaStateProps.LUMINIZER_VARIANT) == LuminizerVariant.FORK) {
            BlockPos torchPos = null;
            for (int i = -2; i < 3; ++i) {
                BlockPos testPos = this.field_174879_c.func_177982_a(0, i, 0);
                IBlockState testState = this.field_145850_b.func_180495_p(testPos);
                if (testState.func_177230_c() != ModBlocks.animatedTorch) continue;
                torchPos = testPos;
                break;
            }
            if (torchPos != null) {
                TileAnimatedTorch torch = (TileAnimatedTorch)this.field_145850_b.func_175625_s(torchPos);
                EnumFacing side = TileAnimatedTorch.SIDES[torch.side].func_176734_d();
                for (int i = 1; i < 20; ++i) {
                    BlockPos testPos = this.field_174879_c.func_177967_a(side, i);
                    IBlockState testState = this.field_145850_b.func_180495_p(testPos);
                    if (testState.func_177230_c() != ModBlocks.lightRelay) continue;
                    return testPos;
                }
            }
        }
        return this.getBinding();
    }

    @Override
    public boolean canSelect(EntityPlayer player, ItemStack wand, BlockPos pos, EnumFacing side) {
        return true;
    }

    @Override
    public boolean bindTo(EntityPlayer player, ItemStack wand, BlockPos pos, EnumFacing side) {
        if (player.field_70170_p.func_180495_p(pos).func_177230_c() != ModBlocks.lightRelay || pos.func_177951_i((Vec3i)this.func_174877_v()) > 400.0) {
            return false;
        }
        this.bindPos = pos;
        return true;
    }

    @Override
    public void readPacketNBT(NBTTagCompound cmp) {
        this.bindPos = new BlockPos(cmp.func_74762_e(TAG_BIND_X), cmp.func_74762_e(TAG_BIND_Y), cmp.func_74762_e(TAG_BIND_Z));
    }

    @Override
    public void writePacketNBT(NBTTagCompound cmp) {
        cmp.func_74768_a(TAG_BIND_X, this.bindPos.func_177958_n());
        cmp.func_74768_a(TAG_BIND_Y, this.bindPos.func_177956_o());
        cmp.func_74768_a(TAG_BIND_Z, this.bindPos.func_177952_p());
    }

    public static class EntityPlayerMover
    extends Entity {
        private static final String TAG_EXIT_X = "exitX";
        private static final String TAG_EXIT_Y = "exitY";
        private static final String TAG_EXIT_Z = "exitZ";
        private static final DataParameter<BlockPos> EXIT_POS = EntityDataManager.func_187226_a(EntityPlayerMover.class, (DataSerializer)DataSerializers.field_187200_j);

        public EntityPlayerMover(World world) {
            super(world);
        }

        public EntityPlayerMover(World world, BlockPos pos, BlockPos exitPos) {
            this(world);
            this.func_70107_b((double)pos.func_177958_n() + 0.5, (double)pos.func_177956_o() + 0.5, (double)pos.func_177952_p() + 0.5);
            this.setExit(exitPos);
        }

        protected void func_70088_a() {
            this.func_70105_a(0.0f, 0.0f);
            this.field_70145_X = true;
            this.field_70180_af.func_187214_a(EXIT_POS, (Object)BlockPos.field_177992_a);
        }

        public void func_70071_h_() {
            BlockPos exitPos;
            BlockPos pos;
            super.func_70071_h_();
            if (this.func_184188_bt().isEmpty() && !this.field_70170_p.field_72995_K) {
                this.func_70106_y();
                return;
            }
            boolean isItem = this.func_184187_bx() instanceof EntityItem;
            if (!isItem && this.field_70173_aa % 30 == 0) {
                this.func_184185_a(ModSounds.lightRelay, 0.05f, (float)Math.random() * 0.3f + 0.7f);
            }
            if ((pos = new BlockPos((Entity)this)).equals((Object)(exitPos = this.getExitPos()))) {
                TileEntity tile = this.field_70170_p.func_175625_s(pos);
                if (tile != null && tile instanceof TileLightRelay) {
                    Object relay;
                    BlockPos bind;
                    if (this.field_70170_p.func_180495_p(pos).func_177229_b(BotaniaStateProps.LUMINIZER_VARIANT) == LuminizerVariant.DETECTOR) {
                        this.field_70170_p.func_180501_a(pos, this.field_70170_p.func_180495_p(pos).func_177226_a((IProperty)BotaniaStateProps.POWERED, (Comparable)Boolean.valueOf(true)), 3);
                        this.field_70170_p.func_175684_a(pos, tile.func_145838_q(), tile.func_145838_q().func_149738_a(this.field_70170_p));
                    }
                    if ((bind = ((TileLightRelay)(relay = (TileLightRelay)tile)).getNextDestination()) != null && ((TileLightRelay)relay).isValidBinding()) {
                        this.setExit(bind);
                        return;
                    }
                }
                for (Entity e : this.func_184188_bt()) {
                    e.func_184210_p();
                    if (e instanceof EntityPlayerMP) {
                        ((EntityPlayerMP)e).field_71135_a.func_147364_a(this.field_70165_t, this.field_70163_u, this.field_70161_v, e.field_70177_z, e.field_70125_A);
                        continue;
                    }
                    e.func_70107_b(this.field_70165_t, this.field_70163_u, this.field_70161_v);
                }
                this.func_70106_y();
            } else {
                Vector3 thisVec = Vector3.fromEntity(this);
                Vector3 motVec = thisVec.negate().add((double)exitPos.func_177958_n() + 0.5, (double)exitPos.func_177956_o() + 0.5, (double)exitPos.func_177952_p() + 0.5).normalize().multiply(0.5);
                int count = 4;
                for (int i = 0; i < count; ++i) {
                    Color color = Color.getHSBColor((float)this.field_70173_aa / 36.0f + 1.0f / (float)count * (float)i, 1.0f, 1.0f);
                    double rad = Math.PI * 2 / (double)count * (double)i + (double)this.field_70173_aa / Math.PI;
                    double cos = Math.cos(rad);
                    double sin = Math.sin(rad);
                    double s = 0.4;
                    Botania.proxy.sparkleFX(this.field_70165_t + cos * s, this.field_70163_u - 0.5, this.field_70161_v + sin * s, (float)color.getRed() / 255.0f, (float)color.getGreen() / 255.0f, (float)color.getBlue() / 255.0f, 1.2f, 10);
                }
                this.field_70165_t += motVec.x;
                this.field_70163_u += motVec.y;
                this.field_70161_v += motVec.z;
            }
        }

        public boolean shouldRiderSit() {
            return false;
        }

        public boolean func_70097_a(@Nonnull DamageSource source, float damage) {
            return false;
        }

        protected void func_70037_a(@Nonnull NBTTagCompound cmp) {
            this.setExit(new BlockPos(cmp.func_74762_e(TAG_EXIT_X), cmp.func_74762_e(TAG_EXIT_Y), cmp.func_74762_e(TAG_EXIT_Z)));
        }

        protected void func_70014_b(@Nonnull NBTTagCompound cmp) {
            BlockPos exit = this.getExitPos();
            cmp.func_74768_a(TAG_EXIT_X, exit.func_177958_n());
            cmp.func_74768_a(TAG_EXIT_Y, exit.func_177956_o());
            cmp.func_74768_a(TAG_EXIT_Z, exit.func_177952_p());
        }

        public BlockPos getExitPos() {
            return (BlockPos)this.field_70180_af.func_187225_a(EXIT_POS);
        }

        public void setExit(BlockPos pos) {
            this.field_70180_af.func_187227_b(EXIT_POS, (Object)pos);
        }
    }
}

