/*
 * Decompiled with CFR 0.152.
 */
package vazkii.botania.common.block;

import gnu.trove.map.hash.TObjectIntHashMap;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Random;
import java.util.Set;
import java.util.UUID;
import javax.annotation.Nonnull;
import net.minecraft.block.Block;
import net.minecraft.block.BlockPistonExtension;
import net.minecraft.block.BlockPistonMoving;
import net.minecraft.block.SoundType;
import net.minecraft.block.material.EnumPushReaction;
import net.minecraft.block.material.Material;
import net.minecraft.block.properties.IProperty;
import net.minecraft.block.state.IBlockState;
import net.minecraft.entity.Entity;
import net.minecraft.entity.item.EntityItem;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.init.Blocks;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTBase;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.nbt.NBTTagString;
import net.minecraft.server.MinecraftServer;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.EnumFacing;
import net.minecraft.util.SoundCategory;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.IBlockAccess;
import net.minecraft.world.World;
import net.minecraft.world.WorldServer;
import net.minecraft.world.storage.WorldSavedData;
import net.minecraftforge.common.MinecraftForge;
import net.minecraftforge.event.world.WorldEvent;
import net.minecraftforge.fml.common.FMLCommonHandler;
import net.minecraftforge.fml.common.eventhandler.SubscribeEvent;
import net.minecraftforge.fml.common.gameevent.TickEvent;
import vazkii.botania.api.lexicon.ILexiconable;
import vazkii.botania.api.lexicon.LexiconEntry;
import vazkii.botania.api.wand.IWandable;
import vazkii.botania.common.block.BlockMod;
import vazkii.botania.common.block.ModBlocks;
import vazkii.botania.common.core.handler.ModSounds;
import vazkii.botania.common.lexicon.LexiconData;

public class BlockPistonRelay
extends BlockMod
implements IWandable,
ILexiconable {
    public final Map<UUID, DimWithPos> playerPositions = new HashMap<UUID, DimWithPos>();
    public final Map<DimWithPos, DimWithPos> mappedPositions = new HashMap<DimWithPos, DimWithPos>();
    private final Set<DimWithPos> removeQueue = new HashSet<DimWithPos>();
    private final Set<DimWithPos> checkedCoords = new HashSet<DimWithPos>();
    private final TObjectIntHashMap<DimWithPos> coordsToCheck = new TObjectIntHashMap(10, 0.5f, -1);

    public BlockPistonRelay() {
        super(Material.field_151572_C, "pistonRelay");
        this.func_149711_c(2.0f);
        this.func_149752_b(10.0f);
        this.func_149672_a(SoundType.field_185852_e);
        MinecraftForge.EVENT_BUS.register((Object)this);
    }

    public int quantityDropped(IBlockState state, int fortune, @Nonnull Random random) {
        return 0;
    }

    public boolean func_149662_c(IBlockState state) {
        return false;
    }

    public void func_180663_b(@Nonnull World world, @Nonnull BlockPos pos, @Nonnull IBlockState state) {
        if (!world.field_72995_K) {
            this.mapCoords(world.field_73011_w.getDimension(), pos, 2);
        }
    }

    private void mapCoords(int world, BlockPos pos, int time) {
        this.coordsToCheck.put((Object)new DimWithPos(world, pos), time);
    }

    private void decrCoords(DimWithPos key) {
        int time = this.getTimeInCoords(key);
        if (time <= 0) {
            this.removeQueue.add(key);
        } else {
            this.coordsToCheck.adjustValue((Object)key, -1);
        }
    }

    private int getTimeInCoords(DimWithPos key) {
        return this.coordsToCheck.get((Object)key);
    }

    private Block getBlockAt(DimWithPos key) {
        return this.getStateAt(key).func_177230_c();
    }

    private IBlockState getStateAt(DimWithPos key) {
        MinecraftServer server = FMLCommonHandler.instance().getMinecraftServerInstance();
        if (server == null) {
            return Blocks.field_150350_a.func_176223_P();
        }
        return server.func_71218_a(key.dim).func_180495_p(key.blockPos);
    }

    @Override
    public boolean onUsedByWand(EntityPlayer player, ItemStack stack, World world, BlockPos pos, EnumFacing side) {
        if (player == null || world.field_72995_K) {
            return false;
        }
        if (!player.func_70093_af()) {
            this.playerPositions.put(player.func_110124_au(), new DimWithPos(world.field_73011_w.getDimension(), pos));
            world.func_184133_a(null, pos, ModSounds.ding, SoundCategory.BLOCKS, 0.5f, 1.0f);
        } else {
            BlockPistonRelay.func_180635_a((World)world, (BlockPos)pos, (ItemStack)new ItemStack((Block)this));
            world.func_175698_g(pos);
            world.func_175718_b(2001, pos, Block.func_176210_f((IBlockState)this.func_176223_P()));
        }
        return true;
    }

    @SubscribeEvent
    public void onWorldLoad(WorldEvent.Load event) {
        if (!event.getWorld().field_72995_K) {
            WorldData.get(event.getWorld());
        }
    }

    @SubscribeEvent
    public void onWorldUnload(WorldEvent.Unload event) {
        if (!event.getWorld().field_72995_K) {
            WorldData.get(event.getWorld()).func_76185_a();
        }
    }

    @SubscribeEvent
    public void tickEnd(TickEvent event) {
        if (event.type == TickEvent.Type.SERVER && event.phase == TickEvent.Phase.END) {
            for (DimWithPos s : this.coordsToCheck.keySet()) {
                Block block;
                this.decrCoords(s);
                if (this.checkedCoords.contains(s) || (block = this.getBlockAt(s)) != Blocks.field_180384_M) continue;
                IBlockState state = this.getStateAt(s);
                boolean sticky = BlockPistonExtension.EnumPistonType.STICKY == state.func_177229_b((IProperty)BlockPistonMoving.field_176425_b);
                EnumFacing dir = (EnumFacing)state.func_177229_b((IProperty)BlockPistonMoving.field_176426_a);
                MinecraftServer server = FMLCommonHandler.instance().getMinecraftServerInstance();
                if (server == null || this.getTimeInCoords(s) != 0) continue;
                int worldId = s.dim;
                int x = s.blockPos.func_177958_n();
                int y = s.blockPos.func_177956_o();
                int z = s.blockPos.func_177952_p();
                BlockPos pos = s.blockPos;
                WorldServer world = server.func_71218_a(worldId);
                if (world.func_175623_d(pos.func_177972_a(dir))) {
                    world.func_175656_a(pos.func_177972_a(dir), ModBlocks.pistonRelay.func_176223_P());
                } else if (!world.field_72995_K) {
                    ItemStack stack = new ItemStack(ModBlocks.pistonRelay);
                    world.func_72838_d((Entity)new EntityItem((World)world, (double)(x + dir.func_82601_c()), (double)(y + dir.func_96559_d()), (double)(z + dir.func_82599_e()), stack));
                }
                this.checkedCoords.add(s);
                DimWithPos newPos = new DimWithPos(world.field_73011_w.getDimension(), pos.func_177972_a(dir));
                if (!this.mappedPositions.containsKey(s)) continue;
                DimWithPos pos2 = this.mappedPositions.get(s);
                int worldId2 = pos2.dim;
                BlockPos pos22 = pos2.blockPos;
                WorldServer world2 = server.func_71218_a(worldId2);
                IBlockState srcState = world2.func_180495_p(pos22);
                TileEntity tile = world2.func_175625_s(pos22);
                Material mat = srcState.func_185904_a();
                if (!sticky && tile == null && mat.func_186274_m() == EnumPushReaction.NORMAL && srcState.func_185887_b((World)world2, pos22) != -1.0f && !srcState.func_177230_c().isAir(srcState, (IBlockAccess)world2, pos22)) {
                    Material destMat = world2.func_180495_p(pos22.func_177972_a(dir)).func_185904_a();
                    if (world2.func_175623_d(pos22.func_177972_a(dir)) || destMat.func_76222_j()) {
                        world2.func_175656_a(pos22, Blocks.field_150350_a.func_176223_P());
                        world2.func_180501_a(pos22.func_177972_a(dir), srcState, 3);
                        this.mappedPositions.put(s, new DimWithPos(world2.field_73011_w.getDimension(), pos22.func_177972_a(dir)));
                    }
                }
                pos2 = this.mappedPositions.get(s);
                this.mappedPositions.remove(s);
                this.mappedPositions.put(newPos, pos2);
                this.save((World)world2);
            }
        }
        for (DimWithPos s : this.removeQueue) {
            this.coordsToCheck.remove((Object)s);
            this.checkedCoords.remove(s);
        }
        this.removeQueue.clear();
    }

    public void save(World world) {
        WorldData data = WorldData.get(world);
        if (data != null) {
            data.func_76185_a();
        }
    }

    @Override
    public LexiconEntry getEntry(World world, BlockPos pos, EntityPlayer player, ItemStack lexicon) {
        return LexiconData.pistonRelay;
    }

    public static class DimWithPos {
        public final int dim;
        public final BlockPos blockPos;

        public DimWithPos(int dim, BlockPos pos) {
            this.dim = dim;
            this.blockPos = pos;
        }

        public int hashCode() {
            return 31 * this.dim ^ this.blockPos.hashCode();
        }

        public boolean equals(Object o) {
            return o instanceof DimWithPos && this.dim == ((DimWithPos)o).dim && this.blockPos.equals((Object)((DimWithPos)o).blockPos);
        }

        public String toString() {
            return this.dim + ":" + this.blockPos.func_177958_n() + ":" + this.blockPos.func_177956_o() + ":" + this.blockPos.func_177952_p();
        }

        public static DimWithPos fromString(String s) {
            String[] split = s.split(":");
            return new DimWithPos(Integer.parseInt(split[0]), new BlockPos(Integer.parseInt(split[1]), Integer.parseInt(split[2]), Integer.parseInt(split[3])));
        }
    }

    public static class WorldData
    extends WorldSavedData {
        private static final String ID = "PistonRelayPairs";

        public WorldData(String id) {
            super(id);
        }

        public void func_76184_a(@Nonnull NBTTagCompound nbttagcompound) {
            ((BlockPistonRelay)ModBlocks.pistonRelay).mappedPositions.clear();
            Set tags = nbttagcompound.func_150296_c();
            for (String key : tags) {
                NBTBase tag = nbttagcompound.func_74781_a(key);
                if (!(tag instanceof NBTTagString)) continue;
                String value = ((NBTTagString)tag).func_150285_a_();
                ((BlockPistonRelay)ModBlocks.pistonRelay).mappedPositions.put(DimWithPos.fromString(key), DimWithPos.fromString(value));
            }
        }

        @Nonnull
        public NBTTagCompound func_189551_b(@Nonnull NBTTagCompound nbttagcompound) {
            for (DimWithPos s : ((BlockPistonRelay)ModBlocks.pistonRelay).mappedPositions.keySet()) {
                nbttagcompound.func_74778_a(s.toString(), ((BlockPistonRelay)ModBlocks.pistonRelay).mappedPositions.get(s).toString());
            }
            return nbttagcompound;
        }

        public static WorldData get(World world) {
            if (world.func_175693_T() == null) {
                return null;
            }
            WorldData data = (WorldData)world.func_175693_T().func_75742_a(WorldData.class, ID);
            if (data == null) {
                data = new WorldData(ID);
                data.func_76185_a();
                world.func_175693_T().func_75745_a(ID, (WorldSavedData)data);
            }
            return data;
        }
    }
}

