/*
 * Decompiled with CFR 0.152.
 */
package com.sosnitzka.taiga.traits;

import com.sosnitzka.taiga.Keybindings;
import com.sosnitzka.taiga.util.Utils;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.init.Blocks;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.MathHelper;
import net.minecraft.util.text.TextFormatting;
import net.minecraft.world.World;
import net.minecraftforge.common.MinecraftForge;
import net.minecraftforge.common.util.FakePlayer;
import net.minecraftforge.event.entity.player.ItemTooltipEvent;
import net.minecraftforge.event.entity.player.PlayerInteractEvent;
import net.minecraftforge.fml.common.eventhandler.SubscribeEvent;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;
import slimeknights.tconstruct.library.traits.AbstractTrait;
import slimeknights.tconstruct.library.utils.TagUtil;
import slimeknights.tconstruct.library.utils.TinkerUtil;
import slimeknights.tconstruct.library.utils.ToolHelper;

public class TraitWhirl
extends AbstractTrait {
    protected static int TICK_PER_STAT = 36;

    public TraitWhirl() {
        super(TraitWhirl.class.getSimpleName().toLowerCase().substring(5), TextFormatting.DARK_BLUE);
        MinecraftForge.EVENT_BUS.register((Object)this);
    }

    public void onUpdate(ItemStack tool, World world, Entity entity, int itemSlot, boolean isSelected) {
        if (entity instanceof FakePlayer || entity.field_70170_p.field_72995_K || entity.field_70173_aa % TICK_PER_STAT != 0) {
            return;
        }
        NBTTagCompound tag = TagUtil.getExtraTag((ItemStack)tool);
        Utils.GeneralNBTData data = Utils.GeneralNBTData.read(tag);
        data.radius += random.nextFloat() * 0.5f;
        if (data.radius >= 1.0f) {
            TagUtil.setEnchantEffect((ItemStack)tool, (boolean)true);
        }
        data.write(tag);
        TagUtil.setExtraTag((ItemStack)tool, (NBTTagCompound)tag);
    }

    @SubscribeEvent
    public void onRightClickItem(PlayerInteractEvent.RightClickItem event) {
        World w = event.getWorld();
        ItemStack tool = event.getEntityPlayer().func_184614_ca();
        if (!w.field_72995_K && TinkerUtil.hasTrait((NBTTagCompound)TagUtil.getTagSafe((ItemStack)tool), (String)this.identifier) && Keybindings.altKey.func_151470_d()) {
            NBTTagCompound tag = TagUtil.getExtraTag((ItemStack)tool);
            Utils.GeneralNBTData data = Utils.GeneralNBTData.read(tag);
            if ((int)data.radius >= 1) {
                int r = Math.min((int)data.radius, 8);
                for (int x = -r; x <= r; ++x) {
                    for (int y = -r; y <= r; ++y) {
                        for (int z = -r; z <= r; ++z) {
                            if (MathHelper.func_76129_c((float)(x * x + y * y + z * z)) > (float)r) continue;
                            BlockPos nPos = new BlockPos(event.getPos().func_177958_n() + x, event.getPos().func_177956_o() + y, event.getPos().func_177952_p() + z);
                            if (!event.getWorld().func_180495_p(nPos).equals(Blocks.field_150355_j.func_176223_P()) && !event.getWorld().func_180495_p(nPos).equals(Blocks.field_150358_i.func_176223_P())) continue;
                            event.getWorld().func_175655_b(nPos, false);
                        }
                    }
                }
                data.radius -= (float)r;
                data.write(tag);
                TagUtil.setExtraTag((ItemStack)tool, (NBTTagCompound)tag);
                TagUtil.setEnchantEffect((ItemStack)tool, (boolean)false);
                ToolHelper.damageTool((ItemStack)tool, (int)(2 * r), (EntityLivingBase)event.getEntityPlayer());
            }
        }
    }

    @SideOnly(value=Side.CLIENT)
    @SubscribeEvent
    public void onItemTooltip(ItemTooltipEvent e) {
        ItemStack tool = e.getItemStack();
        if (TinkerUtil.hasTrait((NBTTagCompound)TagUtil.getTagSafe((ItemStack)tool), (String)this.identifier)) {
            NBTTagCompound tag = TagUtil.getExtraTag((ItemStack)tool);
            Utils.GeneralNBTData data = Utils.GeneralNBTData.read(tag);
            if (data.radius > 0.0f) {
                e.getToolTip().add(TextFormatting.BLUE + "Actual Radius: " + TextFormatting.WHITE + Math.round(data.radius * 100.0f) / 100);
            }
        }
    }
}

