/*
 * Decompiled with CFR 0.152.
 */
package bq_msi.handlers;

import ivorius.reccomplex.events.StructureGenerationEventLite;
import java.io.BufferedWriter;
import java.io.File;
import java.io.FileWriter;
import java.io.IOException;
import net.minecraft.world.World;
import net.minecraft.world.gen.structure.StructureBoundingBox;
import net.minecraftforge.common.DimensionManager;
import net.minecraftforge.fml.common.eventhandler.EventPriority;
import net.minecraftforge.fml.common.eventhandler.SubscribeEvent;

public class RecurrentHandler {
    @SubscribeEvent(priority=EventPriority.LOW)
    public void onStructureGenerationLitePost(StructureGenerationEventLite.Post event) {
        World world = event.getWorld();
        if (world.field_72995_K) {
            return;
        }
        StructureBoundingBox boundingBox = event.getBoundingBox();
        String structureName = event.getStructureName();
        String regionName = this.convertBoxToRegion(boundingBox);
        int minX = boundingBox.field_78897_a;
        int minZ = boundingBox.field_78896_c;
        int maxX = boundingBox.field_78893_d;
        int maxZ = boundingBox.field_78892_f;
        int dimension = world.field_73011_w.getDimension();
        RecurrentHandler.DataWrite(regionName, dimension, structureName, minX, maxX, minZ, maxZ);
    }

    public String convertBoxToRegion(StructureBoundingBox boundingBox) {
        int regionX = Math.round((boundingBox.field_78897_a + boundingBox.field_78893_d) / 1024);
        int regionZ = Math.round((boundingBox.field_78896_c + boundingBox.field_78892_f) / 1024);
        String regionName = "r." + Integer.toString(regionX) + "." + Integer.toString(regionZ);
        return regionName;
    }

    public static void DataWrite(String regionName, int dimension, String structureName, int minX, int maxX, int minZ, int maxZ) {
        File fileName = new File(DimensionManager.getCurrentSaveRootDirectory() + File.separator + "data" + File.separator + "QuestStructure" + File.separator + dimension + File.separator + regionName + ".txt");
        fileName.getParentFile().mkdirs();
        try {
            FileWriter fileWriter = new FileWriter(fileName, true);
            BufferedWriter bufferedWriter = new BufferedWriter(fileWriter);
            bufferedWriter.write(structureName + "," + minX + "," + maxX + "," + minZ + "," + maxZ);
            bufferedWriter.newLine();
            bufferedWriter.close();
        }
        catch (IOException ex) {
            ex.printStackTrace();
        }
    }
}

