/*
 * Decompiled with CFR 0.152.
 */
package stevekung.mods.moreplanets.planets.fronos.world.gen;

import com.google.common.collect.Lists;
import java.util.List;
import java.util.Map;
import java.util.Random;
import net.minecraft.block.Block;
import net.minecraft.entity.Entity;
import net.minecraft.entity.item.EntityPainting;
import net.minecraft.entity.passive.EntityWolf;
import net.minecraft.init.Blocks;
import net.minecraft.item.EnumDyeColor;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.server.MinecraftServer;
import net.minecraft.util.EnumFacing;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.Rotation;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.Vec3i;
import net.minecraft.world.World;
import net.minecraft.world.gen.structure.StructureBoundingBox;
import net.minecraft.world.gen.structure.StructureComponent;
import net.minecraft.world.gen.structure.template.PlacementSettings;
import net.minecraft.world.gen.structure.template.Template;
import net.minecraft.world.gen.structure.template.TemplateManager;
import stevekung.mods.moreplanets.init.MPBlocks;
import stevekung.mods.moreplanets.utils.LoggerMP;
import stevekung.mods.moreplanets.utils.PaintingMP;

public class RongHouse
extends StructureComponent {
    private static final List<Block> FOLIAGE = Lists.newArrayList((Object[])new Block[]{MPBlocks.NEMOPHILA, MPBlocks.PINK_BLECHNUM, MPBlocks.PURPLE_BUSH, MPBlocks.FRONOS_FERN});
    private static final ResourceLocation RONG_HOUSE = new ResourceLocation("moreplanets:rong_house");
    private int width;
    private int height;
    private int depth;
    private int horizontalPos = -1;

    public RongHouse() {
    }

    public RongHouse(Random rand, int x, int z) {
        super(0);
        int y = 64;
        int sizeX = 8;
        int sizeY = 8;
        int sizeZ = 8;
        this.width = sizeX;
        this.height = sizeY;
        this.depth = sizeZ;
        this.func_186164_a(EnumFacing.Plane.HORIZONTAL.func_179518_a(rand));
        this.field_74887_e = this.func_186165_e().func_176740_k() == EnumFacing.Axis.Z ? new StructureBoundingBox(x, y, z, x + sizeX - 1, y + sizeY - 1, z + sizeZ - 1) : new StructureBoundingBox(x, y, z, x + sizeZ - 1, y + sizeY - 1, z + sizeX - 1);
    }

    protected void func_143012_a(NBTTagCompound tagCompound) {
        tagCompound.func_74768_a("Width", this.width);
        tagCompound.func_74768_a("Height", this.height);
        tagCompound.func_74768_a("Depth", this.depth);
        tagCompound.func_74768_a("HPos", this.horizontalPos);
    }

    protected void func_143011_b(NBTTagCompound tagCompound, TemplateManager manager) {
        this.width = tagCompound.func_74762_e("Width");
        this.height = tagCompound.func_74762_e("Height");
        this.depth = tagCompound.func_74762_e("Depth");
        this.horizontalPos = tagCompound.func_74762_e("HPos");
    }

    public boolean func_74875_a(World world, Random rand, StructureBoundingBox structureBoundingBox) {
        if (!this.offsetToAverageGroundLevel(world, structureBoundingBox, -2)) {
            return false;
        }
        StructureBoundingBox structureboundingbox = this.func_74874_b();
        BlockPos blockpos = new BlockPos(structureboundingbox.field_78897_a, structureboundingbox.field_78895_b, structureboundingbox.field_78896_c);
        Rotation[] arotation = Rotation.values();
        MinecraftServer minecraftserver = world.func_73046_m();
        TemplateManager templatemanager = world.func_72860_G().func_186340_h();
        Rotation rotation = arotation[rand.nextInt(arotation.length)];
        PlacementSettings placementsettings = new PlacementSettings().func_186220_a(rotation).func_186225_a(Blocks.field_189881_dj).func_186223_a(structureboundingbox);
        Template template = templatemanager.func_186237_a(minecraftserver, RONG_HOUSE);
        template.func_186260_a(world, blockpos, placementsettings);
        Map map = template.func_186258_a(blockpos, placementsettings);
        for (Map.Entry entry : map.entrySet()) {
            String dataName = (String)entry.getValue();
            BlockPos blockpos2 = (BlockPos)entry.getKey();
            if ("fronos_foliage".equals(dataName)) {
                world.func_180501_a(blockpos2, FOLIAGE.get(rand.nextInt(FOLIAGE.size())).func_176223_P(), 3);
                continue;
            }
            if ("rong_with_white_carpet".equals(dataName)) {
                EntityWolf rong = new EntityWolf(world);
                rong.func_70903_f(true);
                rong.func_70606_j(20.0f);
                rong.func_96094_a("Rong");
                rong.func_70904_g(true);
                rong.func_175547_a(EnumDyeColor.LIGHT_BLUE);
                rong.func_70012_b((double)blockpos2.func_177958_n() + 0.5, (double)blockpos2.func_177956_o() + 0.25, (double)blockpos2.func_177952_p() + 0.5, 0.0f, 0.0f);
                world.func_72838_d((Entity)rong);
                world.func_180501_a(blockpos2, Blocks.field_150404_cg.func_176223_P(), 3);
                continue;
            }
            if (!"rong_painting".equals(dataName)) continue;
            EntityPainting painting = new EntityPainting(world, blockpos2, this.getPaintingFacing(rotation, blockpos2));
            painting.field_70522_e = PaintingMP.RONG;
            world.func_180501_a(blockpos2, Blocks.field_150350_a.func_176223_P(), 3);
            world.func_72838_d((Entity)painting);
        }
        return true;
    }

    private EnumFacing getPaintingFacing(Rotation rotation, BlockPos pos) {
        EnumFacing facing;
        block39: {
            block41: {
                block42: {
                    block40: {
                        block38: {
                            facing = this.func_186165_e();
                            if (rotation != Rotation.NONE) break block38;
                            if (facing.func_176740_k() == EnumFacing.Axis.X) {
                                switch (facing) {
                                    case EAST: 
                                    case WEST: {
                                        return EnumFacing.EAST;
                                    }
                                    default: {
                                        this.printDebug(rotation, facing, pos);
                                        break;
                                    }
                                    case SOUTH: {
                                        this.printDebug(rotation, facing, pos);
                                        break;
                                    }
                                }
                            } else {
                                switch (facing) {
                                    case EAST: {
                                        this.printDebug(rotation, facing, pos);
                                        break;
                                    }
                                    default: {
                                        return EnumFacing.EAST;
                                    }
                                    case WEST: {
                                        this.printDebug(rotation, facing, pos);
                                        break;
                                    }
                                }
                            }
                            break block39;
                        }
                        if (rotation != Rotation.CLOCKWISE_90) break block40;
                        if (facing.func_176740_k() == EnumFacing.Axis.X) {
                            switch (facing) {
                                case EAST: 
                                case WEST: {
                                    return EnumFacing.SOUTH;
                                }
                                default: {
                                    this.printDebug(rotation, facing, pos);
                                    break;
                                }
                                case SOUTH: {
                                    this.printDebug(rotation, facing, pos);
                                    break;
                                }
                            }
                        } else {
                            switch (facing) {
                                case EAST: {
                                    this.printDebug(rotation, facing, pos);
                                    break;
                                }
                                default: {
                                    return EnumFacing.SOUTH;
                                }
                                case WEST: {
                                    this.printDebug(rotation, facing, pos);
                                    break;
                                }
                            }
                        }
                        break block39;
                    }
                    if (rotation != Rotation.CLOCKWISE_180) break block41;
                    if (facing.func_176740_k() != EnumFacing.Axis.X) break block42;
                    switch (facing) {
                        default: {
                            this.printDebug(rotation, facing, pos);
                            break block39;
                        }
                        case SOUTH: {
                            this.printDebug(rotation, facing, pos);
                            break block39;
                        }
                        case EAST: 
                        case WEST: {
                            return EnumFacing.WEST;
                        }
                    }
                }
                switch (facing) {
                    case EAST: {
                        this.printDebug(rotation, facing, pos);
                        break block39;
                    }
                    default: {
                        return EnumFacing.WEST;
                    }
                }
            }
            if (rotation == Rotation.COUNTERCLOCKWISE_90) {
                if (facing.func_176740_k() == EnumFacing.Axis.X) {
                    switch (facing) {
                        case EAST: 
                        case WEST: {
                            return EnumFacing.NORTH;
                        }
                        default: {
                            this.printDebug(rotation, facing, pos);
                            break;
                        }
                        case SOUTH: {
                            this.printDebug(rotation, facing, pos);
                            break;
                        }
                    }
                } else {
                    switch (facing) {
                        case EAST: {
                            this.printDebug(rotation, facing, pos);
                            break;
                        }
                        default: {
                            return EnumFacing.NORTH;
                        }
                        case WEST: {
                            this.printDebug(rotation, facing, pos);
                        }
                    }
                }
            }
        }
        return facing;
    }

    private void printDebug(Rotation rotation, EnumFacing currentStructureFacing, BlockPos pos) {
        LoggerMP.debug("rot: {}, facing: {}, axis: {}, pos: /tp {} {} {}", rotation, currentStructureFacing, currentStructureFacing.func_176740_k(), pos.func_177958_n(), pos.func_177956_o(), pos.func_177952_p());
    }

    private boolean offsetToAverageGroundLevel(World world, StructureBoundingBox structurebb, int yOffset) {
        if (this.horizontalPos >= 0) {
            return true;
        }
        int i = 0;
        int j = 0;
        BlockPos.MutableBlockPos blockpos$mutableblockpos = new BlockPos.MutableBlockPos();
        for (int k = this.field_74887_e.field_78896_c; k <= this.field_74887_e.field_78892_f; ++k) {
            for (int l = this.field_74887_e.field_78897_a; l <= this.field_74887_e.field_78893_d; ++l) {
                blockpos$mutableblockpos.func_181079_c(l, 64, k);
                if (!structurebb.func_175898_b((Vec3i)blockpos$mutableblockpos)) continue;
                i += Math.max(world.func_175672_r((BlockPos)blockpos$mutableblockpos).func_177956_o(), world.field_73011_w.func_76557_i());
                ++j;
            }
        }
        if (j == 0) {
            return false;
        }
        this.horizontalPos = i / j;
        this.field_74887_e.func_78886_a(0, this.horizontalPos - this.field_74887_e.field_78895_b + yOffset, 0);
        return true;
    }
}

