/*
 * Decompiled with CFR 0.152.
 */
package betterquesting.api2.client.gui.controls.callbacks;

import betterquesting.api.misc.ICallback;
import net.minecraft.nbt.NBTBase;
import net.minecraft.nbt.NBTTagByte;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.nbt.NBTTagDouble;
import net.minecraft.nbt.NBTTagFloat;
import net.minecraft.nbt.NBTTagInt;
import net.minecraft.nbt.NBTTagList;
import net.minecraft.nbt.NBTTagLong;
import net.minecraft.nbt.NBTTagShort;

public class CallbackNBTPrimitive<T extends Number>
implements ICallback<T> {
    private final NBTBase tag;
    private final String sKey;
    private final int iKey;
    private final int tagID;

    public CallbackNBTPrimitive(NBTTagCompound tag, String key, Class<T> c) {
        this.tag = tag;
        this.sKey = key;
        this.iKey = -1;
        this.tagID = this.getTagID(c);
    }

    public CallbackNBTPrimitive(NBTTagList tag, int key, Class<T> c) {
        this.tag = tag;
        this.sKey = null;
        this.iKey = key;
        this.tagID = this.getTagID(c);
    }

    @Override
    public void setValue(T value) {
        if (this.tag.func_74732_a() == 10) {
            this.setCompoundTag((NBTTagCompound)this.tag, value);
        } else {
            this.setListTag((NBTTagList)this.tag, value);
        }
    }

    private void setCompoundTag(NBTTagCompound compound, T value) {
        switch (this.tagID) {
            case 1: {
                compound.func_74774_a(this.sKey, ((Number)value).byteValue());
                break;
            }
            case 2: {
                compound.func_74777_a(this.sKey, ((Number)value).shortValue());
                break;
            }
            case 3: {
                compound.func_74768_a(this.sKey, ((Number)value).intValue());
                break;
            }
            case 4: {
                compound.func_74772_a(this.sKey, ((Number)value).longValue());
                break;
            }
            case 5: {
                compound.func_74776_a(this.sKey, ((Number)value).floatValue());
                break;
            }
            case 6: {
                compound.func_74780_a(this.sKey, ((Number)value).doubleValue());
            }
        }
    }

    private void setListTag(NBTTagList list, T value) {
        switch (this.tagID) {
            case 1: {
                list.func_150304_a(this.iKey, (NBTBase)new NBTTagByte(((Number)value).byteValue()));
                break;
            }
            case 2: {
                list.func_150304_a(this.iKey, (NBTBase)new NBTTagShort(((Number)value).shortValue()));
                break;
            }
            case 3: {
                list.func_150304_a(this.iKey, (NBTBase)new NBTTagInt(((Number)value).intValue()));
                break;
            }
            case 4: {
                list.func_150304_a(this.iKey, (NBTBase)new NBTTagLong(((Number)value).longValue()));
                break;
            }
            case 5: {
                list.func_150304_a(this.iKey, (NBTBase)new NBTTagFloat(((Number)value).floatValue()));
                break;
            }
            case 6: {
                list.func_150304_a(this.iKey, (NBTBase)new NBTTagDouble(((Number)value).doubleValue()));
            }
        }
    }

    private int getTagID(Class<T> c) {
        if (c == Byte.class) {
            return 1;
        }
        if (c == Short.class) {
            return 2;
        }
        if (c == Integer.class) {
            return 3;
        }
        if (c == Long.class) {
            return 4;
        }
        if (c == Float.class) {
            return 5;
        }
        if (c == Double.class) {
            return 6;
        }
        return 0;
    }
}

