/*
 * Decompiled with CFR 0.152.
 */
package gcewing.sg.network;

import gcewing.sg.BaseBlockUtils;
import gcewing.sg.BaseDataChannel;
import gcewing.sg.tileentity.DHDTE;
import gcewing.sg.tileentity.SGBaseTE;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.IBlockAccess;

public class SGChannel
extends BaseDataChannel {
    protected static BaseDataChannel channel;

    public SGChannel(String name) {
        super(name, new Object[0]);
        channel = this;
    }

    public static void sendConnectOrDisconnectToServer(SGBaseTE te, String address) {
        BaseDataChannel.ChannelOutput data = channel.openServer("ConnectOrDisconnect");
        SGChannel.writeCoords(data, te);
        data.writeUTF(address);
        data.close();
    }

    @BaseDataChannel.ServerMessageHandler(value="ConnectOrDisconnect")
    public void handleConnectOrDisconnectFromClient(EntityPlayer player, BaseDataChannel.ChannelInput data) {
        BlockPos pos = this.readCoords(data);
        String address = data.readUTF();
        SGBaseTE te = SGBaseTE.at((IBlockAccess)player.field_70170_p, pos);
        if (te != null) {
            te.connectOrDisconnect(address, player);
        }
    }

    public static void sendClearAddressToServer(DHDTE te) {
        BaseDataChannel.ChannelOutput data = channel.openServer("ClearAddress");
        SGChannel.writeCoords(data, te);
        data.close();
    }

    @BaseDataChannel.ServerMessageHandler(value="ClearAddress")
    public void handleClearAddressFromClient(EntityPlayer player, BaseDataChannel.ChannelInput data) {
        BlockPos pos = this.readCoords(data);
        DHDTE te = DHDTE.at((IBlockAccess)player.field_70170_p, pos);
        if (te != null) {
            te.clearAddress();
        }
    }

    public static void sendUnsetSymbolToServer(DHDTE te) {
        BaseDataChannel.ChannelOutput data = channel.openServer("UnsetSymbol");
        SGChannel.writeCoords(data, te);
        data.close();
    }

    @BaseDataChannel.ServerMessageHandler(value="UnsetSymbol")
    public void handleUnsetSymbolFromClient(EntityPlayer player, BaseDataChannel.ChannelInput data) {
        DHDTE te;
        BlockPos pos = this.readCoords(data);
        if (player.field_70170_p.func_175667_e(pos) && (te = DHDTE.at((IBlockAccess)player.field_70170_p, pos)) != null) {
            te.unsetSymbol(player);
        }
    }

    public static void sendEnterSymbolToServer(DHDTE te, char symbol) {
        BaseDataChannel.ChannelOutput data = channel.openServer("EnterSymbol");
        SGChannel.writeCoords(data, te);
        data.writeChar(symbol);
        data.close();
    }

    @BaseDataChannel.ServerMessageHandler(value="EnterSymbol")
    public void handleEnterSymbolFromClient(EntityPlayer player, BaseDataChannel.ChannelInput data) {
        BlockPos pos = this.readCoords(data);
        char symbol = data.readChar();
        if (player.field_70170_p.func_175667_e(pos)) {
            DHDTE te = DHDTE.at((IBlockAccess)player.field_70170_p, pos);
            if (te != null) {
                te.enterSymbol(player, symbol);
            } else {
                SGBaseTE.sendGenericErrorMsg(player, "Dialling exception.  No DHD detected within range.");
            }
        }
    }

    public static void writeCoords(BaseDataChannel.ChannelOutput data, TileEntity te) {
        BaseBlockUtils.writeBlockPos(data, te.func_174877_v());
    }

    public BlockPos readCoords(BaseDataChannel.ChannelInput data) {
        return BaseBlockUtils.readBlockPos(data);
    }
}

