/*
 * Decompiled with CFR 0.152.
 */
package icbm.classic.content.explosive.blast;

import icbm.classic.ICBMClassic;
import icbm.classic.api.explosion.IMissile;
import icbm.classic.client.ICBMSounds;
import icbm.classic.config.ConfigDebug;
import icbm.classic.content.entity.EntityFlyingBlock;
import icbm.classic.content.explosive.blast.Blast;
import icbm.classic.content.explosive.thread.ThreadLargeExplosion;
import icbm.classic.content.explosive.tile.BlockExplosive;
import icbm.classic.content.explosive.tile.TileEntityExplosive;
import java.util.Iterator;
import java.util.List;
import net.minecraft.block.Block;
import net.minecraft.block.state.IBlockState;
import net.minecraft.entity.Entity;
import net.minecraft.init.Blocks;
import net.minecraft.util.math.AxisAlignedBB;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.Vec3i;
import net.minecraft.world.World;

public class BlastSonic
extends Blast {
    private float energy;
    private boolean hasShockWave = false;

    public BlastSonic(World world, Entity entity, double x, double y, double z, float size) {
        super(world, entity, x, y, z, size);
    }

    public BlastSonic(World world, Entity entity, double x, double y, double z, float size, float energy) {
        this(world, entity, x, y, z, size);
        this.energy = energy;
    }

    public Blast setShockWave() {
        this.hasShockWave = true;
        return this;
    }

    @Override
    public void doPreExplode() {
        if (!this.world().field_72995_K) {
            this.createAndStartThread(new ThreadLargeExplosion(this, (int)this.getBlastRadius(), this.energy, this.field_77283_e));
        }
        if (this.hasShockWave) {
            ICBMSounds.HYPERSONIC.play(this.field_77287_j, this.location.x(), this.location.y(), this.location.z(), 4.0f, (1.0f + (this.world().field_73012_v.nextFloat() - this.world().field_73012_v.nextFloat()) * 0.2f) * 0.7f, true);
        } else {
            ICBMSounds.SONICWAVE.play(this.field_77287_j, this.location.x(), this.location.y(), this.location.z(), 4.0f, (1.0f + (this.world().field_73012_v.nextFloat() - this.world().field_73012_v.nextFloat()) * 0.2f) * 0.7f, true);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void doExplode() {
        List allEntities;
        int r = this.callCount;
        if (this.world() != null && !this.world().field_72995_K) {
            try {
                if (this.isThreadCompleted()) {
                    if (!this.getThreadResults().isEmpty()) {
                        Iterator it = this.getThreadResults().iterator();
                        while (it.hasNext()) {
                            IBlockState blockState;
                            Block block;
                            BlockPos targetPosition = (BlockPos)it.next();
                            double distance = this.location.distance((Vec3i)targetPosition);
                            if (distance > (double)r || distance < (double)(r - 3) || (block = (blockState = this.field_77287_j.func_180495_p(targetPosition)).func_177230_c()) == Blocks.field_150350_a || blockState.func_185887_b(this.field_77287_j, targetPosition) < 0.0f || !(distance < (double)(r - 1)) && this.world().field_73012_v.nextInt(3) <= 0) continue;
                            if (block == ICBMClassic.blockExplosive) {
                                BlockExplosive.triggerExplosive(this.world(), targetPosition, ((TileEntityExplosive)this.world().func_175625_s((BlockPos)targetPosition)).explosive, 1);
                            } else {
                                this.world().func_175698_g(targetPosition);
                            }
                            if ((double)this.world().field_73012_v.nextFloat() < 0.3 * (double)(this.getBlastRadius() - (float)r)) {
                                EntityFlyingBlock entity = new EntityFlyingBlock(this.world(), targetPosition, blockState);
                                this.world().func_72838_d((Entity)entity);
                                entity.yawChange = 50.0f * this.world().field_73012_v.nextFloat();
                                entity.pitchChange = 100.0f * this.world().field_73012_v.nextFloat();
                            }
                            it.remove();
                        }
                    } else {
                        this.isAlive = false;
                        if (ConfigDebug.DEBUG_THREADS) {
                            String msg = String.format("BlastSonic#doPostExplode() -> Thread failed to find blocks to edit. Either thread failed or no valid blocks were found in range.\nWorld = %s \nThread = %s\nSize = %s\nPos = %s", this.field_77287_j, this.getThread(), Float.valueOf(this.field_77280_f), this.location);
                            ICBMClassic.logger().error(msg);
                        }
                    }
                }
            }
            catch (Exception e) {
                String msg = String.format("BlastSonic#doPostExplode() ->  Unexpected error while running post detonation code \nWorld = %s \nThread = %s\nSize = %s\nPos = %s", this.field_77287_j, this.getThread(), Float.valueOf(this.field_77280_f), this.location);
                ICBMClassic.logger().error(msg, (Throwable)e);
            }
        }
        int radius = 2 * this.callCount;
        AxisAlignedBB bounds = new AxisAlignedBB(this.location.x() - (double)radius, this.location.y() - (double)radius, this.location.z() - (double)radius, this.location.x() + (double)radius, this.location.y() + (double)radius, this.location.z() + (double)radius);
        List list = allEntities = this.world().func_72872_a(Entity.class, bounds);
        synchronized (list) {
            for (Entity entity : allEntities) {
                if (entity instanceof IMissile) {
                    ((IMissile)entity).destroyMissile(true);
                    break;
                }
                double xDifference = entity.field_70165_t - this.location.x();
                double zDifference = entity.field_70161_v - this.location.z();
                r = (int)this.getBlastRadius();
                if (xDifference < 0.0) {
                    r = (int)(-this.getBlastRadius());
                }
                entity.field_70159_w += ((double)r - xDifference) * 0.02 * (double)this.world().field_73012_v.nextFloat();
                entity.field_70181_x += (double)(3.0f * this.world().field_73012_v.nextFloat());
                r = (int)this.getBlastRadius();
                if (zDifference < 0.0) {
                    r = (int)(-this.getBlastRadius());
                }
                entity.field_70179_y += ((double)r - zDifference) * 0.02 * (double)this.world().field_73012_v.nextFloat();
            }
        }
        if ((float)this.callCount > this.getBlastRadius()) {
            this.controller.endExplosion();
        }
    }

    @Override
    public int proceduralInterval() {
        return 4;
    }
}

