/*
 * Decompiled with CFR 0.152.
 */
package com.jaquadro.minecraft.storagedrawers.block;

import com.jaquadro.minecraft.storagedrawers.api.storage.INetworked;
import com.jaquadro.minecraft.storagedrawers.core.ModCreativeTabs;
import java.util.ArrayList;
import java.util.List;
import javax.annotation.Nonnull;
import net.minecraft.block.Block;
import net.minecraft.block.BlockPlanks;
import net.minecraft.block.SoundType;
import net.minecraft.block.material.Material;
import net.minecraft.block.properties.IProperty;
import net.minecraft.block.properties.PropertyEnum;
import net.minecraft.block.state.BlockStateContainer;
import net.minecraft.block.state.IBlockState;
import net.minecraft.creativetab.CreativeTabs;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.NonNullList;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.IBlockAccess;
import net.minecraft.world.World;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;

public class BlockTrim
extends Block
implements INetworked {
    public static final PropertyEnum VARIANT = PropertyEnum.func_177709_a((String)"variant", BlockPlanks.EnumType.class);

    public String[] getResourceVariants() {
        String[] variants = new String[BlockPlanks.EnumType.values().length];
        int index = 0;
        for (BlockPlanks.EnumType type : BlockPlanks.EnumType.values()) {
            variants[index++] = '_' + type.func_176610_l();
        }
        return variants;
    }

    public BlockTrim(String registryName, String name) {
        super(Material.field_151575_d);
        this.func_149663_c(name);
        this.setRegistryName(registryName);
        this.func_149647_a(ModCreativeTabs.tabStorageDrawers);
        this.func_149711_c(5.0f);
        this.func_149672_a(SoundType.field_185848_a);
        this.setDefaultState();
    }

    protected void setDefaultState() {
        this.func_180632_j(this.field_176227_L.func_177621_b().func_177226_a((IProperty)VARIANT, (Comparable)BlockPlanks.EnumType.OAK));
    }

    public boolean removedByPlayer(IBlockState state, World world, BlockPos pos, EntityPlayer player, boolean willHarvest) {
        return willHarvest || super.removedByPlayer(state, world, pos, player, true);
    }

    public void func_180657_a(World worldIn, EntityPlayer player, BlockPos pos, IBlockState state, TileEntity te, @Nonnull ItemStack stack) {
        super.func_180657_a(worldIn, player, pos, state, te, stack);
        worldIn.func_175698_g(pos);
    }

    @Nonnull
    protected ItemStack getMainDrop(IBlockAccess world, BlockPos pos, IBlockState state) {
        return new ItemStack(Item.func_150898_a((Block)this), 1, state.func_177230_c().func_176201_c(state));
    }

    public List<ItemStack> getDrops(IBlockAccess world, BlockPos pos, IBlockState state, int fortune) {
        ItemStack dropStack = this.getMainDrop(world, pos, state);
        ArrayList<ItemStack> drops = new ArrayList<ItemStack>();
        drops.add(dropStack);
        return drops;
    }

    @SideOnly(value=Side.CLIENT)
    public void func_149666_a(CreativeTabs creativeTabs, NonNullList<ItemStack> list) {
        for (BlockPlanks.EnumType type : BlockPlanks.EnumType.values()) {
            list.add((Object)new ItemStack((Block)this, 1, type.func_176839_a()));
        }
    }

    public IBlockState func_176203_a(int meta) {
        return this.func_176223_P().func_177226_a((IProperty)VARIANT, (Comparable)BlockPlanks.EnumType.func_176837_a((int)meta));
    }

    public int func_176201_c(IBlockState state) {
        return ((BlockPlanks.EnumType)state.func_177229_b((IProperty)VARIANT)).func_176839_a();
    }

    protected BlockStateContainer func_180661_e() {
        return new BlockStateContainer((Block)this, new IProperty[]{VARIANT});
    }
}

