/*
 * Decompiled with CFR 0.152.
 */
package mcjty.lib.multipart;

import mcjty.lib.multipart.MultipartTE;
import mcjty.lib.multipart.PartPos;
import mcjty.lib.multipart.PartSlot;
import mcjty.lib.setup.ModSetup;
import mcjty.lib.tileentity.GenericTileEntity;
import mcjty.lib.varia.BlockTools;
import net.minecraft.block.Block;
import net.minecraft.block.state.IBlockState;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.entity.player.EntityPlayerMP;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.MathHelper;
import net.minecraft.util.math.RayTraceResult;
import net.minecraft.util.math.Vec3d;
import net.minecraft.world.IBlockAccess;
import net.minecraft.world.World;

public class MultipartHelper {
    public static TileEntity getTileEntity(IBlockAccess access, BlockPos pos, PartSlot slot) {
        MultipartTE.Part part;
        TileEntity te = access.func_175625_s(pos);
        if (te instanceof MultipartTE && (part = ((MultipartTE)te).getParts().get((Object)slot)) != null) {
            return part.getTileEntity();
        }
        return null;
    }

    public static TileEntity getTileEntity(IBlockAccess access, PartPos pos) {
        MultipartTE.Part part;
        TileEntity te = access.func_175625_s(pos.getPos());
        if (te instanceof MultipartTE && (part = ((MultipartTE)te).getParts().get((Object)pos.getSlot())) != null) {
            return part.getTileEntity();
        }
        return null;
    }

    public static IBlockState getBlockState(IBlockAccess access, BlockPos pos, PartSlot slot) {
        MultipartTE.Part part;
        TileEntity te = access.func_175625_s(pos);
        if (te instanceof MultipartTE && (part = ((MultipartTE)te).getParts().get((Object)slot)) != null) {
            return part.getState();
        }
        return null;
    }

    public static boolean removePart(MultipartTE multipartTE, IBlockState state, EntityPlayer player, Vec3d hitVec) {
        BlockPos pos = multipartTE.func_174877_v();
        MultipartTE.Part hitPart = ModSetup.multipartBlock.getHitPart(state, multipartTE.func_145831_w(), pos, MultipartHelper.getPlayerEyes(player), hitVec);
        if (hitPart == null) {
            return false;
        }
        IBlockState hitState = hitPart.getState();
        TileEntity hitTile = hitPart.getTileEntity();
        ItemStack stack = new ItemStack(Item.func_150898_a((Block)hitState.func_177230_c()));
        if (hitTile instanceof GenericTileEntity) {
            NBTTagCompound tagCompound = new NBTTagCompound();
            ((GenericTileEntity)hitTile).writeRestorableToNBT(tagCompound);
            ((GenericTileEntity)hitTile).onBlockBreak(multipartTE.func_145831_w(), multipartTE.func_174877_v(), hitState);
            stack.func_77982_d(tagCompound);
        }
        BlockTools.spawnItemStack(multipartTE.func_145831_w(), pos.func_177958_n(), pos.func_177956_o(), pos.func_177952_p(), stack);
        multipartTE.removePart(hitState);
        return multipartTE.getParts().isEmpty();
    }

    private static RayTraceResult getMovingObjectPositionFromPlayer(World worldIn, EntityPlayer playerIn, boolean useLiquids) {
        float pitch = playerIn.field_70125_A;
        float yaw = playerIn.field_70177_z;
        Vec3d vec3 = MultipartHelper.getPlayerEyes(playerIn);
        float f2 = MathHelper.func_76134_b((float)(-yaw * ((float)Math.PI / 180) - (float)Math.PI));
        float f3 = MathHelper.func_76126_a((float)(-yaw * ((float)Math.PI / 180) - (float)Math.PI));
        float f4 = -MathHelper.func_76134_b((float)(-pitch * ((float)Math.PI / 180)));
        float f5 = MathHelper.func_76126_a((float)(-pitch * ((float)Math.PI / 180)));
        float f6 = f3 * f4;
        float f7 = f2 * f4;
        double reach = 5.0;
        if (playerIn instanceof EntityPlayerMP) {
            reach = ((EntityPlayerMP)playerIn).field_71134_c.getBlockReachDistance();
        }
        Vec3d vec31 = vec3.func_72441_c((double)f6 * reach, (double)f5 * reach, (double)f7 * reach);
        return worldIn.func_147447_a(vec3, vec31, useLiquids, !useLiquids, false);
    }

    public static Vec3d getPlayerEyes(EntityPlayer playerIn) {
        double x = playerIn.field_70165_t;
        double y = playerIn.field_70163_u + (double)playerIn.func_70047_e();
        double z = playerIn.field_70161_v;
        return new Vec3d(x, y, z);
    }
}

