/*
 * Decompiled with CFR 0.152.
 */
package io.github.phantamanta44.libnine.util.render.shader;

import io.github.phantamanta44.libnine.util.math.Vec2i;
import java.nio.FloatBuffer;
import java.util.Objects;
import java.util.function.Supplier;
import javax.annotation.Nullable;
import net.minecraft.client.renderer.Matrix4f;
import net.minecraft.util.math.Vec2f;
import net.minecraft.util.math.Vec3d;
import net.minecraft.util.math.Vec3i;
import org.lwjgl.BufferUtils;
import org.lwjgl.opengl.GL20;
import org.lwjgl.util.vector.Quaternion;

public class UniformType<T, C> {
    public static final UniformType<Float, Void> FLOAT = new UniformType<Float, Void>((l, v, c) -> GL20.glUniform1f((int)l, (float)v.floatValue()));
    public static final UniformType<Vec2f, Void> FLOAT2 = new UniformType<Vec2f, Void>((l, v, c) -> GL20.glUniform2f((int)l, (float)v.field_189982_i, (float)v.field_189983_j));
    public static final UniformType<Vec3d, Void> FLOAT3 = new UniformType<Vec3d, Void>((l, v, c) -> GL20.glUniform3f((int)l, (float)((float)v.field_72450_a), (float)((float)v.field_72448_b), (float)((float)v.field_72449_c)));
    public static final UniformType<Quaternion, Void> FLOAT4 = new UniformType<Quaternion, Void>((l, v, c) -> GL20.glUniform4f((int)l, (float)v.x, (float)v.y, (float)v.z, (float)v.w));
    public static final UniformType<Integer, Void> INT = new UniformType<Integer, Void>((l, v, c) -> GL20.glUniform1i((int)l, (int)v));
    public static final UniformType<Vec2i, Void> INT2 = new UniformType<Vec2i, Void>((l, v, c) -> GL20.glUniform2i((int)l, (int)v.getX(), (int)v.getY()));
    public static final UniformType<Vec3i, Void> INT3 = new UniformType<Vec3i, Void>((l, v, c) -> GL20.glUniform3i((int)l, (int)v.func_177958_n(), (int)v.func_177956_o(), (int)v.func_177952_p()));
    public static final UniformType<Matrix4f, FloatBuffer> MAT4 = new UniformType<Matrix4f, FloatBuffer>((l, v, c) -> {
        Objects.requireNonNull(c);
        c.position(0);
        c.put(v.m00);
        c.put(v.m01);
        c.put(v.m02);
        c.put(v.m03);
        c.put(v.m10);
        c.put(v.m11);
        c.put(v.m12);
        c.put(v.m13);
        c.put(v.m20);
        c.put(v.m21);
        c.put(v.m22);
        c.put(v.m23);
        c.put(v.m30);
        c.put(v.m31);
        c.put(v.m32);
        c.put(v.m33);
        GL20.glUniformMatrix4((int)l, (boolean)true, (FloatBuffer)c);
    }, () -> BufferUtils.createFloatBuffer((int)16));
    private final UniformWriter<T, C> writer;
    @Nullable
    private final Supplier<C> contextFactory;

    public UniformType(UniformWriter<T, C> writer, @Nullable Supplier<C> contextFactory) {
        this.writer = writer;
        this.contextFactory = contextFactory;
    }

    public UniformType(UniformWriter<T, C> writer) {
        this(writer, null);
    }

    @Nullable
    public C generateContext() {
        return this.contextFactory != null ? (C)this.contextFactory.get() : null;
    }

    public void set(int location, T value, @Nullable C context) {
        this.writer.write(location, value, context);
    }

    @FunctionalInterface
    public static interface UniformWriter<T, C> {
        public void write(int var1, T var2, @Nullable C var3);
    }
}

