/*
 * Decompiled with CFR 0.152.
 */
package io.github.phantamanta44.libnine.block;

import io.github.phantamanta44.libnine.LibNine;
import io.github.phantamanta44.libnine.item.L9ItemBlock;
import java.util.function.BiFunction;
import javax.annotation.Nullable;
import net.minecraft.block.Block;
import net.minecraft.block.ITileEntityProvider;
import net.minecraft.block.material.Material;
import net.minecraft.block.state.IBlockState;
import net.minecraft.item.Item;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.IBlockAccess;
import net.minecraft.world.World;

public class L9Block
extends Block
implements ITileEntityProvider {
    private final String internalName;
    private final L9ItemBlock itemBlock;
    @Nullable
    private BiFunction<World, Integer, ? extends TileEntity> tileFactory;

    public L9Block(String name, Material material) {
        super(material);
        this.internalName = name;
        this.initName();
        this.itemBlock = this.initItemBlock();
        this.initRegistration();
    }

    public void postInit() {
        this.initModel();
        this.initCreativeTab();
    }

    protected void initName() {
        this.func_149663_c(LibNine.PROXY.getRegistrar().getBound().prefix(this.getInternalName()));
    }

    protected L9ItemBlock initItemBlock() {
        return new L9ItemBlock(this);
    }

    protected void initRegistration() {
        ResourceLocation registryName = LibNine.PROXY.getRegistrar().getBound().newResourceLocation(this.getInternalName());
        this.setRegistryName(registryName);
        this.getItemBlock().setRegistryName(registryName);
        LibNine.PROXY.getRegistrar().queueBlockReg(this);
        LibNine.PROXY.getRegistrar().queueItemReg((Item)this.getItemBlock());
    }

    protected void initModel() {
        LibNine.PROXY.getRegistrar().queueItemBlockModelReg(this, this.getInternalName());
    }

    protected void initCreativeTab() {
        LibNine.PROXY.getRegistrar().getBound().setCreativeTabFor(this);
    }

    protected void setTileFactory(BiFunction<World, Integer, ? extends TileEntity> tileFactory) {
        this.tileFactory = tileFactory;
    }

    public L9ItemBlock getItemBlock() {
        return this.itemBlock;
    }

    public String getInternalName() {
        return this.internalName;
    }

    public boolean hasTileEntity(IBlockState state) {
        return this.tileFactory != null;
    }

    @Nullable
    public TileEntity createTileEntity(World world, IBlockState state) {
        return this.func_149915_a(world, this.func_176201_c(state));
    }

    @Nullable
    public TileEntity func_149915_a(World world, int meta) {
        return this.tileFactory != null ? this.tileFactory.apply(world, meta) : null;
    }

    @Nullable
    public <T extends TileEntity> T getTileEntity(IBlockAccess world, BlockPos pos) {
        return (T)world.func_175625_s(pos);
    }
}

