/*
 * Decompiled with CFR 0.152.
 */
package net.malisis.advert.gui.advertselection;

import com.google.common.base.Predicates;
import com.google.common.eventbus.Subscribe;
import java.util.Arrays;
import net.malisis.advert.advert.AdvertSelection;
import net.malisis.advert.gui.AdvertView;
import net.malisis.advert.gui.advertselection.AdvertSelectionComponent;
import net.malisis.advert.model.AdvertModel;
import net.malisis.advert.model.ModelVariantContainer;
import net.malisis.advert.network.AdvertSelectionMessage;
import net.malisis.advert.tileentity.AdvertTileEntity;
import net.malisis.core.client.gui.Anchor;
import net.malisis.core.client.gui.MalisisGui;
import net.malisis.core.client.gui.component.UIComponent;
import net.malisis.core.client.gui.component.container.UIContainer;
import net.malisis.core.client.gui.component.container.UIPanel;
import net.malisis.core.client.gui.component.container.UIWindow;
import net.malisis.core.client.gui.component.decoration.UILabel;
import net.malisis.core.client.gui.component.decoration.UISeparator;
import net.malisis.core.client.gui.component.interaction.UIButton;
import net.malisis.core.client.gui.component.interaction.UISelect;
import net.malisis.core.util.TileEntityUtils;
import net.minecraft.tileentity.TileEntity;

public class AdvertSelectionGui
extends MalisisGui {
    private AdvertTileEntity tileEntity;
    UISelect<AdvertModel<?>> selModel;
    private UIButton btnSave;
    private UIButton btnClose;
    private UIContainer<?> modelCont;
    private UIContainer<?> ascCont;
    private UISeparator separator;
    private AdvertSelectionComponent[] ascs = new AdvertSelectionComponent[0];
    private AdvertView adview;
    private int variantHeight;

    public AdvertSelectionGui(AdvertTileEntity tileEntity) {
        this.tileEntity = tileEntity;
    }

    public void construct() {
        int width = 400;
        int height = 300;
        int y = 0;
        UILabel labelModel = new UILabel((MalisisGui)this, "malisisadvert.gui.model");
        this.selModel = (UISelect)new UISelect((MalisisGui)this, 150, AdvertModel.list()).setPosition(0, y += 12);
        if (this.tileEntity.isWallMounted()) {
            this.selModel.setDisablePredicate(Predicates.not(AdvertModel::canBeWallMounted));
        }
        this.selModel.setLabelPattern("malisisadvert.gui.model.%s");
        this.selModel.register((Object)this);
        this.modelCont = new UIContainer((MalisisGui)this);
        ((UIContainer)this.modelCont.setPosition(5, y += 18)).setSize(1, 1);
        this.separator = ((UISeparator)new UISeparator((MalisisGui)this).setPosition(0, y += 2)).setColor(0x999999);
        this.ascCont = (UIContainer)new UIContainer((MalisisGui)this).setPosition(0, y += 5);
        this.ascCont.setPadding(1, 1);
        UIContainer left = (UIContainer)new UIContainer((MalisisGui)this, width / 2 - 15, height - 55).setPosition(5, 15);
        left.add(new UIComponent[]{labelModel});
        left.add(new UIComponent[]{this.selModel});
        left.add(new UIComponent[]{this.modelCont});
        left.add(new UIComponent[]{this.separator});
        left.add(new UIComponent[]{this.ascCont});
        this.adview = (AdvertView)new AdvertView(this, true).register((Object)this);
        UIPanel right = (UIPanel)new UIPanel((MalisisGui)this, width / 2 - 15, height - 55).setPosition(-5, 15, Anchor.RIGHT);
        right.add(new UIComponent[]{this.adview});
        this.btnSave = (UIButton)((UIButton)new UIButton((MalisisGui)this, "malisisadvert.gui.save").setPosition(-32, 0, Anchor.BOTTOM | Anchor.CENTER)).setSize(60).register((Object)this);
        this.btnClose = (UIButton)((UIButton)new UIButton((MalisisGui)this, "malisisadvert.gui.close").setPosition(32, 0, Anchor.BOTTOM | Anchor.CENTER)).setSize(60).register((Object)this);
        UIWindow window = new UIWindow((MalisisGui)this, "malisisadvert.gui.advertselection", width, height);
        window.add(new UIComponent[]{left, right, this.btnSave, this.btnClose});
        this.addToScreen((UIComponent)window);
        TileEntityUtils.linkTileEntityToGui((TileEntity)this.tileEntity, (MalisisGui)this);
    }

    public AdvertModel<?> getModel() {
        return (AdvertModel)this.selModel.getSelectedValue();
    }

    public void setModel(AdvertModel<?> model) {
        this.modelCont.removeAll();
        ModelVariantContainer<Object> container = this.tileEntity.getModelContainer();
        if (container.getModel() != model) {
            container = new ModelVariantContainer<Object>(model, null, this.tileEntity.isWallMounted());
        }
        this.variantHeight = container.getGuiComponent(this, this.modelCont);
        this.modelCont.setSize(0, this.variantHeight);
        this.separator.setPosition(0, 30 + this.variantHeight);
        this.ascCont.setPosition(0, 35 + this.variantHeight);
        this.setAscs(model);
    }

    public void setAscs(AdvertModel<?> model) {
        int count = this.ascs.length;
        int y = 60 * count;
        this.ascs = Arrays.copyOf(this.ascs, model.getAvailableSlots());
        for (int i = count; i < model.getAvailableSlots(); ++i) {
            this.ascs[i] = (AdvertSelectionComponent)new AdvertSelectionComponent(this, i, this.adview).setPosition(0, y);
            y += this.ascs[i].getHeight();
        }
        this.ascCont.removeAll();
        this.ascCont.add((UIComponent[])this.ascs);
    }

    public void updateGui() {
        ModelVariantContainer<?> container = this.tileEntity.getModelContainer();
        if (this.selModel.getSelectedValue() != container.getModel()) {
            this.selModel.setSelectedOption(container.getModel());
            this.setModel(container.getModel());
        }
        AdvertSelection[] selections = this.tileEntity.getSelections();
        for (int i = 0; i < selections.length; ++i) {
            this.ascs[i].setAdvertSelection(selections[i]);
        }
    }

    @Subscribe
    public void onModelSelect(UISelect.SelectEvent<AdvertModel<?>> event) {
        this.setModel((AdvertModel)event.getNewValue());
    }

    @Subscribe
    public void onButtonClick(UIButton.ClickEvent event) {
        if (event.getComponent() == this.btnClose) {
            this.close();
        }
        if (event.getComponent() == this.btnSave) {
            ModelVariantContainer container = ModelVariantContainer.fromGui(this.selModel, this.modelCont, this.tileEntity.isWallMounted());
            AdvertSelection[] selections = new AdvertSelection[container.getModel().getAvailableSlots()];
            for (int i = 0; i < this.ascs.length; ++i) {
                selections[i] = this.ascs[i].getAdvertSelection();
            }
            AdvertSelectionMessage.saveSelection(this.tileEntity, container, selections);
            this.close();
        }
    }
}

