/*
 * Decompiled with CFR 0.152.
 */
package net.malisis.advert.gui;

import java.util.List;
import net.malisis.advert.advert.AdvertSelection;
import net.malisis.advert.advert.ClientAdvert;
import net.malisis.advert.gui.advertselection.AdvertSelectionComponent;
import net.malisis.advert.gui.advertselection.AdvertSelectionGui;
import net.malisis.advert.model.AdvertModel;
import net.malisis.core.client.gui.GuiRenderer;
import net.malisis.core.client.gui.GuiTexture;
import net.malisis.core.client.gui.MalisisGui;
import net.malisis.core.client.gui.component.UIComponent;
import net.malisis.core.renderer.font.FontOptions;
import net.malisis.core.renderer.font.MalisisFont;
import net.malisis.core.util.MouseButton;
import net.minecraft.client.gui.GuiScreen;
import org.apache.commons.lang3.StringUtils;
import org.lwjgl.opengl.GL11;

public class AdvertView
extends UIComponent<AdvertView> {
    private MalisisFont font = MalisisFont.minecraftFont;
    private FontOptions fontOptions = FontOptions.builder().color(0xFFFFFF).shadow().build();
    private boolean editable = false;
    private AdvertSelectionComponent asc;
    private AdvertSelection advertSelection;
    private int sX;
    private int sY;
    private int eX;
    private int eY;
    private ClientAdvert advert;
    private boolean move = false;

    public AdvertView(MalisisGui gui, boolean editable) {
        super(gui);
        this.editable = editable;
        this.resetUVs();
    }

    public void setAdvert(ClientAdvert advert) {
        this.advert = advert;
    }

    public void setAdvertSelection(AdvertSelectionComponent asc, AdvertSelection advertSelection) {
        this.asc = asc;
        this.advertSelection = advertSelection;
        if (advertSelection != null) {
            this.advert = advertSelection.getAdvert();
            this.sX = advertSelection.getX(advertSelection.u);
            this.sY = advertSelection.getY(advertSelection.v);
            this.eX = advertSelection.getX(advertSelection.U);
            this.eY = advertSelection.getY(advertSelection.V);
        } else {
            this.advert = null;
        }
    }

    public float getFactor() {
        if (this.advert == null || this.advert.getTexture() == null) {
            return 1.0f;
        }
        return Math.min((float)this.getWidth() / (float)this.advert.getTexture().getWidth(), (float)this.getHeight() / (float)this.advert.getTexture().getHeight());
    }

    public int factorX(int x) {
        int f = Math.round((float)this.relativeX(x - 1) / this.getFactor());
        return Math.min(Math.max(0, f), this.advert.getTexture().getWidth());
    }

    public int factorY(int y) {
        int f = Math.round((float)this.relativeY(y - 1) / this.getFactor());
        return Math.min(Math.max(0, f), this.advert.getTexture().getHeight());
    }

    private boolean isTexture() {
        return this.advert != null && this.advert.getTexture() != null;
    }

    private void resetUVs() {
        if (!this.isTexture()) {
            return;
        }
        this.sY = 0;
        this.sX = 0;
        this.eX = this.advert.getTexture().getWidth();
        this.eY = this.advert.getTexture().getHeight();
        if (this.advertSelection == null) {
            return;
        }
        this.advertSelection.setPixels(this.sX, this.sY, this.eX, this.eY);
        this.asc.updateComponents();
    }

    private void applyUVs() {
        if (this.advertSelection == null) {
            return;
        }
        this.advertSelection.setPixels(this.sX, this.sY, this.eX, this.eY);
        this.asc.updateComponents();
    }

    private void forceRatio() {
        AdvertModel<?> model = ((AdvertSelectionGui)this.getGui()).getModel();
        float mratio = model.getWidth() / model.getHeight();
        int dy = (int)((float)Math.abs(this.eX - this.sX) / mratio);
        this.eY = this.sY < this.eY ? this.sY + dy : this.sY - dy;
        if (this.eY < 0 || this.eY > this.advert.getTexture().getHeight()) {
            this.eY = this.eY < 0 ? 0 : this.advert.getTexture().getHeight();
            int dx = (int)((float)Math.abs(this.eY - this.sY) * mratio);
            this.eX = this.sX < this.eX ? this.sX + dx : this.sX - dx;
        }
    }

    public boolean onRightClick(int x, int y) {
        if (!this.editable) {
            return super.onRightClick(x, y);
        }
        this.resetUVs();
        return true;
    }

    public boolean onButtonPress(int x, int y, MouseButton button) {
        if (this.editable && button == MouseButton.LEFT && this.isTexture()) {
            if (GuiScreen.func_146271_m()) {
                this.move = true;
            } else {
                this.move = false;
                this.sX = this.eX = this.factorX(x);
                this.sY = this.eY = this.factorY(y);
            }
        }
        return super.onButtonPress(x, y, button);
    }

    public boolean onButtonRelease(int x, int y, MouseButton button) {
        this.move = false;
        return super.onButtonRelease(x, y, button);
    }

    public boolean onDrag(int lastX, int lastY, int x, int y, MouseButton button) {
        if (!this.editable || button != MouseButton.LEFT || !this.isTexture()) {
            return super.onDrag(lastX, lastY, x, y, button);
        }
        if (this.move) {
            float f = this.getFactor();
            int maxX = this.advert.getTexture().getWidth();
            int maxY = this.advert.getTexture().getHeight();
            int dx = Math.round((float)(x - lastX) / f);
            int dy = Math.round((float)(y - lastY) / f);
            if (Math.min(this.sX, this.eX) > 0 && dx < 0 || Math.max(this.sX, this.eX) < maxX && dx > 0) {
                this.sX += dx;
                this.eX += dx;
            }
            if (Math.min(this.sY, this.eY) > 0 && dy < 0 || Math.max(this.eY, this.sY) < maxY && dy > 0) {
                this.sY += dy;
                this.eY += dy;
            }
            this.applyUVs();
            return true;
        }
        this.eX = this.factorX(x);
        this.eY = this.factorY(y);
        if (GuiScreen.func_146272_n()) {
            this.forceRatio();
        }
        this.applyUVs();
        return true;
    }

    public void drawBackground(GuiRenderer renderer, int mouseX, int mouseY, float partialTick) {
    }

    public void drawForeground(GuiRenderer renderer, int mouseX, int mouseY, float partialTick) {
        if (this.advert == null || StringUtils.isEmpty((CharSequence)this.advert.getUrl())) {
            return;
        }
        GuiTexture texture = this.advert.getTexture();
        if (texture == null) {
            String text = this.advert.getError();
            if (text != null) {
                int y = 0;
                List err = this.font.wrapText(text, this.getWidth(), this.fontOptions);
                for (String e : err) {
                    renderer.drawText(null, e, 0.0f, (float)(11 * y++), 0.0f, this.fontOptions);
                }
            } else {
                renderer.drawText("Downloading...");
            }
            return;
        }
        this.shape.resetState();
        this.shape.setSize((int)((float)texture.getWidth() * this.getFactor()), (int)((float)texture.getHeight() * this.getFactor()));
        renderer.bindTexture(texture);
        renderer.drawShape(this.shape, this.rp);
        if (this.editable) {
            renderer.next(2);
            renderer.disableTextures();
            GL11.glLineWidth((float)1.0f);
            float u = this.advertSelection.U - this.advertSelection.u;
            float v = this.advertSelection.V - this.advertSelection.v;
            float w = (float)texture.getWidth() * this.getFactor();
            float h = (float)texture.getHeight() * this.getFactor();
            this.shape.resetState();
            this.shape.setSize((int)(u * w), (int)(v * h));
            this.shape.translate(Math.round(this.advertSelection.u * w), Math.round(this.advertSelection.v * h));
            this.rp.colorMultiplier.set((Object)0xFF0000);
            renderer.drawShape(this.shape, this.rp);
            renderer.next(7);
            renderer.enableTextures();
        }
    }
}

