/*
 * Decompiled with CFR 0.152.
 */
package ic2.core.platform.textures.models;

import com.google.common.collect.ImmutableMap;
import ic2.core.platform.textures.models.BaseModel;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.Optional;
import javax.annotation.Nullable;
import javax.vecmath.Matrix4f;
import net.minecraft.block.state.IBlockState;
import net.minecraft.client.renderer.block.model.BakedQuad;
import net.minecraft.client.renderer.block.model.IBakedModel;
import net.minecraft.client.renderer.block.model.ItemCameraTransforms;
import net.minecraft.client.renderer.texture.TextureAtlasSprite;
import net.minecraft.client.renderer.vertex.DefaultVertexFormats;
import net.minecraft.client.renderer.vertex.VertexFormat;
import net.minecraft.util.EnumFacing;
import net.minecraftforge.client.model.ItemLayerModel;
import net.minecraftforge.client.model.PerspectiveMapWrapper;
import net.minecraftforge.common.model.TRSRTransformation;
import org.apache.commons.lang3.tuple.Pair;

public class BasicItemModel
extends BaseModel {
    ImmutableMap<ItemCameraTransforms.TransformType, TRSRTransformation> map;
    List<BakedQuad> quads = new ArrayList<BakedQuad>();
    BasicItemModel other;
    boolean gui;
    boolean color;

    public BasicItemModel(ImmutableMap<ItemCameraTransforms.TransformType, TRSRTransformation> stuff, TextureAtlasSprite sprite, boolean colorEffected) {
        super(stuff);
        this.setParticalTexture(sprite);
        this.color = colorEffected;
        this.map = stuff;
    }

    @Override
    public void init() {
        this.gui = false;
        this.other = new BasicItemModel(this.map, this.func_177554_e(), this.color);
        this.other.gui = true;
        this.other.other = this;
        this.quads.addAll((Collection<BakedQuad>)ItemLayerModel.getQuadsForSprite((int)(this.color ? 0 : -1), (TextureAtlasSprite)this.func_177554_e(), (VertexFormat)DefaultVertexFormats.field_176599_b, Optional.of(this.getCamera().get((Object)ItemCameraTransforms.TransformType.GUI))));
        for (BakedQuad quad : this.quads) {
            if (quad.func_178210_d() != EnumFacing.SOUTH) continue;
            this.other.quads.add(quad);
        }
    }

    public List<BakedQuad> func_188616_a(@Nullable IBlockState state, @Nullable EnumFacing side, long rand) {
        if (side == null) {
            return this.quads;
        }
        return this.getEmptyList();
    }

    public boolean func_177555_b() {
        return true;
    }

    public boolean func_177556_c() {
        return false;
    }

    public boolean func_188618_c() {
        return false;
    }

    public Pair<? extends IBakedModel, Matrix4f> handlePerspective(ItemCameraTransforms.TransformType type) {
        Pair pair = PerspectiveMapWrapper.handlePerspective((IBakedModel)this, this.getCamera(), (ItemCameraTransforms.TransformType)type);
        if (type == ItemCameraTransforms.TransformType.GUI && !this.gui) {
            return Pair.of((Object)((Object)this.other), null);
        }
        if (type != ItemCameraTransforms.TransformType.GUI && this.gui) {
            return Pair.of((Object)((Object)this.other), (Object)pair.getRight());
        }
        return pair;
    }
}

