/*
 * Decompiled with CFR 0.152.
 */
package ic2.core.network.packets.server;

import ic2.api.classic.audio.AudioPosition;
import ic2.api.classic.audio.PositionSpec;
import ic2.core.IC2;
import ic2.core.network.packets.IC2Packet;
import ic2.core.platform.registry.Ic2Sounds;
import io.netty.buffer.ByteBuf;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.init.SoundEvents;
import net.minecraft.util.EnumParticleTypes;
import net.minecraft.util.SoundCategory;
import net.minecraft.world.World;

public class ExplosionPacket
extends IC2Packet {
    int dimID;
    double x;
    double y;
    double z;
    boolean nuke;

    public ExplosionPacket() {
    }

    public ExplosionPacket(World par1, double par2, double par3, double par4, boolean par5) {
        this.dimID = par1.field_73011_w.getDimension();
        this.x = par2;
        this.y = par3;
        this.z = par4;
        this.nuke = par5;
    }

    @Override
    public void read(ByteBuf par1) {
        this.dimID = par1.readInt();
        this.x = par1.readDouble();
        this.y = par1.readDouble();
        this.z = par1.readDouble();
        this.nuke = par1.readBoolean();
    }

    @Override
    public void write(ByteBuf par1) {
        par1.writeInt(this.dimID);
        par1.writeDouble(this.x);
        par1.writeDouble(this.y);
        par1.writeDouble(this.z);
        par1.writeBoolean(this.nuke);
    }

    @Override
    public void handlePacket(EntityPlayer par1) {
        World world = IC2.platform.getWorld(this.dimID);
        if (world == null) {
            throw new RuntimeException("Packet Got Incorrect Data");
        }
        if (this.nuke) {
            IC2.audioManager.playOnce(new AudioPosition(world, (float)this.x, (float)this.y, (float)this.z), PositionSpec.Center, Ic2Sounds.nukeExplosion, false, 4.0f);
        } else {
            world.func_184148_a(null, this.x, this.y, this.z, SoundEvents.field_187539_bB, SoundCategory.BLOCKS, 4.0f, (1.0f + (world.field_73012_v.nextFloat() - world.field_73012_v.nextFloat()) * 0.2f) * 0.7f);
        }
        world.func_175688_a(EnumParticleTypes.EXPLOSION_LARGE, this.x, this.y, this.z, 1.0, 0.0, 0.0, new int[0]);
    }
}

