/*
 * Decompiled with CFR 0.152.
 */
package ic2.core.item.tool.electric.scanners;

import ic2.core.IC2;
import ic2.core.inventory.base.IHandHeldInventory;
import ic2.core.inventory.base.IHasGui;
import ic2.core.item.inv.inventories.ScannerInv;
import ic2.core.item.tool.electric.scanners.IScanner;
import ic2.core.platform.lang.components.base.LocaleComp;
import ic2.core.platform.lang.storage.Ic2ItemLang;
import ic2.core.util.misc.StackUtil;
import ic2.core.util.obj.ToolTipType;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import net.minecraft.block.Block;
import net.minecraft.block.state.IBlockState;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.nbt.NBTTagList;
import net.minecraft.util.EnumHand;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.World;
import net.minecraftforge.fluids.Fluid;
import net.minecraftforge.fluids.FluidStack;

public class FilteredScanner
implements IScanner,
IHandHeldInventory {
    @Override
    public boolean isAdv(ItemStack stack) {
        return false;
    }

    @Override
    public int getOreValue(ItemStack stack, IBlockState state) {
        return this.getValidBlocks(stack).contains(state) ? 1 : 0;
    }

    @Override
    public int getOreValue(ItemStack stack, IBlockState state, World world, BlockPos pos) {
        return this.getOreValue(stack, state);
    }

    @Override
    public Set<IBlockState> getTargets(ItemStack stack) {
        return this.getValidBlocks(stack);
    }

    @Override
    public int getRadius(ItemStack stack) {
        return 7;
    }

    @Override
    public int getCost(ItemStack stack) {
        return 200;
    }

    @Override
    public boolean isValue(ItemStack stack) {
        return false;
    }

    @Override
    public int getTier(ItemStack stack) {
        return 2;
    }

    @Override
    public boolean isFluidScanner(ItemStack stack) {
        return false;
    }

    @Override
    public boolean isFluidValid(ItemStack stack, FluidStack fluid) {
        return false;
    }

    @Override
    public Set<Fluid> getFluidTargets(ItemStack stack) {
        return EMPTY_FLUIDS;
    }

    @Override
    public LocaleComp getName(ItemStack stack) {
        return Ic2ItemLang.scannerFiltered;
    }

    @Override
    public boolean hasCustomInfo(ItemStack stack) {
        return false;
    }

    @Override
    public boolean addCustomInfo(ItemStack stack, EntityPlayer player, List<String> pre, List<String> post, Map<ToolTipType, List<String>> sortedTooltip) {
        return false;
    }

    @Override
    public boolean showTargets(ItemStack stack) {
        return true;
    }

    @Override
    public boolean hasRightClick(ItemStack stack) {
        return true;
    }

    @Override
    public boolean onRightClick(ItemStack stack, EntityPlayer player, EnumHand hand, World world) {
        if (IC2.keyboard.isSideinventoryKeyDown(player)) {
            IC2.platform.launchGui(player, this.getInventory(player, hand, stack), hand);
            return true;
        }
        return false;
    }

    @Override
    public boolean hasAOE(ItemStack stack) {
        return true;
    }

    @Override
    public IHasGui getInventory(EntityPlayer player, EnumHand hand, ItemStack stack) {
        return new ScannerInv(player, this, stack);
    }

    @Override
    public int getGuiId(ItemStack stack) {
        NBTTagCompound nbt = StackUtil.getNbtData(stack);
        if (nbt.func_74764_b("GuiID")) {
            return nbt.func_74762_e("GuiID");
        }
        return -1;
    }

    @Override
    public void setGuiID(ItemStack stack, int id) {
        if (id == -1) {
            StackUtil.getOrCreateNbtData(stack).func_82580_o("GuiID");
            return;
        }
        StackUtil.getOrCreateNbtData(stack).func_74768_a("GuiID", id);
    }

    public Set<IBlockState> getValidBlocks(ItemStack stack) {
        LinkedHashSet<IBlockState> states = new LinkedHashSet<IBlockState>();
        NBTTagList list = StackUtil.getNbtData(stack).func_150295_c("Items", 10);
        for (int i = 0; i < list.func_74745_c(); ++i) {
            Block block;
            ItemStack item = new ItemStack(list.func_150305_b(i));
            if (item.func_190926_b() || (block = Block.func_149634_a((Item)item.func_77973_b())) == null) continue;
            try {
                states.add(block.func_176203_a(item.func_77973_b().func_77647_b(item.func_77960_j())));
                continue;
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
        return states;
    }
}

