/*
 * Decompiled with CFR 0.152.
 */
package ic2.core.block.machine.low.logic.crops;

import ic2.api.classic.crops.ClassicCrops;
import ic2.api.classic.network.INetworkFieldData;
import ic2.api.classic.network.adv.IInputBuffer;
import ic2.api.classic.network.adv.IOutputBuffer;
import ic2.api.classic.network.adv.NetworkField;
import ic2.api.crops.CropCard;
import ic2.core.item.crop.ItemCropSeed;
import ic2.core.platform.lang.storage.Ic2GuiLang;
import java.util.ArrayList;
import java.util.LinkedList;
import java.util.List;
import net.minecraft.init.Items;
import net.minecraft.item.ItemStack;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.Tuple;

public class CropTypeSyncer
implements INetworkFieldData {
    List<Tuple<ItemStack, CropCard>> storedCrops = new ArrayList<Tuple<ItemStack, CropCard>>();

    public void addCrops(LinkedList<CropCard> cards) {
        this.storedCrops.clear();
        while (cards.size() > 0) {
            ItemStack stack;
            CropCard card = cards.poll();
            if (card == null) {
                stack = new ItemStack(Items.field_151122_aG);
                stack.func_151001_c(Ic2GuiLang.catAll.getLocalized());
                this.storedCrops.add((Tuple<ItemStack, CropCard>)new Tuple((Object)stack, (Object)card));
                continue;
            }
            stack = ItemCropSeed.generateItemStack(card, 0, 0, 0, 4);
            ItemCropSeed.setVisible(stack);
            this.storedCrops.add((Tuple<ItemStack, CropCard>)new Tuple((Object)stack, (Object)card));
        }
    }

    public int size() {
        return this.storedCrops.size();
    }

    public Tuple<ItemStack, CropCard> getEntry(int index) {
        return this.storedCrops.get(index);
    }

    @Override
    public void read(IInputBuffer buffer) {
        this.storedCrops.clear();
        if (!buffer.readBoolean()) {
            return;
        }
        int expected = buffer.readShort();
        for (int i = 0; i < expected; ++i) {
            String read = buffer.readString(NetworkField.BitLevel.Bit16);
            if (read.equals("Empty")) {
                ItemStack stack = new ItemStack(Items.field_151122_aG);
                stack.func_151001_c(Ic2GuiLang.catAll.getLocalized());
                this.storedCrops.add((Tuple<ItemStack, CropCard>)new Tuple((Object)stack, null));
                continue;
            }
            CropCard card = ClassicCrops.instance.getCropCard(new ResourceLocation(read));
            if (card == null) continue;
            ItemStack stack = ItemCropSeed.generateItemStack(card, 0, 0, 0, 1);
            ItemCropSeed.setVisible(stack);
            this.storedCrops.add((Tuple<ItemStack, CropCard>)new Tuple((Object)stack, (Object)card));
        }
    }

    @Override
    public void write(IOutputBuffer buffer) {
        if (this.storedCrops.isEmpty()) {
            buffer.writeBoolean(false);
            return;
        }
        buffer.writeBoolean(true);
        buffer.writeShort((short)this.storedCrops.size());
        for (Tuple<ItemStack, CropCard> entry : this.storedCrops) {
            CropCard card = (CropCard)entry.func_76340_b();
            if (card == null) {
                buffer.writeString("Empty", NetworkField.BitLevel.Bit16);
                continue;
            }
            buffer.writeString(new ResourceLocation(card.getOwner(), card.getId()).toString(), NetworkField.BitLevel.Bit16);
        }
    }
}

