/*
 * Decompiled with CFR 0.152.
 */
package ic2.core.block.base.tile;

import ic2.api.classic.network.adv.NetworkField;
import ic2.api.classic.tile.INotifyMachine;
import ic2.api.classic.tile.machine.IEUStorage;
import ic2.api.energy.EnergyNet;
import ic2.api.energy.event.EnergyTileLoadEvent;
import ic2.api.energy.event.EnergyTileUnloadEvent;
import ic2.api.energy.tile.IEnergyEmitter;
import ic2.api.energy.tile.IEnergySink;
import ic2.api.item.ElectricItem;
import ic2.core.Direction;
import ic2.core.block.base.tile.TileEntityMachine;
import ic2.core.block.base.util.comparator.ComparatorManager;
import ic2.core.block.base.util.comparator.comparators.ComparatorEUStorage;
import ic2.core.block.base.util.info.EnergyInfo;
import ic2.core.block.base.util.info.MaxInputInfo;
import ic2.core.block.base.util.info.NotifyInfo;
import ic2.core.block.base.util.info.SinkTierInfo;
import ic2.core.platform.registry.Ic2Items;
import java.util.EnumSet;
import java.util.Iterator;
import java.util.Set;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.init.Items;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.EnumFacing;
import net.minecraftforge.common.MinecraftForge;
import net.minecraftforge.fml.common.eventhandler.Event;

public abstract class TileEntityElecMachine
extends TileEntityMachine
implements IEnergySink,
IEUStorage {
    @NetworkField(index=3, override=true)
    public int energy = 0;
    private int fuelslot = -1;
    @NetworkField(index=4, override=true)
    public int maxEnergy = 0;
    @NetworkField(index=5)
    public int maxInput;
    @NetworkField(index=6, compression=NetworkField.BitLevel.Bit8)
    public int tier;
    public int baseTier;
    public boolean addedToEnergyNet;
    private Set<EnumFacing> notiIterator = EnumSet.noneOf(EnumFacing.class);
    private INotifyMachine[] machines = new INotifyMachine[6];

    public TileEntityElecMachine(int slots, int maxinput) {
        super(slots);
        this.baseTier = this.tier = EnergyNet.instance.getTierFromPower(maxinput);
        this.maxInput = maxinput;
        this.addGuiFields("energy", "maxEnergy", "tier", "maxInput");
        if (this.supportsNotify()) {
            this.addInfos(new NotifyInfo());
        }
        this.addInfos(new EnergyInfo(this), new SinkTierInfo(this), new MaxInputInfo(this));
    }

    @Override
    protected void addComparators(ComparatorManager manager) {
        super.addComparators(manager);
        manager.addComparatorMode(new ComparatorEUStorage(this));
    }

    public abstract boolean supportsNotify();

    public void notifyNeighbors() {
        Iterator<EnumFacing> iter = this.notiIterator.iterator();
        while (iter.hasNext()) {
            int index = iter.next().func_176745_a();
            INotifyMachine mach = this.machines[index];
            if (mach == null) continue;
            if (!mach.isValid()) {
                iter.remove();
                this.machines[index] = null;
                continue;
            }
            mach.onNotify();
        }
    }

    private void updateNeighborChanges() {
        for (Direction dir : Direction.directions) {
            EnumFacing facing = dir.toFacing();
            TileEntity tile = dir.applyToTileEntity(this);
            if (tile instanceof INotifyMachine) {
                this.notiIterator.add(facing);
                this.machines[facing.func_176745_a()] = (INotifyMachine)tile;
                continue;
            }
            this.notiIterator.remove(facing);
            this.machines[facing.func_176745_a()] = null;
        }
    }

    public void updateNeighbors() {
        if (this.field_145850_b.func_82737_E() % 80L == 0L && this.supportsNotify()) {
            this.updateNeighborChanges();
        }
    }

    public void setFuelSlot(int slot) {
        this.fuelslot = slot;
    }

    public void setMaxEnergy(int max) {
        this.maxEnergy = max;
        this.getNetwork().updateTileGuiField(this, "maxEnergy");
    }

    public void setMaxInput(int inputEnergy) {
        this.maxInput = inputEnergy;
        this.tier = EnergyNet.instance.getTierFromPower(inputEnergy);
        this.getNetwork().updateTileGuiField(this, "tier");
        this.getNetwork().updateTileGuiField(this, "maxInput");
    }

    public void setTier(int newTier) {
        this.tier = newTier;
        this.maxInput = (int)EnergyNet.instance.getPowerFromTier(newTier);
        this.getNetwork().updateTileGuiField(this, "tier");
        this.getNetwork().updateTileGuiField(this, "maxInput");
    }

    public boolean hasEnergy(int needed) {
        return this.energy >= needed;
    }

    public void useEnergy(int use) {
        this.energy -= use;
        if (this.energy < 0) {
            this.energy = 0;
        }
        this.getNetwork().updateTileGuiField(this, "energy");
    }

    @Override
    public void func_145839_a(NBTTagCompound nbt) {
        super.func_145839_a(nbt);
        this.energy = nbt.func_74762_e("StoredEnergy");
    }

    @Override
    public NBTTagCompound func_189515_b(NBTTagCompound nbt) {
        super.func_189515_b(nbt);
        nbt.func_74768_a("StoredEnergy", this.energy);
        return nbt;
    }

    @Override
    public boolean acceptsEnergyFrom(IEnergyEmitter emitter, EnumFacing side) {
        return true;
    }

    @Override
    public double getDemandedEnergy() {
        return this.maxEnergy - this.energy;
    }

    @Override
    public int getSinkTier() {
        return this.tier;
    }

    @Override
    public void onLoaded() {
        super.onLoaded();
        if (this.isSimulating()) {
            if (!this.addedToEnergyNet) {
                MinecraftForge.EVENT_BUS.post((Event)new EnergyTileLoadEvent(this));
                this.addedToEnergyNet = true;
            }
            if (this.supportsNotify()) {
                this.updateNeighborChanges();
            }
        }
    }

    @Override
    public void onUnloaded() {
        if (this.addedToEnergyNet && this.isSimulating()) {
            MinecraftForge.EVENT_BUS.post((Event)new EnergyTileUnloadEvent(this));
            this.addedToEnergyNet = false;
        }
        super.onUnloaded();
    }

    @Override
    public double injectEnergy(EnumFacing directionFrom, double amount, double voltage) {
        if (amount > (double)this.maxInput || amount <= 0.0) {
            return 0.0;
        }
        this.energy = (int)((double)this.energy + amount);
        int left = 0;
        if (this.energy >= this.maxEnergy) {
            left = this.energy - this.maxEnergy;
            this.energy = this.maxEnergy;
        }
        this.getNetwork().updateTileGuiField(this, "energy");
        return left;
    }

    public void handleChargeSlot(int neededEnergy) {
        boolean didProvide;
        if (this.fuelslot != -1 && this.energy <= neededEnergy && (didProvide = this.provideEnergy())) {
            this.getNetwork().updateTileGuiField(this, "energy");
        }
    }

    public int getTier() {
        return this.tier;
    }

    public boolean provideEnergy() {
        boolean ret = false;
        ItemStack fuel = (ItemStack)this.inventory.get(this.fuelslot);
        if (fuel.func_190926_b()) {
            return false;
        }
        Item item = fuel.func_77973_b();
        int transfer = (int)ElectricItem.manager.discharge(fuel, this.maxEnergy - this.energy, this.getTier(), false, true, false);
        if (transfer > 0) {
            this.energy += transfer;
            this.getNetwork().updateTileGuiField(this, "energy");
            return true;
        }
        if (item == Items.field_151137_ax) {
            this.energy += this.maxEnergy;
            fuel.func_190918_g(1);
            this.getNetwork().updateTileGuiField(this, "energy");
            return true;
        }
        if (item == Ic2Items.suBattery.func_77973_b()) {
            this.energy += 1000;
            fuel.func_190918_g(1);
            this.getNetwork().updateTileGuiField(this, "energy");
            return true;
        }
        return ret;
    }

    @Override
    public boolean canRemoveBlock(EntityPlayer player) {
        return true;
    }

    @Override
    public double getWrenchDropRate() {
        return 0.85;
    }

    @Override
    public int getStoredEU() {
        return this.energy;
    }

    @Override
    public int getMaxEU() {
        return this.maxEnergy;
    }

    @Override
    public boolean canSetFacing(EntityPlayer player, EnumFacing facing) {
        return this.getFacing() != facing;
    }
}

