/*
 * Decompiled with CFR 0.152.
 */
package ic2.core;

import com.google.gson.JsonArray;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import com.google.gson.internal.Streams;
import com.google.gson.stream.JsonWriter;
import ic2.api.classic.recipe.crafting.IAdvRecipe;
import ic2.api.classic.recipe.crafting.IRecipeObject;
import ic2.core.IC2;
import ic2.core.item.recipe.AdvRecipeBase;
import ic2.core.util.helpers.ItemWithMeta;
import java.io.File;
import java.io.FileWriter;
import java.io.Writer;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.LinkedHashMap;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.Set;
import net.minecraft.item.ItemStack;
import net.minecraft.util.NonNullList;
import net.minecraft.util.ResourceLocation;
import net.minecraftforge.oredict.OreDictionary;

public class RecipeResolver {
    public static final RecipeResolver resolver = new RecipeResolver();
    List<AdvRecipeBase> listToResolve = new ArrayList<AdvRecipeBase>();

    public void init(List<IAdvRecipe> resolve) {
    }

    public void resolve() {
        LinkedHashMap<Object, LinkedHashSet<ResourceLocation>> map = new LinkedHashMap<Object, LinkedHashSet<ResourceLocation>>();
        for (AdvRecipeBase base : this.listToResolve) {
            ResourceLocation loctation = base.getRegistryName();
            for (IRecipeObject obj : base.getRecipeInput()) {
                if (obj.isOreDicted()) {
                    Set<Object> set = (Set)map.get(obj.getOreID());
                    if (set == null) {
                        set = new LinkedHashSet<ResourceLocation>();
                        map.put(obj.getOreID(), (LinkedHashSet<ResourceLocation>)set);
                    }
                    set.add(loctation);
                    continue;
                }
                for (ItemStack stack : obj.getItems()) {
                    ItemWithMeta sub = new ItemWithMeta(stack);
                    LinkedHashSet<ResourceLocation> set = (LinkedHashSet<ResourceLocation>)map.get(sub);
                    if (set == null) {
                        set = new LinkedHashSet<ResourceLocation>();
                        map.put(sub, set);
                    }
                    set.add(loctation);
                }
            }
        }
        File file = new File(IC2.configFolder, "recipes");
        file.mkdirs();
        for (Map.Entry entry : map.entrySet()) {
            Object obj = entry.getKey();
            Set locations = (Set)map.get(obj);
            JsonObject finalObject = new JsonObject();
            finalObject.addProperty("parent", "minecraft:recipes/root");
            JsonObject reward = new JsonObject();
            reward.add("recipes", (JsonElement)this.fromLocations(locations));
            finalObject.add("rewards", (JsonElement)reward);
            JsonObject criteria = new JsonObject();
            finalObject.add("criteria", (JsonElement)criteria);
            List<String> list = this.addCriteria(criteria, obj);
            if (list.isEmpty()) continue;
            finalObject.add("requirements", (JsonElement)this.toArray(list));
            try {
                String s = this.makeString(obj);
                if (s.equalsIgnoreCase("UNKNOWN")) continue;
                JsonWriter writer = new JsonWriter((Writer)new FileWriter(new File(file, s + "_recipes.json")));
                writer.setIndent(" ");
                Streams.write((JsonElement)finalObject, (JsonWriter)writer);
                writer.close();
            }
            catch (Exception e) {
                e.printStackTrace();
            }
        }
    }

    private String makeString(Object obj) {
        if (obj instanceof ItemWithMeta) {
            return ((ItemWithMeta)obj).toStack().func_82833_r().toLowerCase(Locale.ROOT).trim().replaceAll(" ", "_");
        }
        if (obj instanceof String) {
            return ((String)obj).toLowerCase(Locale.ROOT).trim().replaceAll(" ", "_");
        }
        return "UNKOWN";
    }

    private JsonArray toArray(List<String> req) {
        JsonArray first = new JsonArray();
        for (String s : req) {
            first.add(s);
        }
        JsonArray second = new JsonArray();
        second.add((JsonElement)first);
        return second;
    }

    private List<String> addCriteria(JsonObject criteria, Object obj) {
        NonNullList list;
        if (obj instanceof ItemWithMeta) {
            JsonObject hasItem = new JsonObject();
            criteria.add("has_item", (JsonElement)hasItem);
            hasItem.addProperty("trigger", "minecraft:inventory_changed");
            hasItem.add("conditions", (JsonElement)this.makeFromStack((ItemWithMeta)obj));
            return Arrays.asList("has_item");
        }
        if (obj instanceof String && !(list = OreDictionary.getOres((String)((String)obj))).isEmpty()) {
            ArrayList<String> result = new ArrayList<String>();
            for (int i = 0; i < list.size(); ++i) {
                JsonObject hasItem = new JsonObject();
                criteria.add("has_item_" + i, (JsonElement)hasItem);
                hasItem.addProperty("trigger", "minecraft:inventory_changed");
                hasItem.add("conditions", (JsonElement)this.makeFromStack(new ItemWithMeta((ItemStack)list.get(i))));
                result.add("has_item_" + i);
            }
            return result;
        }
        return new ArrayList<String>();
    }

    private JsonObject makeFromStack(ItemWithMeta meta) {
        JsonObject obj = new JsonObject();
        obj.addProperty("item", meta.getItem().getRegistryName().toString());
        obj.addProperty("data", (Number)meta.getMeta());
        JsonArray array = new JsonArray();
        array.add((JsonElement)obj);
        JsonObject result = new JsonObject();
        result.add("items", (JsonElement)array);
        return result;
    }

    private JsonArray fromLocations(Collection<ResourceLocation> input) {
        JsonArray array = new JsonArray();
        for (ResourceLocation location : input) {
            array.add(location.toString());
        }
        return array;
    }
}

