/*
 * Decompiled with CFR 0.152.
 */
package lumien.randomthings.block;

import java.util.HashMap;
import java.util.HashSet;
import lumien.randomthings.block.BlockContainerBase;
import lumien.randomthings.tileentity.TileEntityInventoryRerouter;
import net.minecraft.block.Block;
import net.minecraft.block.material.Material;
import net.minecraft.block.properties.IProperty;
import net.minecraft.block.properties.PropertyDirection;
import net.minecraft.block.state.BlockStateContainer;
import net.minecraft.block.state.IBlockState;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.item.ItemStack;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.BlockRenderLayer;
import net.minecraft.util.EnumFacing;
import net.minecraft.util.EnumHand;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.IBlockAccess;
import net.minecraft.world.World;
import net.minecraftforge.common.property.ExtendedBlockState;
import net.minecraftforge.common.property.IExtendedBlockState;
import net.minecraftforge.common.property.IUnlistedProperty;

public class BlockInventoryRerouter
extends BlockContainerBase {
    public static final PropertyDirection FACING = PropertyDirection.func_177714_a((String)"facing");
    public static final OverrideDataProperty OVERRIDE_DATA = new OverrideDataProperty();
    HashSet<BlockPos> circleSet = new HashSet();

    protected BlockInventoryRerouter() {
        super("inventoryRerouter", Material.field_151576_e);
        this.func_149711_c(1.5f);
    }

    public BlockRenderLayer func_180664_k() {
        return BlockRenderLayer.CUTOUT;
    }

    public boolean func_180639_a(World worldIn, BlockPos pos, IBlockState state, EntityPlayer playerIn, EnumHand hand, EnumFacing facing, float hitX, float hitY, float hitZ) {
        TileEntity te = worldIn.func_175625_s(pos);
        EnumFacing myFacing = (EnumFacing)state.func_177229_b((IProperty)FACING);
        if (facing != myFacing) {
            if (te instanceof TileEntityInventoryRerouter) {
                ((TileEntityInventoryRerouter)te).rotateFacing(facing);
            }
            return true;
        }
        return false;
    }

    @Override
    public TileEntity createTileEntity(World world, IBlockState state) {
        return new TileEntityInventoryRerouter();
    }

    public void func_176213_c(World worldIn, BlockPos pos, IBlockState state) {
        super.func_176213_c(worldIn, pos, state);
        this.setDefaultFacing(worldIn, pos, state);
    }

    @Override
    public void func_189540_a(IBlockState state, World worldIn, BlockPos pos, Block neighborBlock, BlockPos changedPos) {
        if (this.circleSet.contains(pos)) {
            return;
        }
        EnumFacing facing = (EnumFacing)state.func_177229_b((IProperty)FACING);
        BlockPos offset = pos.func_177972_a(facing);
        if (offset.equals((Object)changedPos)) {
            this.circleSet.add(pos);
            worldIn.func_175685_c(pos, (Block)this, false);
            this.circleSet.remove(pos);
        }
        super.func_189540_a(state, worldIn, pos, neighborBlock, changedPos);
    }

    private void setDefaultFacing(World worldIn, BlockPos pos, IBlockState state) {
        if (!worldIn.field_72995_K) {
            IBlockState iblockstate = worldIn.func_180495_p(pos.func_177978_c());
            IBlockState iblockstate1 = worldIn.func_180495_p(pos.func_177968_d());
            IBlockState iblockstate2 = worldIn.func_180495_p(pos.func_177976_e());
            IBlockState iblockstate3 = worldIn.func_180495_p(pos.func_177974_f());
            EnumFacing enumfacing = (EnumFacing)state.func_177229_b((IProperty)FACING);
            if (enumfacing == EnumFacing.NORTH && iblockstate.func_185913_b() && !iblockstate1.func_185913_b()) {
                enumfacing = EnumFacing.SOUTH;
            } else if (enumfacing == EnumFacing.SOUTH && iblockstate1.func_185913_b() && !iblockstate.func_185913_b()) {
                enumfacing = EnumFacing.NORTH;
            } else if (enumfacing == EnumFacing.WEST && iblockstate2.func_185913_b() && !iblockstate3.func_185913_b()) {
                enumfacing = EnumFacing.EAST;
            } else if (enumfacing == EnumFacing.EAST && iblockstate3.func_185913_b() && !iblockstate2.func_185913_b()) {
                enumfacing = EnumFacing.WEST;
            }
            worldIn.func_180501_a(pos, state.func_177226_a((IProperty)FACING, (Comparable)enumfacing), 2);
        }
    }

    public IBlockState func_180642_a(World worldIn, BlockPos pos, EnumFacing facing, float hitX, float hitY, float hitZ, int meta, EntityLivingBase placer) {
        return this.func_176223_P().func_177226_a((IProperty)FACING, (Comparable)EnumFacing.func_190914_a((BlockPos)pos, (EntityLivingBase)placer));
    }

    public void func_180633_a(World worldIn, BlockPos pos, IBlockState state, EntityLivingBase placer, ItemStack stack) {
        worldIn.func_180501_a(pos, state.func_177226_a((IProperty)FACING, (Comparable)EnumFacing.func_190914_a((BlockPos)pos, (EntityLivingBase)placer)), 2);
    }

    public IBlockState func_176203_a(int meta) {
        return this.func_176223_P().func_177226_a((IProperty)FACING, (Comparable)EnumFacing.func_82600_a((int)(meta & 7)));
    }

    public int func_176201_c(IBlockState state) {
        int b0 = 0;
        int i = b0 | ((EnumFacing)state.func_177229_b((IProperty)FACING)).func_176745_a();
        return i;
    }

    protected BlockStateContainer func_180661_e() {
        return new ExtendedBlockState((Block)this, new IProperty[]{FACING}, new IUnlistedProperty[]{OVERRIDE_DATA});
    }

    public IBlockState getExtendedState(IBlockState state, IBlockAccess worldIn, BlockPos pos) {
        TileEntity te = worldIn.func_175625_s(pos);
        IExtendedBlockState extendedState = (IExtendedBlockState)state;
        if (te instanceof TileEntityInventoryRerouter) {
            TileEntityInventoryRerouter rerouter = (TileEntityInventoryRerouter)te;
            HashMap<EnumFacing, EnumFacing> facingMap = rerouter.getFacingMap();
            return extendedState.withProperty((IUnlistedProperty)OVERRIDE_DATA, new HashMap<EnumFacing, EnumFacing>(facingMap));
        }
        return super.func_176221_a(state, worldIn, pos);
    }

    private static class OverrideDataProperty
    implements IUnlistedProperty<HashMap<EnumFacing, EnumFacing>> {
        private OverrideDataProperty() {
        }

        public String getName() {
            return "overridedata";
        }

        public boolean isValid(HashMap<EnumFacing, EnumFacing> value) {
            return true;
        }

        public Class getType() {
            return HashMap.class;
        }

        public String valueToString(HashMap<EnumFacing, EnumFacing> value) {
            return value.toString();
        }
    }
}

