/*
 * Decompiled with CFR 0.152.
 */
package cubex2.cs4.util;

import com.google.gson.JsonArray;
import com.google.gson.JsonDeserializationContext;
import com.google.gson.JsonDeserializer;
import com.google.gson.JsonElement;
import com.google.gson.JsonParseException;
import java.lang.reflect.Type;
import java.util.function.IntFunction;

public class ArrayDeserializer<T>
implements JsonDeserializer<T[]> {
    private final IntFunction<T[]> supplier;
    private final Class<T> elementClass;

    public ArrayDeserializer(IntFunction<T[]> supplier, Class<T> elementClass) {
        this.supplier = supplier;
        this.elementClass = elementClass;
    }

    public T[] deserialize(JsonElement json, Type typeOfT, JsonDeserializationContext context) throws JsonParseException {
        if (json.isJsonArray()) {
            JsonArray array = json.getAsJsonArray();
            T[] result = this.supplier.apply(array.size());
            for (int i = 0; i < array.size(); ++i) {
                result[i] = context.deserialize(array.get(i), this.elementClass);
            }
            return result;
        }
        T[] result = this.supplier.apply(1);
        result[0] = context.deserialize(json, this.elementClass);
        return result;
    }
}

