/*
 * Decompiled with CFR 0.152.
 */
package cubex2.cs4.plugins.vanilla.item;

import com.google.common.collect.HashMultimap;
import com.google.common.collect.Multimap;
import cubex2.cs4.plugins.vanilla.ContentItemSword;
import cubex2.cs4.plugins.vanilla.item.ItemTool;
import java.util.Arrays;
import java.util.List;
import javax.annotation.Nullable;
import net.minecraft.client.util.ITooltipFlag;
import net.minecraft.entity.SharedMonsterAttributes;
import net.minecraft.entity.ai.attributes.AttributeModifier;
import net.minecraft.inventory.EntityEquipmentSlot;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.world.World;

public class ItemSword
extends net.minecraft.item.ItemSword
implements ItemTool {
    private final ContentItemSword content;
    private final float defaultAttackDamage;
    private final double defaultAttackSpeed = -2.4;
    private Float attackDamage = null;
    private Float attackSpeed = null;

    public ItemSword(Item.ToolMaterial material, ContentItemSword content) {
        super(material);
        this.content = content;
        this.defaultAttackDamage = 3.0f + material.func_78000_c();
    }

    @Override
    public void setDamage(float damage) {
        this.attackDamage = Float.valueOf(damage);
    }

    @Override
    public void setAttackSpeed(float attackSpeed) {
        this.attackSpeed = Float.valueOf(attackSpeed);
    }

    public void func_77624_a(ItemStack stack, @Nullable World worldIn, List<String> tooltip, ITooltipFlag flagIn) {
        tooltip.addAll(Arrays.asList(this.content.information));
    }

    public Multimap<String, AttributeModifier> getAttributeModifiers(EntityEquipmentSlot slot, ItemStack stack) {
        HashMultimap multimap = HashMultimap.create();
        if (slot == EntityEquipmentSlot.MAINHAND) {
            double damage = this.attackDamage != null ? (double)this.attackDamage.floatValue() : (double)this.defaultAttackDamage;
            double speed = this.attackSpeed != null ? (double)this.attackSpeed.floatValue() : -2.4;
            multimap.put((Object)SharedMonsterAttributes.field_111264_e.func_111108_a(), (Object)new AttributeModifier(field_111210_e, "Weapon modifier", damage, 0));
            multimap.put((Object)SharedMonsterAttributes.field_188790_f.func_111108_a(), (Object)new AttributeModifier(field_185050_h, "Weapon modifier", speed, 0));
        }
        return multimap;
    }

    public int getItemBurnTime(ItemStack itemStack) {
        return this.content.burnTime.get(itemStack.func_77960_j()).orElse(-1);
    }
}

