/*
 * Decompiled with CFR 0.152.
 */
package cubex2.cs4.plugins.vanilla;

import com.google.common.collect.Maps;
import com.google.gson.JsonDeserializationContext;
import com.google.gson.JsonDeserializer;
import com.google.gson.JsonElement;
import com.google.gson.JsonParseException;
import java.lang.reflect.Type;
import java.util.Map;
import net.minecraft.block.material.MapColor;

class MapColorDeserializer
implements JsonDeserializer<MapColor> {
    private static final Map<String, MapColor> colorsByName = Maps.newHashMap();

    MapColorDeserializer() {
    }

    public MapColor deserialize(JsonElement json, Type typeOfT, JsonDeserializationContext context) throws JsonParseException {
        return colorsByName.getOrDefault(json.getAsString(), MapColor.field_151660_b);
    }

    private static void add(String name, MapColor color) {
        colorsByName.put(name, color);
    }

    static {
        MapColorDeserializer.add("air", MapColor.field_151660_b);
        MapColorDeserializer.add("grass", MapColor.field_151661_c);
        MapColorDeserializer.add("sand", MapColor.field_151658_d);
        MapColorDeserializer.add("cloth", MapColor.field_151659_e);
        MapColorDeserializer.add("tnt", MapColor.field_151656_f);
        MapColorDeserializer.add("ice", MapColor.field_151657_g);
        MapColorDeserializer.add("iron", MapColor.field_151668_h);
        MapColorDeserializer.add("foliage", MapColor.field_151669_i);
        MapColorDeserializer.add("snow", MapColor.field_151666_j);
        MapColorDeserializer.add("clay", MapColor.field_151667_k);
        MapColorDeserializer.add("dirt", MapColor.field_151664_l);
        MapColorDeserializer.add("stone", MapColor.field_151665_m);
        MapColorDeserializer.add("water", MapColor.field_151662_n);
        MapColorDeserializer.add("wood", MapColor.field_151663_o);
        MapColorDeserializer.add("quartz", MapColor.field_151677_p);
        MapColorDeserializer.add("adobe", MapColor.field_151676_q);
        MapColorDeserializer.add("magenta", MapColor.field_151675_r);
        MapColorDeserializer.add("light_blue", MapColor.field_151674_s);
        MapColorDeserializer.add("yellow", MapColor.field_151673_t);
        MapColorDeserializer.add("lime", MapColor.field_151672_u);
        MapColorDeserializer.add("pink", MapColor.field_151671_v);
        MapColorDeserializer.add("gray", MapColor.field_151670_w);
        MapColorDeserializer.add("silver", MapColor.field_151680_x);
        MapColorDeserializer.add("cyan", MapColor.field_151679_y);
        MapColorDeserializer.add("purple", MapColor.field_151678_z);
        MapColorDeserializer.add("blue", MapColor.field_151649_A);
        MapColorDeserializer.add("brown", MapColor.field_151650_B);
        MapColorDeserializer.add("green", MapColor.field_151651_C);
        MapColorDeserializer.add("red", MapColor.field_151645_D);
        MapColorDeserializer.add("black", MapColor.field_151646_E);
        MapColorDeserializer.add("gold", MapColor.field_151647_F);
        MapColorDeserializer.add("diamond", MapColor.field_151648_G);
        MapColorDeserializer.add("lapis", MapColor.field_151652_H);
        MapColorDeserializer.add("emerald", MapColor.field_151653_I);
        MapColorDeserializer.add("obsidian", MapColor.field_151654_J);
        MapColorDeserializer.add("netherrack", MapColor.field_151655_K);
    }
}

