/*
 * Decompiled with CFR 0.152.
 */
package WayofTime.bloodmagic.util;

import WayofTime.bloodmagic.altar.ComponentType;
import WayofTime.bloodmagic.core.RegistrarBloodMagicBlocks;
import WayofTime.bloodmagic.iface.IDemonWillViewer;
import WayofTime.bloodmagic.network.BloodMagicPacketHandler;
import WayofTime.bloodmagic.network.PlayerVelocityPacketProcessor;
import WayofTime.bloodmagic.tile.TileInventory;
import WayofTime.bloodmagic.util.BMLog;
import WayofTime.bloodmagic.util.helper.NBTHelper;
import com.google.common.collect.Iterables;
import com.google.common.collect.Maps;
import java.lang.reflect.Field;
import java.util.ArrayList;
import java.util.EnumMap;
import java.util.List;
import java.util.Locale;
import java.util.UUID;
import javax.annotation.Nullable;
import net.minecraft.block.Block;
import net.minecraft.block.BlockPortal;
import net.minecraft.block.state.IBlockState;
import net.minecraft.enchantment.EnchantmentHelper;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.entity.item.EntityItem;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.entity.player.EntityPlayerMP;
import net.minecraft.init.Blocks;
import net.minecraft.init.MobEffects;
import net.minecraft.init.SoundEvents;
import net.minecraft.inventory.IInventory;
import net.minecraft.inventory.ISidedInventory;
import net.minecraft.item.EnumDyeColor;
import net.minecraft.item.Item;
import net.minecraft.item.ItemArmor;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTBase;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.potion.Potion;
import net.minecraft.potion.PotionEffect;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.DamageSource;
import net.minecraft.util.EnumFacing;
import net.minecraft.util.SoundCategory;
import net.minecraft.util.math.AxisAlignedBB;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.MathHelper;
import net.minecraft.util.math.RayTraceResult;
import net.minecraft.util.math.Vec3d;
import net.minecraft.util.math.Vec3i;
import net.minecraft.world.IBlockAccess;
import net.minecraft.world.World;
import net.minecraftforge.common.IPlantable;
import net.minecraftforge.common.ISpecialArmor;
import net.minecraftforge.fluids.IFluidBlock;
import net.minecraftforge.fml.common.ObfuscationReflectionHelper;
import net.minecraftforge.items.CapabilityItemHandler;
import net.minecraftforge.items.IItemHandler;
import net.minecraftforge.items.ItemHandlerHelper;
import net.minecraftforge.items.wrapper.InvWrapper;
import net.minecraftforge.items.wrapper.PlayerMainInvWrapper;
import net.minecraftforge.items.wrapper.SidedInvWrapper;

public class Utils {
    public static final EnumMap<EnumDyeColor, Integer> DYE_COLOR_VALUES = Maps.newEnumMap(EnumDyeColor.class);

    public static float addAbsorptionToMaximum(EntityLivingBase entity, float added, int maximum, int duration) {
        float currentAmount = entity.func_110139_bj();
        added = Math.min((float)maximum - currentAmount, added);
        if (added <= 0.0f) {
            return 0.0f;
        }
        if (duration > 0) {
            int potionLevel = (int)((currentAmount + added) / 4.0f);
            entity.func_70690_d(new PotionEffect(MobEffects.field_76444_x, duration, potionLevel, true, false));
        }
        entity.func_110149_m(currentAmount + added);
        return added;
    }

    public static boolean isImmuneToFireDamage(EntityLivingBase entity) {
        return entity.func_70045_F() || entity.func_70644_a(MobEffects.field_76426_n);
    }

    public static boolean isPlayerBesideSolidBlockFace(EntityPlayer player) {
        World world = player.func_130014_f_();
        double minimumDistanceFromAxis = 0.7;
        BlockPos centralPos = player.func_180425_c();
        for (EnumFacing facing : EnumFacing.field_176754_o) {
            IBlockState state;
            BlockPos offsetPos = centralPos.func_177972_a(facing);
            double distance = Math.min((double)offsetPos.func_177958_n() + 0.5 - player.field_70165_t, (double)offsetPos.func_177952_p() + 0.5 - player.field_70161_v);
            if (distance > minimumDistanceFromAxis || !(state = world.func_180495_p(offsetPos)).isSideSolid((IBlockAccess)world, offsetPos, facing.func_176734_d())) continue;
            return true;
        }
        return false;
    }

    public static boolean canPlayerSeeDemonWill(EntityPlayer player) {
        PlayerMainInvWrapper inventory = new PlayerMainInvWrapper(player.field_71071_by);
        for (int i = 0; i < inventory.getSlots(); ++i) {
            ItemStack stack = inventory.getStackInSlot(i);
            if (stack.func_190926_b() || !(stack.func_77973_b() instanceof IDemonWillViewer) || !((IDemonWillViewer)stack.func_77973_b()).canSeeDemonWillAura(player.func_130014_f_(), stack, player)) continue;
            return true;
        }
        return false;
    }

    public static boolean canEntitySeeBlock(World world, Entity entity, BlockPos pos) {
        Vec3d relativePosition = new Vec3d(entity.field_70165_t - (double)pos.func_177958_n() - 0.5, entity.field_70163_u + (double)entity.func_70047_e() - (double)pos.func_177956_o() - 0.5, entity.field_70161_v - (double)pos.func_177952_p() - 0.5);
        EnumFacing dir = EnumFacing.func_176737_a((float)((float)relativePosition.field_72450_a), (float)((float)relativePosition.field_72448_b), (float)((float)relativePosition.field_72449_c));
        RayTraceResult result = world.func_147447_a(new Vec3d(entity.field_70165_t, entity.field_70163_u + (double)entity.func_70047_e(), entity.field_70161_v), new Vec3d((double)pos.func_177958_n() + 0.5 + (double)dir.func_82601_c() * 0.4, (double)pos.func_177956_o() + 0.5 + (double)dir.func_96559_d() * 0.4, (double)pos.func_177952_p() + 0.5 + (double)dir.func_82599_e() * 0.4), false, true, true);
        return result == null || pos.equals((Object)result.func_178782_a());
    }

    public static int plantSeedsInArea(World world, AxisAlignedBB aabb, int horizontalRadius, int verticalRadius) {
        int placedBlocks = 0;
        List itemEntities = world.func_72872_a(EntityItem.class, aabb);
        for (EntityItem itemEntity : itemEntities) {
            placedBlocks += Utils.plantEntityItem(itemEntity, horizontalRadius, verticalRadius);
        }
        return placedBlocks;
    }

    public static int plantItemStack(World world, BlockPos centralPos, ItemStack stack, int horizontalRadius, int verticalRadius) {
        if (stack.func_190926_b()) {
            return 0;
        }
        Item item = stack.func_77973_b();
        if (!(item instanceof IPlantable)) {
            return 0;
        }
        int planted = 0;
        for (int hR = 0; hR <= horizontalRadius; ++hR) {
            for (int vR = 0; vR <= verticalRadius; ++vR) {
                for (int i = -hR; i <= hR; ++i) {
                    for (int k = -hR; k <= hR; ++k) {
                        for (int j = -vR; j <= vR; j += 2 * vR + (vR > 0 ? 0 : 1)) {
                            BlockPos offsetPos;
                            IBlockState state;
                            BlockPos newPos;
                            if (Math.abs(i) != hR && Math.abs(k) != hR || !world.func_175623_d(newPos = centralPos.func_177982_a(i, j, k)) || !(state = world.func_180495_p(offsetPos = newPos.func_177972_a(EnumFacing.DOWN))).func_177230_c().canSustainPlant(state, (IBlockAccess)world, offsetPos, EnumFacing.UP, (IPlantable)item)) continue;
                            IBlockState plantState = ((IPlantable)item).getPlant((IBlockAccess)world, newPos);
                            world.func_180501_a(newPos, plantState, 3);
                            world.func_175718_b(2001, newPos, Block.func_149682_b((Block)plantState.func_177230_c()) + (plantState.func_177230_c().func_176201_c(plantState) << 12));
                            stack.func_190918_g(1);
                            ++planted;
                            if (!stack.func_190926_b() && stack.func_190916_E() > 0) continue;
                            return planted;
                        }
                    }
                }
            }
        }
        return planted;
    }

    public static int plantEntityItem(EntityItem itemEntity, int horizontalRadius, int verticalRadius) {
        if (itemEntity == null || itemEntity.field_70128_L) {
            return 0;
        }
        World world = itemEntity.func_130014_f_();
        BlockPos pos = itemEntity.func_180425_c();
        ItemStack stack = itemEntity.func_92059_d();
        int planted = Utils.plantItemStack(world, pos, stack, horizontalRadius, verticalRadius);
        if (stack.func_190926_b()) {
            itemEntity.func_70106_y();
        }
        return planted;
    }

    public static int getDemonWillResolution(EntityPlayer player) {
        PlayerMainInvWrapper inventory = new PlayerMainInvWrapper(player.field_71071_by);
        for (int i = 0; i < inventory.getSlots(); ++i) {
            ItemStack stack = inventory.getStackInSlot(i);
            if (stack.func_190926_b() || !(stack.func_77973_b() instanceof IDemonWillViewer) || !((IDemonWillViewer)stack.func_77973_b()).canSeeDemonWillAura(player.func_130014_f_(), stack, player)) continue;
            return ((IDemonWillViewer)stack.func_77973_b()).getDemonWillAuraResolution(player.func_130014_f_(), stack, player);
        }
        return 1;
    }

    public static NBTTagCompound getPersistentDataTag(EntityPlayer player) {
        NBTTagCompound forgeData = player.getEntityData().func_74775_l("PlayerPersisted");
        NBTTagCompound beaconData = forgeData.func_74775_l("BloodMagic");
        if (!forgeData.func_74764_b("BloodMagic")) {
            forgeData.func_74782_a("BloodMagic", (NBTBase)beaconData);
        }
        if (!player.getEntityData().func_74764_b("PlayerPersisted")) {
            player.getEntityData().func_74782_a("PlayerPersisted", (NBTBase)forgeData);
        }
        return beaconData;
    }

    public static void setPlayerSpeedFromServer(EntityPlayer player, double motionX, double motionY, double motionZ) {
        if (!player.func_130014_f_().field_72995_K && player instanceof EntityPlayerMP) {
            BloodMagicPacketHandler.sendTo(new PlayerVelocityPacketProcessor(motionX, motionY, motionZ), (EntityPlayerMP)player);
        }
    }

    public static boolean isInteger(String integer) {
        try {
            Integer.parseInt(integer);
        }
        catch (NullPointerException | NumberFormatException e) {
            return false;
        }
        return true;
    }

    public static String toFancyCasing(String input) {
        return String.valueOf(input.charAt(0)).toUpperCase(Locale.ENGLISH) + input.substring(1);
    }

    public static String prettifyBlockPosString(BlockPos pos) {
        return "[" + pos.func_177958_n() + ", " + pos.func_177956_o() + ", " + pos.func_177952_p() + "]";
    }

    public static boolean insertItemToTile(TileInventory tile, EntityPlayer player) {
        return Utils.insertItemToTile(tile, player, 0);
    }

    public static boolean insertItemToTile(TileInventory tile, EntityPlayer player, int slot) {
        ItemStack slotStack = tile.func_70301_a(slot);
        if (slotStack.func_190926_b() && !player.func_184614_ca().func_190926_b()) {
            ItemStack input = player.func_184614_ca().func_77946_l();
            input.func_190920_e(1);
            player.func_184614_ca().func_190918_g(1);
            tile.func_70299_a(slot, input);
            return true;
        }
        if (!slotStack.func_190926_b() && player.func_184614_ca().func_190926_b()) {
            ItemHandlerHelper.giveItemToPlayer((EntityPlayer)player, (ItemStack)slotStack);
            tile.func_174888_l();
            return false;
        }
        return false;
    }

    public static double calculateStandardProgress(Number currentValue, int[] requiredValues, int currentLevel) {
        int nextLevel = currentLevel + 1;
        if (nextLevel >= requiredValues.length) {
            return 1.0;
        }
        int required = requiredValues[nextLevel];
        return Double.parseDouble("" + currentValue) / (double)required;
    }

    @Nullable
    public static IItemHandler getInventory(TileEntity tile, @Nullable EnumFacing facing) {
        if (facing == null) {
            facing = EnumFacing.DOWN;
        }
        IItemHandler itemHandler = null;
        if (tile.hasCapability(CapabilityItemHandler.ITEM_HANDLER_CAPABILITY, facing)) {
            itemHandler = (IItemHandler)tile.getCapability(CapabilityItemHandler.ITEM_HANDLER_CAPABILITY, facing);
        } else if (tile instanceof ISidedInventory) {
            itemHandler = ((ISidedInventory)tile).func_180463_a(facing).length != 0 ? new SidedInvWrapper((ISidedInventory)tile, facing) : null;
        } else if (tile instanceof IInventory) {
            itemHandler = new InvWrapper((IInventory)tile);
        }
        return itemHandler;
    }

    public static ItemStack setUnbreakable(ItemStack stack) {
        NBTHelper.checkNBT(stack);
        stack.func_77978_p().func_74757_a("Unbreakable", true);
        return stack;
    }

    public static Block getBlockForComponent(ComponentType component) {
        switch (component) {
            case GLOWSTONE: {
                return Blocks.field_150426_aN;
            }
            case BLOODSTONE: {
                return RegistrarBloodMagicBlocks.DECORATIVE_BRICK;
            }
            case BEACON: {
                return Blocks.field_150461_bJ;
            }
            case BLOODRUNE: {
                return RegistrarBloodMagicBlocks.BLOOD_RUNE;
            }
            case CRYSTAL: {
                return RegistrarBloodMagicBlocks.BLOOD_RUNE;
            }
            case NOTAIR: {
                return Blocks.field_150417_aV;
            }
        }
        return Blocks.field_150350_a;
    }

    public static float getModifiedDamage(EntityLivingBase attackedEntity, DamageSource source, float amount) {
        if (!attackedEntity.func_180431_b(source)) {
            if (amount <= 0.0f) {
                return 0.0f;
            }
            amount = Utils.applyArmor(attackedEntity, (ItemStack[])Iterables.toArray((Iterable)attackedEntity.func_184209_aF(), ItemStack.class), source, amount);
            if (amount <= 0.0f) {
                return 0.0f;
            }
            amount = Utils.applyPotionDamageCalculations(attackedEntity, source, amount);
            return amount;
        }
        return 0.0f;
    }

    public static float applyArmor(EntityLivingBase entity, ItemStack[] inventory, DamageSource source, double damage) {
        damage *= 25.0;
        ArrayList<ISpecialArmor.ArmorProperties> dmgVals = new ArrayList<ISpecialArmor.ArmorProperties>();
        for (int x = 0; x < inventory.length; ++x) {
            ISpecialArmor armor;
            ItemStack stack = inventory[x];
            if (stack.func_190926_b()) continue;
            ISpecialArmor.ArmorProperties prop = null;
            if (stack.func_77973_b() instanceof ISpecialArmor) {
                armor = (ISpecialArmor)stack.func_77973_b();
                prop = armor.getProperties(entity, stack, source, damage / 25.0, x).copy();
            } else if (stack.func_77973_b() instanceof ItemArmor && !source.func_76363_c()) {
                armor = (ItemArmor)stack.func_77973_b();
                prop = new ISpecialArmor.ArmorProperties(0, (double)armor.field_77879_b / 25.0, Integer.MAX_VALUE);
            }
            if (prop == null) continue;
            prop.Slot = x;
            dmgVals.add(prop);
        }
        if (dmgVals.size() > 0) {
            ISpecialArmor.ArmorProperties[] props = dmgVals.toArray(new ISpecialArmor.ArmorProperties[dmgVals.size()]);
            int level = props[0].Priority;
            double ratio = 0.0;
            for (ISpecialArmor.ArmorProperties prop : props) {
                if (level != prop.Priority) {
                    damage -= damage * ratio;
                    ratio = 0.0;
                    level = prop.Priority;
                }
                ratio += prop.AbsorbRatio;
            }
            damage -= damage * ratio;
        }
        return (float)(damage / 25.0);
    }

    public static float applyPotionDamageCalculations(EntityLivingBase attackedEntity, DamageSource source, float damage) {
        Potion resistance = MobEffects.field_76429_m;
        if (source.func_151517_h()) {
            return damage;
        }
        if (attackedEntity.func_70644_a(resistance) && source != DamageSource.field_76380_i) {
            int i = (attackedEntity.func_70660_b(resistance).func_76458_c() + 1) * 5;
            int j = 25 - i;
            float f = damage * (float)j;
            damage = f / 25.0f;
        }
        if (damage <= 0.0f) {
            return 0.0f;
        }
        int k = EnchantmentHelper.func_77508_a((Iterable)attackedEntity.func_184193_aE(), (DamageSource)source);
        if (k > 20) {
            k = 20;
        }
        if (k > 0 && k <= 20) {
            int l = 25 - k;
            float f1 = damage * (float)l;
            damage = f1 / 25.0f;
        }
        return damage;
    }

    @Deprecated
    public static boolean canCombine(ItemStack stack1, ItemStack stack2) {
        return stack1.func_190926_b() && !stack2.func_190926_b() || ItemHandlerHelper.canItemStacksStack((ItemStack)stack1, (ItemStack)stack2);
    }

    public static ItemStack[] combineStacks(ItemStack stack1, ItemStack stack2, int transferMax) {
        int transferedAmount;
        ItemStack[] returned = new ItemStack[2];
        if (ItemHandlerHelper.canItemStacksStack((ItemStack)stack1, (ItemStack)stack2) && (transferedAmount = Math.min(transferMax, stack2.func_190926_b() ? stack1.func_190916_E() : Math.min(stack2.func_77976_d() - stack2.func_190916_E(), stack1.func_190916_E()))) > 0) {
            ItemStack copyStack = stack1.func_77979_a(transferedAmount);
            if (stack2.func_190926_b()) {
                stack2 = copyStack;
            } else {
                stack2.func_190917_f(transferedAmount);
            }
        }
        returned[0] = stack1;
        returned[1] = stack2;
        return returned;
    }

    public static ItemStack[] combineStacks(ItemStack stack1, ItemStack stack2) {
        ItemStack[] returned = new ItemStack[2];
        if (ItemHandlerHelper.canItemStacksStack((ItemStack)stack1, (ItemStack)stack2)) {
            int transferedAmount;
            int n = transferedAmount = stack2.func_190926_b() ? stack1.func_190916_E() : Math.min(stack2.func_77976_d() - stack2.func_190916_E(), stack1.func_190916_E());
            if (transferedAmount > 0) {
                ItemStack copyStack = stack1.func_77979_a(transferedAmount);
                if (stack2.func_190926_b()) {
                    stack2 = copyStack;
                } else {
                    stack2.func_190917_f(transferedAmount);
                }
            }
        }
        returned[0] = stack1;
        returned[1] = stack2;
        return returned;
    }

    public static ItemStack insertStackIntoTile(ItemStack stack, TileEntity tile, EnumFacing dir) {
        if (tile.hasCapability(CapabilityItemHandler.ITEM_HANDLER_CAPABILITY, dir)) {
            IItemHandler handler = (IItemHandler)tile.getCapability(CapabilityItemHandler.ITEM_HANDLER_CAPABILITY, dir);
            return Utils.insertStackIntoTile(stack, handler);
        }
        if (tile instanceof IInventory) {
            return Utils.insertStackIntoInventory(stack, (IInventory)tile, dir);
        }
        return stack;
    }

    public static int getNumberOfFreeSlots(TileEntity tile, EnumFacing dir) {
        int slots;
        block3: {
            block2: {
                slots = 0;
                if (!tile.hasCapability(CapabilityItemHandler.ITEM_HANDLER_CAPABILITY, dir)) break block2;
                IItemHandler handler = (IItemHandler)tile.getCapability(CapabilityItemHandler.ITEM_HANDLER_CAPABILITY, dir);
                for (int i = 0; i < handler.getSlots(); ++i) {
                    if (!handler.getStackInSlot(i).func_190926_b()) continue;
                    ++slots;
                }
                break block3;
            }
            if (!(tile instanceof IInventory)) break block3;
            for (int i = 0; i < ((IInventory)tile).func_70302_i_(); ++i) {
                if (!((IInventory)tile).func_70301_a(i).func_190926_b()) continue;
                ++slots;
            }
        }
        return slots;
    }

    public static ItemStack insertStackIntoTile(ItemStack stack, IItemHandler handler) {
        int numberOfSlots = handler.getSlots();
        ItemStack copyStack = stack.func_77946_l();
        for (int slot = 0; slot < numberOfSlots; ++slot) {
            if (!(copyStack = handler.insertItem(slot, copyStack, false)).func_190926_b()) continue;
            return ItemStack.field_190927_a;
        }
        return copyStack;
    }

    public static ItemStack insertStackIntoTile(ItemStack stack, TileEntity tile, EnumFacing dir, int limit) {
        if (tile.hasCapability(CapabilityItemHandler.ITEM_HANDLER_CAPABILITY, dir)) {
            IItemHandler handler = (IItemHandler)tile.getCapability(CapabilityItemHandler.ITEM_HANDLER_CAPABILITY, dir);
            int numberOfSlots = handler.getSlots();
            ItemStack copyStack = stack.func_77946_l();
            int numberMatching = 0;
            for (int slot = 0; slot < numberOfSlots; ++slot) {
                ItemStack invStack = handler.getStackInSlot(slot);
                if (invStack.func_190926_b() || !ItemHandlerHelper.canItemStacksStack((ItemStack)stack, (ItemStack)invStack)) continue;
                numberMatching += invStack.func_190916_E();
            }
            if (numberMatching >= limit) {
                return stack;
            }
            int newLimit = limit - numberMatching;
            for (int slot = 0; slot < numberOfSlots; ++slot) {
                ItemStack newCopyStack = copyStack.func_77946_l();
                newCopyStack.func_190920_e(Math.min(copyStack.func_190916_E(), newLimit));
                newCopyStack = handler.insertItem(slot, newCopyStack, false);
                if (newCopyStack.func_190926_b()) {
                    return ItemStack.field_190927_a;
                }
                if ((newLimit -= copyStack.func_190916_E() - newCopyStack.func_190916_E()) <= 0) {
                    return ItemStack.field_190927_a;
                }
                copyStack.func_190918_g(copyStack.func_190916_E() - newCopyStack.func_190916_E());
            }
            return copyStack;
        }
        if (tile instanceof IInventory) {
            return Utils.insertStackIntoInventory(stack, (IInventory)tile, dir, limit);
        }
        return stack;
    }

    public static ItemStack insertStackIntoInventory(ItemStack stack, IInventory inventory, EnumFacing dir) {
        if (stack.func_190926_b()) {
            return ItemStack.field_190927_a;
        }
        boolean[] canBeInserted = new boolean[inventory.func_70302_i_()];
        if (inventory instanceof ISidedInventory) {
            int[] array;
            for (int in : array = ((ISidedInventory)inventory).func_180463_a(dir)) {
                canBeInserted[in] = inventory.func_94041_b(in, stack) && ((ISidedInventory)inventory).func_180462_a(in, stack, dir);
            }
        } else {
            for (int i = 0; i < canBeInserted.length; ++i) {
                canBeInserted[i] = inventory.func_94041_b(i, stack);
            }
        }
        for (int i = 0; i < inventory.func_70302_i_(); ++i) {
            if (!canBeInserted[i]) continue;
            ItemStack[] combinedStacks = Utils.combineStacks(stack, inventory.func_70301_a(i));
            stack = combinedStacks[0];
            inventory.func_70299_a(i, combinedStacks[1]);
            if (!stack.func_190926_b()) continue;
            return ItemStack.field_190927_a;
        }
        return stack;
    }

    public static boolean canInsertStackFullyIntoInventory(ItemStack stack, IInventory inventory, EnumFacing dir) {
        return Utils.canInsertStackFullyIntoInventory(stack, inventory, dir, false, 0);
    }

    public static boolean canInsertStackFullyIntoInventory(ItemStack stack, IInventory inventory, EnumFacing dir, boolean fillToLimit, int limit) {
        if (stack.func_190926_b()) {
            return true;
        }
        int itemsLeft = stack.func_190916_E();
        boolean[] canBeInserted = new boolean[inventory.func_70302_i_()];
        if (inventory instanceof ISidedInventory) {
            int[] array;
            for (int in : array = ((ISidedInventory)inventory).func_180463_a(dir)) {
                canBeInserted[in] = inventory.func_94041_b(in, stack) && ((ISidedInventory)inventory).func_180462_a(in, stack, dir);
            }
        } else {
            for (int i = 0; i < canBeInserted.length; ++i) {
                canBeInserted[i] = inventory.func_94041_b(i, stack);
            }
        }
        int numberMatching = 0;
        if (fillToLimit) {
            for (int i = 0; i < inventory.func_70302_i_(); ++i) {
                ItemStack invStack;
                if (!canBeInserted[i] || (invStack = inventory.func_70301_a(i)).func_190926_b() || !ItemHandlerHelper.canItemStacksStack((ItemStack)stack, (ItemStack)invStack)) continue;
                numberMatching += invStack.func_190916_E();
            }
        }
        if (fillToLimit && limit < stack.func_190916_E() + numberMatching) {
            return false;
        }
        for (int i = 0; i < inventory.func_70302_i_(); ++i) {
            if (!canBeInserted[i]) continue;
            ItemStack invStack = inventory.func_70301_a(i);
            boolean canCombine = Utils.canCombine(stack, invStack);
            if (canCombine) {
                itemsLeft = invStack.func_190926_b() ? 0 : (itemsLeft -= invStack.func_77976_d() - invStack.func_190916_E());
            }
            if (itemsLeft > 0) continue;
            return true;
        }
        return false;
    }

    public static ItemStack insertStackIntoInventory(ItemStack stack, IInventory inventory, EnumFacing dir, int limit) {
        if (stack.func_190926_b()) {
            return ItemStack.field_190927_a;
        }
        boolean[] canBeInserted = new boolean[inventory.func_70302_i_()];
        if (inventory instanceof ISidedInventory) {
            int[] array;
            for (int in : array = ((ISidedInventory)inventory).func_180463_a(dir)) {
                canBeInserted[in] = ((ISidedInventory)inventory).func_180462_a(in, stack, dir);
            }
        } else {
            for (int i = 0; i < canBeInserted.length; ++i) {
                canBeInserted[i] = true;
            }
        }
        int numberMatching = 0;
        for (int i = 0; i < inventory.func_70302_i_(); ++i) {
            ItemStack invStack;
            if (!canBeInserted[i] || (invStack = inventory.func_70301_a(i)).func_190926_b() || !Utils.canCombine(stack, invStack)) continue;
            numberMatching += invStack.func_190916_E();
        }
        if (numberMatching >= limit) {
            return stack;
        }
        int newLimit = limit - numberMatching;
        for (int i = 0; i < inventory.func_70302_i_(); ++i) {
            if (!canBeInserted[i]) continue;
            int prevStackSize = stack.func_190916_E();
            ItemStack[] combinedStacks = Utils.combineStacks(stack, inventory.func_70301_a(i), newLimit);
            stack = combinedStacks[0];
            inventory.func_70299_a(i, combinedStacks[1]);
            if ((newLimit -= prevStackSize - stack.func_190916_E()) > 0 && !stack.func_190926_b()) continue;
            return stack;
        }
        return stack;
    }

    public static boolean isBlockLiquid(IBlockState state) {
        return state instanceof IFluidBlock || state.func_185904_a().func_76224_d();
    }

    public static boolean isFlowingLiquid(IBlockState state) {
        Block block = state.func_177230_c();
        return Utils.isBlockLiquid(state) && state != block.func_176223_P();
    }

    public static boolean spawnStackAtBlock(World world, BlockPos pos, @Nullable EnumFacing pushDirection, ItemStack stack) {
        EntityItem entityItem = new EntityItem(world);
        BlockPos spawnPos = new BlockPos((Vec3i)pos);
        double velocity = 0.15;
        if (pushDirection != null) {
            spawnPos.func_177972_a(pushDirection);
            switch (pushDirection) {
                case DOWN: {
                    entityItem.field_70181_x = -velocity;
                    entityItem.func_70107_b((double)spawnPos.func_177958_n() + 0.5, (double)spawnPos.func_177956_o() - 1.0, (double)spawnPos.func_177952_p() + 0.5);
                    break;
                }
                case UP: {
                    entityItem.field_70181_x = velocity;
                    entityItem.func_70107_b((double)spawnPos.func_177958_n() + 0.5, (double)spawnPos.func_177956_o() + 1.0, (double)spawnPos.func_177952_p() + 0.5);
                    break;
                }
                case NORTH: {
                    entityItem.field_70179_y = -velocity;
                    entityItem.func_70107_b((double)spawnPos.func_177958_n() + 0.5, (double)spawnPos.func_177956_o() + 0.5, (double)spawnPos.func_177952_p() - 1.0);
                    break;
                }
                case SOUTH: {
                    entityItem.field_70179_y = velocity;
                    entityItem.func_70107_b((double)spawnPos.func_177958_n() + 0.5, (double)spawnPos.func_177956_o() + 0.5, (double)spawnPos.func_177952_p() + 1.0);
                    break;
                }
                case WEST: {
                    entityItem.field_70159_w = -velocity;
                    entityItem.func_70107_b((double)spawnPos.func_177958_n() - 1.0, (double)spawnPos.func_177956_o() + 0.5, (double)spawnPos.func_177952_p() + 0.5);
                    break;
                }
                case EAST: {
                    entityItem.field_70159_w = velocity;
                    entityItem.func_70107_b((double)spawnPos.func_177958_n() + 1.0, (double)spawnPos.func_177956_o() + 0.5, (double)spawnPos.func_177952_p() + 0.5);
                }
            }
        }
        entityItem.func_92058_a(stack);
        return world.func_72838_d((Entity)entityItem);
    }

    public static boolean swapLocations(World initialWorld, BlockPos initialPos, World finalWorld, BlockPos finalPos) {
        return Utils.swapLocations(initialWorld, initialPos, finalWorld, finalPos, true);
    }

    public static boolean swapLocations(World initialWorld, BlockPos initialPos, World finalWorld, BlockPos finalPos, boolean playSound) {
        TileEntity initialTile = initialWorld.func_175625_s(initialPos);
        TileEntity finalTile = finalWorld.func_175625_s(finalPos);
        NBTTagCompound initialTag = new NBTTagCompound();
        NBTTagCompound finalTag = new NBTTagCompound();
        if (initialTile != null) {
            initialTile.func_189515_b(initialTag);
        }
        if (finalTile != null) {
            finalTile.func_189515_b(finalTag);
        }
        IBlockState initialState = initialWorld.func_180495_p(initialPos);
        IBlockState finalState = finalWorld.func_180495_p(finalPos);
        if (initialState.func_177230_c().equals(Blocks.field_150350_a) && finalState.func_177230_c().equals(Blocks.field_150350_a) || initialState.func_177230_c() instanceof BlockPortal || finalState.func_177230_c() instanceof BlockPortal) {
            return false;
        }
        if (playSound) {
            initialWorld.func_184134_a((double)initialPos.func_177958_n(), (double)initialPos.func_177956_o(), (double)initialPos.func_177952_p(), SoundEvents.field_187534_aX, SoundCategory.AMBIENT, 1.0f, 1.0f, false);
            finalWorld.func_184134_a((double)finalPos.func_177958_n(), (double)finalPos.func_177956_o(), (double)finalPos.func_177952_p(), SoundEvents.field_187534_aX, SoundCategory.AMBIENT, 1.0f, 1.0f, false);
        }
        if (finalState.func_177230_c().hasTileEntity(finalState)) {
            finalWorld.func_175713_t(finalPos);
        }
        if (initialState.func_177230_c().hasTileEntity(initialState)) {
            initialWorld.func_175713_t(initialPos);
        }
        IBlockState initialBlockState = initialWorld.func_180495_p(initialPos);
        IBlockState finalBlockState = finalWorld.func_180495_p(finalPos);
        finalWorld.func_180501_a(finalPos, initialBlockState, 3);
        if (initialTile != null) {
            TileEntity newTileInitial = TileEntity.func_190200_a((World)finalWorld, (NBTTagCompound)initialTag);
            finalWorld.func_175690_a(finalPos, newTileInitial);
            newTileInitial.func_174878_a(finalPos);
            newTileInitial.func_145834_a(finalWorld);
        }
        initialWorld.func_180501_a(initialPos, finalBlockState, 3);
        if (finalTile != null) {
            TileEntity newTileFinal = TileEntity.func_190200_a((World)initialWorld, (NBTTagCompound)finalTag);
            initialWorld.func_175690_a(initialPos, newTileFinal);
            newTileFinal.func_174878_a(initialPos);
            newTileFinal.func_145834_a(initialWorld);
        }
        initialWorld.func_175685_c(initialPos, finalState.func_177230_c(), true);
        finalWorld.func_175685_c(finalPos, initialState.func_177230_c(), true);
        return true;
    }

    public static ItemStack consumeItem(ItemStack stack) {
        boolean largerStack;
        Item item = stack.func_77973_b();
        boolean bl = largerStack = stack.func_190916_E() > 1;
        if (largerStack) {
            stack.func_190918_g(1);
        }
        if (item.hasContainerItem(stack)) {
            ItemStack ret = item.getContainerItem(stack);
            if (ret.func_190926_b()) {
                return ItemStack.field_190927_a;
            }
            if (ret.func_77984_f() && ret.func_77952_i() > ret.func_77958_k()) {
                ret = ItemStack.field_190927_a;
            }
            return ret;
        }
        return largerStack ? stack : ItemStack.field_190927_a;
    }

    public static boolean hasUUID(ItemStack stack) {
        return stack.func_77942_o() && stack.func_77978_p().func_74764_b("mostSig") && stack.func_77978_p().func_74764_b("leastSig");
    }

    public static UUID getUUID(ItemStack stack) {
        if (!Utils.hasUUID(stack)) {
            return null;
        }
        return new UUID(stack.func_77978_p().func_74763_f("mostSig"), stack.func_77978_p().func_74763_f("leastSig"));
    }

    public static void setUUID(ItemStack stack) {
        if (!(stack = NBTHelper.checkNBT(stack)).func_77978_p().func_74764_b("mostSig") && !stack.func_77978_p().func_74764_b("leastSig")) {
            UUID itemUUID = UUID.randomUUID();
            stack.func_77978_p().func_74772_a("mostSig", itemUUID.getMostSignificantBits());
            stack.func_77978_p().func_74772_a("leastSig", itemUUID.getLeastSignificantBits());
        }
    }

    public static RayTraceResult rayTrace(EntityPlayer player, boolean useLiquids) {
        float pitch = player.field_70125_A;
        float yaw = player.field_70177_z;
        Vec3d eyePosition = new Vec3d(player.field_70165_t, player.field_70163_u + (double)player.func_70047_e(), player.field_70161_v);
        float f2 = MathHelper.func_76134_b((float)(-yaw * ((float)Math.PI / 180) - (float)Math.PI));
        float f3 = MathHelper.func_76126_a((float)(-yaw * ((float)Math.PI / 180) - (float)Math.PI));
        float f4 = -MathHelper.func_76134_b((float)(-pitch * ((float)Math.PI / 180)));
        float f5 = MathHelper.func_76126_a((float)(-pitch * ((float)Math.PI / 180)));
        float f6 = f3 * f4;
        float f7 = f2 * f4;
        double reachDistance = 5.0;
        if (player instanceof EntityPlayerMP) {
            reachDistance = ((EntityPlayerMP)player).field_71134_c.getBlockReachDistance();
        }
        Vec3d reachPosition = eyePosition.func_72441_c((double)f6 * reachDistance, (double)f5 * reachDistance, (double)f7 * reachDistance);
        return player.func_130014_f_().func_147447_a(eyePosition, reachPosition, useLiquids, !useLiquids, false);
    }

    static {
        try {
            Field colorValue = ObfuscationReflectionHelper.findField(EnumDyeColor.class, (String)"field_193351_w");
            colorValue.setAccessible(true);
            for (EnumDyeColor color : EnumDyeColor.values()) {
                DYE_COLOR_VALUES.put(color, (int)((Integer)colorValue.get(color)));
            }
        }
        catch (IllegalAccessException e) {
            BMLog.DEFAULT.error("Error grabbing color values: {}", e.getMessage());
        }
    }
}

