/*
 * Decompiled with CFR 0.152.
 */
package WayofTime.bloodmagic.api.event;

import net.minecraft.item.ItemStack;
import net.minecraftforge.fml.common.eventhandler.Event;

public class BloodMagicCraftedEvent
extends Event {
    private final boolean modifiable;
    private final ItemStack[] inputs;
    private ItemStack output;

    public BloodMagicCraftedEvent(ItemStack output, ItemStack[] inputs, boolean modifiable) {
        this.modifiable = modifiable;
        this.inputs = inputs;
        this.output = output;
    }

    public boolean isModifiable() {
        return this.modifiable;
    }

    public ItemStack[] getInputs() {
        return this.inputs;
    }

    public ItemStack getOutput() {
        return this.output;
    }

    public void setOutput(ItemStack output) {
        if (this.isModifiable()) {
            this.output = output;
        }
    }

    public static class AlchemyTable
    extends BloodMagicCraftedEvent {
        public AlchemyTable(ItemStack output, ItemStack[] inputs) {
            super(output, inputs, true);
        }
    }

    public static class SoulForge
    extends BloodMagicCraftedEvent {
        public SoulForge(ItemStack output, ItemStack[] inputs) {
            super(output, inputs, true);
        }
    }

    public static class Altar
    extends BloodMagicCraftedEvent {
        public Altar(ItemStack output, ItemStack input) {
            super(output, new ItemStack[]{input}, true);
        }
    }
}

