/*
 * Decompiled with CFR 0.152.
 */
package net.malisis.switches.network;

import io.netty.buffer.ByteBuf;
import net.malisis.core.network.IMalisisMessageHandler;
import net.malisis.core.registry.AutoLoad;
import net.malisis.core.util.EntityUtils;
import net.malisis.switches.MalisisSwitches;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.item.Item;
import net.minecraft.util.EnumFacing;
import net.minecraft.util.EnumHand;
import net.minecraft.util.math.BlockPos;
import net.minecraftforge.fml.common.network.simpleimpl.IMessage;
import net.minecraftforge.fml.common.network.simpleimpl.IMessageHandler;
import net.minecraftforge.fml.common.network.simpleimpl.MessageContext;
import net.minecraftforge.fml.relauncher.Side;

@AutoLoad(value=true)
public class PowerLinkerMessage
implements IMalisisMessageHandler<Packet, IMessage> {
    public PowerLinkerMessage() {
        MalisisSwitches.network.registerMessage((IMessageHandler)this, Packet.class, Side.SERVER);
    }

    public void process(Packet message, MessageContext ctx) {
        EntityPlayer player = IMalisisMessageHandler.getPlayer((MessageContext)ctx);
        if (!EntityUtils.isEquipped((EntityPlayer)player, (Item)MalisisSwitches.Items.powerLinker, (EnumHand)EnumHand.MAIN_HAND)) {
            return;
        }
        MalisisSwitches.Items.powerLinker.processClick(player, message.hand, IMalisisMessageHandler.getWorld((MessageContext)ctx), message.pos, message.side);
    }

    public static void sendClick(BlockPos pos, EnumHand hand, EnumFacing side) {
        MalisisSwitches.network.sendToServer((IMessage)new Packet(pos, hand, side));
    }

    public static class Packet
    implements IMessage {
        private BlockPos pos;
        private EnumHand hand;
        private EnumFacing side;

        public Packet(BlockPos pos, EnumHand hand, EnumFacing side) {
            this.pos = pos;
            this.hand = hand;
            this.side = side;
        }

        public Packet() {
        }

        public void fromBytes(ByteBuf buf) {
            this.pos = BlockPos.func_177969_a((long)buf.readLong());
            this.hand = EnumHand.values()[buf.readInt()];
            this.side = EnumFacing.func_82600_a((int)buf.readInt());
        }

        public void toBytes(ByteBuf buf) {
            buf.writeLong(this.pos.func_177986_g());
            buf.writeInt(this.hand.ordinal());
            buf.writeInt(this.side.func_176745_a());
        }
    }
}

