/*
 * Decompiled with CFR 0.152.
 */
package thelm.jaopca.ore;

import com.google.common.collect.Lists;
import com.google.common.collect.Maps;
import de.androidpit.colorthief.ColorThief;
import java.awt.Color;
import java.awt.image.BufferedImage;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.stream.Collectors;
import net.minecraft.client.Minecraft;
import net.minecraft.client.renderer.block.model.BakedQuad;
import net.minecraft.client.renderer.block.model.IBakedModel;
import net.minecraft.client.renderer.texture.TextureAtlasSprite;
import net.minecraft.item.ItemStack;
import net.minecraft.util.EnumFacing;
import net.minecraft.util.NonNullList;
import net.minecraft.util.math.MathHelper;
import net.minecraftforge.oredict.OreDictionary;
import thelm.jaopca.api.utils.Utils;
import thelm.jaopca.utils.JAOPCAConfig;

public class OreColorer {
    public static final HashMap<String, Color> DEFAULT_COLORS = Maps.newHashMap();

    public static Color getColor(String prefix, String oreName) {
        if (DEFAULT_COLORS.containsKey(oreName)) {
            return DEFAULT_COLORS.get(oreName);
        }
        NonNullList<ItemStack> ores = Utils.getOres(prefix + oreName);
        if (ores.isEmpty()) {
            return Color.WHITE;
        }
        ArrayList colors = Lists.newArrayList();
        for (ItemStack stack : ores) {
            List quads = OreColorer.getBakedQuads(stack).stream().sorted((quad0, quad1) -> Integer.compare(quad1.func_178211_c(), quad0.func_178211_c())).collect(Collectors.toList());
            if (quads.isEmpty()) continue;
            for (BakedQuad quad : quads) {
                int[] texColor;
                int pixelCount;
                int colorMultiplier = OreColorer.getColorMultiplier(stack, quad);
                BufferedImage texture = OreColorer.getBufferedImage(quad.func_187508_a());
                if (texture == null || (pixelCount = OreColorer.getPixelCount(texture)) == 0 || (texColor = OreColorer.getTextureColor(texture)) == null) continue;
                int[] colorAndCount = new int[]{(int)Math.round(MathHelper.func_151237_a((double)((double)(texColor[0] * (colorMultiplier >> 16 & 0xFF)) / 255.0), (double)0.0, (double)255.0)), (int)Math.round(MathHelper.func_151237_a((double)((double)(texColor[1] * (colorMultiplier >> 8 & 0xFF)) / 255.0), (double)0.0, (double)255.0)), (int)Math.round(MathHelper.func_151237_a((double)((double)(texColor[2] * (colorMultiplier & 0xFF)) / 255.0), (double)0.0, (double)255.0)), pixelCount};
                colors.add(colorAndCount);
            }
        }
        if (colors.size() == 0) {
            return Color.WHITE;
        }
        double count = 0.0;
        long red = 0L;
        long green = 0L;
        long blue = 0L;
        for (int[] c : colors) {
            red += (long)(c[0] * c[0] * c[3]);
            green += (long)(c[1] * c[1] * c[3]);
            blue += (long)(c[2] * c[2] * c[3]);
            count += (double)c[3];
        }
        return new Color((int)Math.round(MathHelper.func_151237_a((double)Math.sqrt((double)red / count), (double)0.0, (double)255.0)), (int)Math.round(MathHelper.func_151237_a((double)Math.sqrt((double)green / count), (double)0.0, (double)255.0)), (int)Math.round(MathHelper.func_151237_a((double)Math.sqrt((double)blue / count), (double)0.0, (double)255.0)));
    }

    private static int[] getTextureColor(BufferedImage image) {
        switch (JAOPCAConfig.colorMode) {
            default: {
                Color color = OreColorer.getAverageColorFromTexture(image);
                return new int[]{color.getRed(), color.getGreen(), color.getBlue()};
            }
            case 1: 
        }
        int[][] texColors = ColorThief.getPalette(image, 4);
        if (texColors == null) {
            return null;
        }
        return texColors[0];
    }

    private static int getPixelCount(BufferedImage image) {
        int count = 0;
        for (int i = 0; i < image.getWidth(); ++i) {
            for (int j = 0; j < image.getHeight(); ++j) {
                Color color = new Color(image.getRGB(i, j), true);
                if (color.getAlpha() < 50) continue;
                ++count;
            }
        }
        return count;
    }

    private static Color getAverageColorFromTexture(BufferedImage image) {
        long red = 0L;
        long green = 0L;
        long blue = 0L;
        double count = 0.0;
        for (int i = 0; i < image.getWidth(); ++i) {
            for (int j = 0; j < image.getHeight(); ++j) {
                Color color = new Color(image.getRGB(i, j), true);
                if (color.getAlpha() < 50) continue;
                red += (long)(color.getRed() * color.getRed());
                green += (long)(color.getGreen() * color.getGreen());
                blue += (long)(color.getBlue() * color.getBlue());
                count += 1.0;
            }
        }
        if (count == 0.0) {
            return Color.WHITE;
        }
        return new Color((int)MathHelper.func_151237_a((double)Math.sqrt((double)red / count), (double)0.0, (double)255.0), (int)MathHelper.func_151237_a((double)Math.sqrt((double)green / count), (double)0.0, (double)255.0), (int)MathHelper.func_151237_a((double)Math.sqrt((double)blue / count), (double)0.0, (double)255.0)).brighter();
    }

    private static BufferedImage getBufferedImage(TextureAtlasSprite textureAtlasSprite) {
        if (textureAtlasSprite == null) {
            return null;
        }
        int iconWidth = textureAtlasSprite.func_94211_a();
        int iconHeight = textureAtlasSprite.func_94216_b();
        int frameCount = textureAtlasSprite.func_110970_k();
        if (iconWidth <= 0 || iconHeight <= 0 || frameCount <= 0) {
            return null;
        }
        BufferedImage bufferedImage = new BufferedImage(iconWidth, iconHeight * frameCount, 6);
        for (int i = 0; i < frameCount; ++i) {
            int[][] frameTextureData = textureAtlasSprite.func_147965_a(i);
            int[] largestMipMapTextureData = frameTextureData[0];
            bufferedImage.setRGB(0, i * iconHeight, iconWidth, iconHeight, largestMipMapTextureData, 0, iconWidth);
        }
        return bufferedImage;
    }

    private static List<BakedQuad> getBakedQuads(ItemStack itemStack) {
        IBakedModel model = Minecraft.func_71410_x().func_175599_af().func_184393_a(itemStack, null, null);
        ArrayList list = Lists.newArrayList();
        for (EnumFacing facing : EnumFacing.values()) {
            list.addAll(model.func_188616_a(null, facing, 0L).stream().filter(quad -> quad.func_178210_d() == EnumFacing.SOUTH).collect(Collectors.toList()));
        }
        list.addAll(model.func_188616_a(null, null, 0L).stream().filter(quad -> quad.func_178210_d() == EnumFacing.SOUTH).collect(Collectors.toList()));
        return list;
    }

    private static int getColorMultiplier(ItemStack itemStack, BakedQuad quad) {
        return Minecraft.func_71410_x().getItemColors().func_186728_a(itemStack, quad.func_178211_c());
    }

    public static boolean getHasEffect(String prefix, String oreName) {
        NonNullList ores = OreDictionary.getOres((String)(prefix + oreName), (boolean)false);
        if (ores.isEmpty()) {
            return false;
        }
        for (ItemStack ore : ores) {
            if (!ore.func_77962_s()) continue;
            return true;
        }
        return false;
    }
}

