/*
 * Decompiled with CFR 0.152.
 */
package thelm.jaopca.api.fluid;

import net.minecraft.item.EnumRarity;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.SoundEvent;
import net.minecraftforge.fluids.Fluid;
import net.minecraftforge.fluids.FluidStack;
import thelm.jaopca.api.IOreEntry;
import thelm.jaopca.api.ItemEntry;
import thelm.jaopca.api.fluid.IFluidWithProperty;
import thelm.jaopca.api.utils.Utils;

public class FluidBase
extends Fluid
implements IFluidWithProperty {
    public final IOreEntry oreEntry;
    public final ItemEntry itemEntry;
    protected int opacity = 255;

    public FluidBase(ItemEntry itemEntry, IOreEntry oreEntry) {
        super((itemEntry.prefix.isEmpty() ? "" : itemEntry.prefix + '_') + Utils.to_under_score(oreEntry.getOreName()), new ResourceLocation("jaopca:fluids/" + Utils.to_under_score(itemEntry.name) + "_still"), new ResourceLocation("jaopca:fluids/" + Utils.to_under_score(itemEntry.name) + "_flowing"));
        this.setUnlocalizedName("jaopca." + itemEntry.name);
        this.oreEntry = oreEntry;
        this.itemEntry = itemEntry;
    }

    @Override
    public IOreEntry getOreEntry() {
        return this.oreEntry;
    }

    @Override
    public ItemEntry getItemEntry() {
        return this.itemEntry;
    }

    @Override
    public FluidBase setLuminosity(int luminosity) {
        super.setLuminosity(luminosity);
        return this;
    }

    @Override
    public FluidBase setDensity(int density) {
        super.setDensity(density);
        return this;
    }

    @Override
    public FluidBase setTemperature(int temperature) {
        super.setTemperature(temperature);
        return this;
    }

    @Override
    public FluidBase setViscosity(int viscosity) {
        super.setViscosity(viscosity);
        return this;
    }

    @Override
    public FluidBase setGaseous(boolean isGaseous) {
        super.setGaseous(isGaseous);
        return this;
    }

    @Override
    public FluidBase setRarity(EnumRarity rarity) {
        super.setRarity(rarity);
        return this;
    }

    @Override
    public FluidBase setFillSound(SoundEvent fillSound) {
        super.setFillSound(fillSound);
        return this;
    }

    @Override
    public FluidBase setEmptySound(SoundEvent emptySound) {
        super.setEmptySound(emptySound);
        return this;
    }

    @Override
    public FluidBase setOpacity(int opacity) {
        this.opacity = opacity;
        return this;
    }

    public int getColor() {
        return this.oreEntry.getColor() & 0xFFFFFF | this.opacity << 24;
    }

    public String getLocalizedName(FluidStack stack) {
        return Utils.smartLocalize(this.getUnlocalizedName(), this.getUnlocalizedName() + ".%s", this.getOreEntry());
    }
}

