/*
 * Decompiled with CFR 0.152.
 */
package net.machinemuse.numina.client.sound;

import java.util.HashMap;
import net.machinemuse.numina.basemod.MuseLogger;
import net.machinemuse.numina.client.sound.MovingSoundPlayer;
import net.machinemuse.numina.config.NuminaConfig;
import net.minecraft.client.Minecraft;
import net.minecraft.client.audio.ISound;
import net.minecraft.client.audio.PositionedSoundRecord;
import net.minecraft.client.audio.SoundHandler;
import net.minecraft.client.settings.GameSettings;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.SoundCategory;
import net.minecraft.util.SoundEvent;
import net.minecraft.util.math.BlockPos;
import net.minecraftforge.fml.common.FMLCommonHandler;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;

@SideOnly(value=Side.CLIENT)
public class Musique {
    private static HashMap<String, MovingSoundPlayer> soundMap = new HashMap();

    public static SoundHandler mcsound() {
        return Minecraft.func_71410_x().func_147118_V();
    }

    public static void playClientSound(SoundEvent soundEvt, SoundCategory categoryIn, float volumeIn, BlockPos posIn) {
        if (FMLCommonHandler.instance().getEffectiveSide() == Side.CLIENT && NuminaConfig.useSounds()) {
            BlockPos pos = posIn != null ? posIn : Minecraft.func_71410_x().field_71439_g.func_180425_c();
            PositionedSoundRecord sound = new PositionedSoundRecord(soundEvt, categoryIn, volumeIn, 1.0f, pos);
            Musique.mcsound().func_147682_a((ISound)sound);
        }
    }

    public static String makeSoundString(EntityPlayer player, SoundEvent soundEvt) {
        return Musique.makeSoundString(player, soundEvt.func_187503_a());
    }

    public static String makeSoundString(EntityPlayer player, ResourceLocation soundname) {
        return player.func_110124_au().toString() + soundname;
    }

    public static void playerSound(EntityPlayer player, ResourceLocation location, SoundCategory categoryIn, float volume, Float pitch, Boolean continuous) {
        SoundEvent soundEvent = (SoundEvent)SoundEvent.field_187505_a.func_82594_a((Object)location);
        if (soundEvent != null) {
            Musique.playerSound(player, soundEvent, categoryIn, volume, pitch, continuous);
        } else {
            soundEvent = new SoundEvent(location);
            if (soundEvent != null) {
                Musique.playerSound(player, soundEvent, categoryIn, volume, pitch, continuous);
            } else {
                MuseLogger.logError("Sound event not found for " + location.toString());
            }
        }
    }

    public static void playerSound(EntityPlayer player, SoundEvent soundEvt, SoundCategory categoryIn, float volume, Float pitch, Boolean continuous) {
        pitch = Float.valueOf(pitch != null ? pitch.floatValue() : 1.0f);
        continuous = continuous != null ? continuous : true;
        if (FMLCommonHandler.instance().getEffectiveSide() == Side.CLIENT && NuminaConfig.useSounds() && soundEvt != null) {
            String soundID = Musique.makeSoundString(player, soundEvt);
            MovingSoundPlayer sound = soundMap.get(soundID);
            if (sound != null && (sound.func_147667_k() || !sound.func_147657_c())) {
                Musique.stopPlayerSound(player, soundEvt);
                sound = null;
            }
            if (sound != null) {
                sound.updateVolume(volume).updatePitch(pitch.floatValue()).updateRepeat(continuous);
            } else {
                MovingSoundPlayer newsound = new MovingSoundPlayer(soundEvt, categoryIn, player, volume * 2.0f, pitch.floatValue(), continuous);
                Musique.mcsound().func_147682_a((ISound)newsound);
                soundMap.put(soundID, newsound);
            }
        }
    }

    public static void stopPlayerSound(EntityPlayer player, ResourceLocation location) {
        SoundEvent soundEvent = (SoundEvent)SoundEvent.field_187505_a.func_82594_a((Object)location);
        if (soundEvent != null) {
            Musique.stopPlayerSound(player, soundEvent);
        } else {
            soundEvent = new SoundEvent(location);
            if (soundEvent != null) {
                Musique.stopPlayerSound(player, soundEvent);
            } else {
                MuseLogger.logError("Sound event not found for " + location.toString());
            }
        }
    }

    public static void stopPlayerSound(EntityPlayer player, SoundEvent soundEvt) {
        if (FMLCommonHandler.instance().getEffectiveSide() == Side.CLIENT && NuminaConfig.useSounds()) {
            String soundID = Musique.makeSoundString(player, soundEvt);
            MovingSoundPlayer sound = soundMap.get(soundID);
            if (sound != null) {
                sound.stopPlaying();
                Musique.mcsound().func_147683_b((ISound)sound);
            }
            soundMap.remove(soundID);
        }
    }

    public GameSettings options() {
        return Minecraft.func_71410_x().field_71474_y;
    }
}

