/*
 * Decompiled with CFR 0.152.
 */
package codechicken.lib.render.pipeline.attribute;

import codechicken.lib.colour.ColourRGBA;
import codechicken.lib.render.CCRenderState;
import codechicken.lib.render.pipeline.VertexAttribute;
import codechicken.lib.render.pipeline.attribute.AttributeKey;

public class LightingAttribute
extends VertexAttribute<int[]> {
    public static final AttributeKey<int[]> attributeKey = new AttributeKey<int[]>(){

        @Override
        public int[] newArray(int length) {
            return new int[length];
        }
    };
    private int[] colourRef;

    @Override
    public int[] newArray(int length) {
        return new int[length];
    }

    @Override
    public String getAttribName() {
        return "lightingAttrib";
    }

    @Override
    public boolean load(CCRenderState state) {
        if (!(state.computeLighting && state.fmt.func_177346_d() && state.model.hasAttribute(attributeKey))) {
            return false;
        }
        this.colourRef = state.model.getAttributes(attributeKey);
        if (this.colourRef != null) {
            state.pipeline.addDependency(state.colourAttrib);
            return true;
        }
        return false;
    }

    @Override
    public void operate(CCRenderState state) {
        state.colour = ColourRGBA.multiply(state.colour, this.colourRef[state.vertexIndex]);
    }
}

