/*
 * Decompiled with CFR 0.152.
 */
package forestry.storage.models;

import com.google.common.collect.ImmutableList;
import forestry.core.models.BlankModel;
import forestry.core.models.TRSRBakedModel;
import forestry.core.utils.ModelUtil;
import java.util.List;
import javax.annotation.Nullable;
import javax.vecmath.Vector3f;
import net.minecraft.block.state.IBlockState;
import net.minecraft.client.renderer.block.model.BakedQuad;
import net.minecraft.client.renderer.block.model.IBakedModel;
import net.minecraft.client.renderer.block.model.ItemCameraTransforms;
import net.minecraft.item.ItemStack;
import net.minecraft.util.EnumFacing;
import net.minecraftforge.client.model.BakedItemModel;
import net.minecraftforge.common.model.TRSRTransformation;

public class ModelCrateBaked
extends BlankModel {
    private static final float CONTENT_RENDER_OFFSET_X = 0.0625f;
    private static final float CONTENT_RENDER_OFFSET_Z = 0.0078125f;
    private static final float CONTENT_RENDER_BLOCK_Z_SCALE = 0.078125f;
    private ContentModel contentModel;

    ModelCrateBaked(List<BakedQuad> quads) {
        this.contentModel = new ContentModel(quads);
    }

    ModelCrateBaked(List<BakedQuad> quads, ItemStack content) {
        this.contentModel = new RawContentModel(quads, content);
    }

    @Override
    public List<BakedQuad> func_188616_a(@Nullable IBlockState state, @Nullable EnumFacing side, long rand) {
        if (side != null) {
            return ImmutableList.of();
        }
        if (this.contentModel.hasBakedModel()) {
            this.contentModel = this.contentModel.bake();
        }
        return this.contentModel.getQuads();
    }

    private class RawContentModel
    extends ContentModel {
        private final ItemStack content;

        private RawContentModel(List<BakedQuad> quads, ItemStack content) {
            super(quads);
            this.content = content;
        }

        @Override
        public ContentModel bake() {
            IBakedModel bakedModel = ModelUtil.getModel(this.content);
            if (bakedModel != null) {
                IBakedModel guiModel = (IBakedModel)bakedModel.handlePerspective(ItemCameraTransforms.TransformType.GUI).getKey();
                if (bakedModel instanceof BakedItemModel) {
                    TRSRTransformation frontTransform = new TRSRTransformation(new Vector3f(-0.0625f, 0.0f, 0.0078125f), null, new Vector3f(0.5f, 0.5f, 1.0f), null);
                    TRSRBakedModel frontModel = new TRSRBakedModel(guiModel, frontTransform);
                    this.quads.addAll(frontModel.func_188616_a(null, null, 0L));
                    TRSRTransformation backTransform = new TRSRTransformation(new Vector3f(-0.0625f, 0.0f, -0.0078125f), null, new Vector3f(0.5f, 0.5f, 1.0f), TRSRTransformation.quatFromYXZ((float)((float)Math.PI), (float)0.0f, (float)0.0f));
                    TRSRBakedModel backModel = new TRSRBakedModel(guiModel, backTransform);
                    this.quads.addAll(backModel.func_188616_a(null, null, 0L));
                } else {
                    TRSRTransformation frontTransform = new TRSRTransformation(new Vector3f(-0.0625f, 0.0f, 0.0f), null, new Vector3f(0.5f, 0.5f, 0.078125f), null);
                    TRSRBakedModel frontModel = new TRSRBakedModel(guiModel, frontTransform);
                    this.quads.addAll(frontModel.func_188616_a(null, null, 0L));
                }
            }
            return new ContentModel(this.quads);
        }

        @Override
        public boolean hasBakedModel() {
            return true;
        }
    }

    private class ContentModel {
        final List<BakedQuad> quads;

        private ContentModel(List<BakedQuad> quads) {
            this.quads = quads;
        }

        public List<BakedQuad> getQuads() {
            return this.quads;
        }

        public ContentModel bake() {
            return this;
        }

        public boolean hasBakedModel() {
            return false;
        }
    }
}

